'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc overview
     * @name index
     * @description
     *
     * # Eureka Documentation
     *
     * Do you need help understanding the project structure or what services and directives you have available to you
     * in the Eureka Angular application? You've come to the right place!
     *
     * ## How to use this documentation
     *
     * This code-base is self-documenting; this documentation is automatically generated from comments left throughout
     * the code. If there is a problem with it, it is because the comments in the code were not updated.
     *
     * This project is broken down into several modules. Each module represents a section of the application. Inside
     * each module you will find views, directives, and services specific to that module. This allows you to bite off
     * code changes in smaller pieces and keeps everything organized in a sane manner.
     */

    /**
     * @ngdoc overview
     * @name eureka
     * @description
     * The main module for the Eureka Angular app.
     * @requires ui.router
     * @requires ui.tree
     * @requires angularValidator
     * @requires cohorts
     * @requires phenotypes
     * @requires register
     */
    angular.module('eureka', ['ui.router', 'ui.bootstrap', 'ui.bootstrap.datetimepicker', 'ui.tree', 'angularValidator', 'ngMessages', 'ui.grid', 'ui.grid.pagination', 'ngTable', 'eureka.cohorts', 'eureka.phenotypes', 'eureka.help', 'eureka.jobs', 'flow']);

    angular.module('eureka').run(eurekaRun);
    angular.module('eureka').config(eurekaConfig);

    eurekaRun.$inject = ['$rootScope', 'AppPropertiesService', 'appProperties', 'users'];
    eurekaConfig.$inject = ['$stateProvider', '$urlRouterProvider', '$httpProvider'];

    function eurekaRun($rootScope, AppPropertiesService, appProperties, users) {

        $rootScope.app = appProperties;

        AppPropertiesService.getAppProperties().then(function (response) {
            $rootScope.modes = response.data.appPropertiesModes;
            $rootScope.links = response.data.appPropertiesLinks;
            $rootScope.registration = response.data.appPropertiesRegistration;
        });

        $rootScope.userVerficationPerformed = false;

        $rootScope.inceptionYear = '2012';
        $rootScope.currentYear = new Date().getFullYear();
        users.getUser().then(function (user) {
            $rootScope.user = user;
            $rootScope.userVerficationPerformed = true;
        });
    }

    function eurekaConfig($stateProvider, $urlRouterProvider, $httpProvider) {

        if (!$httpProvider.defaults.headers.get) {
            $httpProvider.defaults.headers.get = {};
        }
        $httpProvider.defaults.headers.get['If-Modified-Since'] = 'Mon, 26 Jul 1997 05:00:00 GMT';
        $httpProvider.defaults.headers.get['Cache-Control'] = 'no-cache, no-store, must-revalidate';
        $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';

        $urlRouterProvider.otherwise('/index');

        $stateProvider.state('index', {
            url: '/index',
            templateUrl: 'eureka/views/main/main.html'
        });
    }
})();
'use strict';

(function () {
  'use strict';

  /**
   * @ngdoc overview
   * @name eureka.cohorts
   * @description
   * The module for the cohorts section of the Eureka application.
   */
  angular.module('eureka.cohorts', []);

  angular.module('eureka.cohorts').config(cohortsConfig);

  cohortsConfig.$inject = ['$stateProvider'];

  function cohortsConfig($stateProvider) {

    $stateProvider.state('cohorts', {
      url: '/cohorts',
      templateUrl: 'eureka/cohorts/views/main/main.html',
      controller: 'cohorts.MainCtrl',
      controllerAs: 'cohorts'
    }).state('testCohorts', {
      url: '/test/cohorts',
      templateUrl: 'eureka/cohorts/views/test/test.html',
      controller: 'cohorts.TestCtrl',
      controllerAs: 'cohorts'
    }).state('newCohort', {
      url: '/cohorts/new',
      templateUrl: 'eureka/cohorts/views/new/new.html',
      controller: 'cohorts.NewCtrl',
      controllerAs: 'newCohort'
    }).state('editCohort', {
      url: '/cohorts/:key',
      templateUrl: 'eureka/cohorts/views/edit/edit.html',
      controller: 'cohorts.EditCtrl',
      controllerAs: 'editCohort'
    });
  }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc overview
     * @name eureka.help
     * @description
     * The module for the cohorts section of the Eureka application.
     */
    angular.module('eureka.help', []);

    angular.module('eureka.help').config(helpConfig);

    helpConfig.$inject = ['$stateProvider'];

    function helpConfig($stateProvider) {

        $stateProvider.state('help', {
            url: '/help',
            templateUrl: 'eureka/help/views/main/main.html'
        });
    }
})();
'use strict';

(function () {
  'use strict';

  /**
   * @ngdoc overview
   * @name eureka.jobs
   * @description
   * The module for the jobs section of the Eureka application.
   */

  angular.module('eureka.jobs', []);

  angular.module('eureka.jobs').config(jobsConfig);

  jobsConfig.$inject = ['$stateProvider'];

  function jobsConfig($stateProvider) {

    $stateProvider.state('jobs', {
      url: '/jobs',
      templateUrl: 'eureka/jobs/views/main/main.html',
      controller: 'jobs.MainCtrl',
      controllerAs: 'jobs'
    });
  }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc overview
     * @name eureka.phenotypes
     * @description
     * The module for the phenotypes section of the Eureka application.
     */
    angular.module('eureka.phenotypes', ['ui.router']);

    angular.module('eureka.phenotypes').config(phenotypesConfig);

    phenotypesConfig.$inject = ['$stateProvider'];

    function phenotypesConfig($stateProvider) {

        $stateProvider.state('phenotypes', {
            url: '/phenotypes',
            templateUrl: 'eureka/phenotypes/views/main/main.html',
            controller: 'phenotypes.MainCtrl',
            controllerAs: 'phenotypes'
        }).state('editPhenotype', {
            url: '/phenotypes/edit/:id',
            templateUrl: 'eureka/phenotypes/views/edit/edit.html',
            controller: 'phenotypes.EditCtrl',
            controllerAs: 'editPhenotype'
        }).state('createPhenotype', {
            url: '/phenotypes/:type',
            templateUrl: 'eureka/phenotypes/views/create/create.html',
            controller: 'phenotypes.CreateCtrl',
            controllerAs: 'createPhenotype'
        });
    }
})();
'use strict';angular.module('eureka').run(['$templateCache',function($templateCache){$templateCache.put('eureka/directives/cohort-members-drop-zone/cohort-members-drop-zone.html','<!-- angular-ui-tree drop zone -->\n<md-whiteframe flex class="md-whiteframe-z2" layout="column" layout-align="start start" style="margin-top: 30px;">\n    <div layout-fill ui-tree="dropZone.treeOptions" data-empty-placeholder-enabled="false">\n        <ol ui-tree-nodes="" ng-model="dropZone.memberList" class="member-tree-list">\n            <li ui-tree-node data-nodrag layout-fill class="text-center" style="padding: 30px 20px;"\n                ng-if="!dropZone.memberList.length">\n                <h3 class="md-title">Drag Members Here</h3>\n            </li>\n            <li class="md-subhead" ng-repeat="item in dropZone.memberList" ui-tree-node data-nodrag layout-fill>\n                <i class="fa fa-times" ng-click="remove(this)"></i> {{item.displayName}}\n            </li>\n        </ol>\n    </div>\n</md-whiteframe>\n<!-- end of angular-ui-tree drop zone -->\n');$templateCache.put('eureka/directives/cohort-members-tree/cohort-members-tree.html','<md-card>\n    <md-tabs md-dynamic-height md-border-bottom>\n        <md-tab label="System">\n            <md-content class="md-padding">\n                <md-input-container md-no-float>\n                    <input flex ng-model="tree.treeSearch" placeholder="Search" ng-model-options=\'{ debounce: 1000 }\' ng-change="tree.filterCohortList()">\n                </md-input-container>\n                <md-progress-circular class="md-hue-1" md-mode="indeterminate" ng-if="tree.loading"></md-progress-circular>\n                <div ui-tree data-empty-placeholder-enabled="false" data-drag-enabled="true" data-drag-delay="200" data-clone-enabled="true">\n                    <ol ui-tree-nodes="" data-nodrop-enabled="true" ng-model="tree.treeData" id="tree-root">\n                        <li ng-repeat="node in tree.treeData" ui-tree-node ng-include="\'nodes_renderer.html\'" collapsed="true"></li>\n                    </ol>\n                </div>\n                <!-- Nested node template -->\n                <script type="text/ng-template" id="nodes_renderer.html">\n                    <div class="md-subhead" ng-class="{\'node-disabled\': !tree.nodeAllowed(node)}" style="padding-bottom: 3px;" ui-tree-handle ng-click="toggle(this); tree.toggleNode(node)">\n                        <i class="fa" ng-if="node.children" style="cursor: pointer; margin-right: 5px;" ng-class="{\n                                \'fa-plus-square\': collapsed,\n                                \'fa-minus-square\': !collapsed\n                            }"></i>\n                        <i class="fa fa-file-o" style="margin-right: 5px;" ng-if="!node.children"></i>\n                        {{node.displayName}}\n                    </div>\n                    <md-progress-linear class="md-hue-1" style="margin:5px 0;" md-mode="indeterminate" ng-if="node.loading"></md-progress-linear>\n                    <ol ui-tree-nodes="" data-nodrop-enabled="true" ng-class="{ \'hidden\': collapsed }" ng-model="node.nodes">\n                        <li ng-repeat="node in node.nodes" ui-tree-node ng-include="\'nodes_renderer.html\'" collapsed="true">\n                        </li>\n                    </ol>\n                </script>\n            </md-content>\n        </md-tab>\n        <md-tab label="User">\n            <md-content class="md-padding">\n            </md-content>\n        </md-tab>\n    </md-tabs>\n</md-card>\n');$templateCache.put('eureka/directives/global-grid/global-grid.html','<div class="grid" ui-grid="gridOptions"></div> ');$templateCache.put('eureka/directives/table-directive-one/table-directive-one.html','             <table ng-table="tableParameters" class="table" show-filter="true">\n                    <tr ng-repeat="user in tableData">\n                        <td>\n                            <a href="#" title="Edit">\n                                <span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>\n                            </a>\n                            <span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>\n                        </td>\n                        <td title="\'Name\'" filter="{ name: \'text\'}" sortable="\'name\'">\n                            {{user.name}}\n                        </td>\n                        <td title="\'Description\'" filter="{ description: \'text\'}" sortable="\'description\'">\n                            {{user.description}}\n                        </td>\n                        <td title="\'Type\'" filter="{ type: \'text\'}" sortable="\'type\'">\n                            {{user.type}}\n                        </td>\n                        <td title="\'Created\'" filter="{ created_at: \'text\'}" sortable="\'created_at\'">\n                            {{user.created_at | date:\'MM/dd/yyyy\'}}\n                        </td>\n                    </tr>\n                </table>  ');$templateCache.put('eureka/directives/tree-component/tree-component.html','<style>\n    .ng-table-pager {\n        display: none;\n    }\n    \n    table.ng-table td {\n        text-align: left;\n        width: 94%;\n    }\n    \n    a.add-node {\n        color: green;\n    }\n</style>\n<div class="col-md-12">\n    <div class="row">\n        <ol class="breadcrumb">\n            <li class="breadcrumb-item" ng-repeat="x in vm.breadCrumbs"><a href ng-click="vm.setBreadCrumbs(x)">{{x.displayName}}</a></li>\n        </ol>\n    </div>\n</div>\n<div class="col-md-7">\n    <table ng-table="vm.tableParams" class="table" show-filter="true">\n        <tr>\n            <div style="font-size: 21px; color:#333">System</div>\n        </tr>\n        <tr ng-repeat="user in $data" class="animate">\n            <td>\n\n                <span ng-if="user.parent === false" ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""> {{user.displayName}}</span>\n\n                <a title="Edit" ng-click="vm.selectNode(user) " ng-if="user.parent===true">\n                    <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""></span> {{user.displayName}}\n                </a>\n\n            </td>\n\n            <td>\n                <a title="Edit" ng-click="vm.addNode(user) " class="add-node">\n                    <span class="glyphicon glyphicon-plus" title=""></span>\n\n                </a>\n            </td>\n\n        </tr>\n\n    </table>\n    <table ng-table="vm.tableParamsUser" class="table" show-filter="true">\n        <tr>\n            <div style="font-size: 21px; color:#333">User</div>\n        </tr>\n        <tr ng-repeat="user1 in $data" class="animate">\n            <td>\n                <span ng-if="user1.children === false" ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""> {{user1.text}} </span>\n                <a title="Edit" ng-if="user1.children === true" ng-click="vm.selectNode(user1) ">\n                    <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""></span> {{user1.text}}\n                </a>\n\n            </td>\n\n            <td>\n                <a title="Edit" ng-click="vm.addUserNode(user1) " class="add-node">\n                    <span class="glyphicon glyphicon-plus" title=""></span>\n\n                </a>\n            </td>\n\n        </tr>\n    </table>\n</div>\n<div class="col-md-5" style="background:#f5f5f5">\n    <form>\n        <fieldset>\n            <legend>Items Added&nbsp;</legend>\n            <p ng-repeat="selectedNode in vm.currentMemeberList">\n                <span>{{selectedNode.displayName}}</span>\n                <a title="remove" ng-click="vm.removeNode(selectedNode) ">\n                    <span class="glyphicon glyphicon-remove" title="" style="color:red;"></span>\n\n                </a>\n                <p>\n        </fieldset>\n    </form>\n\n</div>');$templateCache.put('eureka/views/main/main.html','<div class="jumbotron">\n    <img id="logo" class="img-responsive" src="assets/images/logo.png"/>\n    <p class="vert-offset text-center">\n        Clinical data ETL and phenotyping system\n    </p>\n</div>\n<div id="indexPanels">\n    <div class="container-fluid">\n        <div class="row" ng-if="modes.demoMode">\n            <div class="alert alert-warning">NOTE: This demonstration web site is NOT suitable for\n                use with sensitive data including patient data that contains\n                identifiers.\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">Getting Started</div>\n                    \n                        <div class="panel-body text-center" ng-show="userVerficationPerformed == false ">\n                            <div class="container-fluid">\n                                <div class="row">\n                                    <div class="col-xs-12">\n                                        <h4><i class="fa fa-refresh fa-spin fa-2x"></i>\n                                        </h4>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n\n                        <div class="panel-body text-center" ng-show="userVerficationPerformed == true && !user">\n                            <div class="container-fluid">\n                                <div class="row" ng-switch="registration.registrationEnabled">\n                                    <div ng-switch-when="true">\n                                        <div class="col-xs-6">\n                                            <h4>Learn about Eureka!</h4>\n                                            <a ng-href="{{links.aiwUrl}}/#overview" target="_blank"\n                                               class="btn btn-primary btn-lg">\n                                                About Eureka!\n                                            </a>\n                                        </div>\n                                        <div class="col-xs-6">\n                                            <h4>Get an account</h4>\n                                            <a href="{{links.userWebappUrl}}/chooseaccounttype" target="_blank"\n                                               class="btn btn-primary btn-lg">\n                                                Register\n                                            </a>                                          \n                                        </div>\n                                    </div>\n                                    <div ng-switch-default>\n                                        <div class="col-xs-12">\n                                            <h4>Learn about Eureka!</h4>\n                                            <a ng-href="{{links.aiwUrl}}/#overview" target="_blank"\n                                               class="btn btn-primary btn-lg">\n                                                About Eureka!\n                                            </a>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>        \n                    \n                        <div class="panel-body text-center" ng-show="userVerficationPerformed == true && user">\n                            <div class="container-fluid">\n                                <div class="row">\n                                    <div class="col-xs-12">\n                                        <h4>Learn more about Eureka!</h4>\n                                        <a ng-href="{{links.aiwUrl}}/#overview" target="_blank"\n                                           class="btn btn-primary btn-lg">\n                                            About Eureka!\n                                        </a>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    \n                </div>               \n            </div>\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">Want to evaluate Eureka! at your institution?</div>\n                    <div class="panel-body text-center">\n                        <div class="container-fluid">\n                            <div class="row">\n                                <div class="col-xs-12">\n                                    <h4>Contact us for options</h4>\n                                    <a ng-href="{{links.aiwUrl}}/contact/" target="_blank"\n                                       class="btn btn-primary btn-lg">\n                                        Contact Us\n                                    </a>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="row" ng-controller="NewsAndFundingController">\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">News</div>\n                    <div class="panel-body" id="versionHistory">\n                        \n                        <div class="row" ng-repeat-start="versionItem in versionHistory" ng-if="$first">\n                            <div class="col-sm-2" >{{versionItem.releaseDate}}</div>\n                            <div class="col-sm-10">{{versionItem.description}}</div>\n                        </div>\n                        <!--add offset style from 2nd items to keep the css style as original design-->\n                        <div class="row vert-offset" ng-repeat-end ng-if="!$first">\n                            <div class="col-sm-2" >{{versionItem.releaseDate}}</div>\n                            <div class="col-sm-10">{{versionItem.description}}</div>                            \n                        </div>\n                        \n                    </div>\n                </div>\n            </div>\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">Funding</div>\n                    <div class="panel-body text-center">\n                        <p>The software powering this site has been supported in part by \n                            <span ng-bind-html="supportedByHTML" id="supportBy"></span>\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n');$templateCache.put('eureka/cohorts/views/edit/edit.html','<div class="row">\n    <div class="col-sm-12">\n        <h3>Cohort Editor</h3>\n    </div>\n</div>\n\n<div class="row">\n    <div class="col-md-12">\n        <div id="definitionContainer" class="col-md-8">\n            <form id="categorizationForm" class="vert-offset" role="form">\n                <div class="form-group">\n                    <label for="patCohortDefName" class="control-label">Name</label>\n                    <input type="text" id="patCohortDefName" class="form-control" ng-model="editCohort.destination.name" />\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDescription" class="control-label">Description</label>\n                    <textarea id="patCohortDescription" class="form-control" ng-model="editCohort.destination.description"></textarea>\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDefinition" class="control-label">Members</label>\n                    <div class="row">\n                        <div class="col-md-12">\n                            <tree-component current-memeber-list="editCohort.memberList"></tree-component>\n                        </div>\n                    </div>\n\n                </div>\n\n                <div class="form-group text-center vert-offset">\n                    <button id="savePhenotypeButton" type="button" class="btn btn-primary" ng-click="editCohort.updateCohort()">Save</button>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n\n<!--<h3>Cohort Editor</h3>-->\n<!--<p>-->\n<!--Select the system and user-defined elements from the ontology that will define the patient cohort.-->\n<!--</p>-->\n<!--<div layout="column" layout-gt-md="row" >  -->\n<!--<div class="col-xs-4">-->\n<!--<ul class="nav nav-tabs">-->\n<!--<li class = "active">-->\n<!--<a href = "#systemElems" data-toggle="tab">System</a>-->\n<!--</li>-->\n<!--<li>-->\n<!--<a href="#userElems" data-toggle="tab">User</a>-->\n<!--</li>-->\n<!--</ul>-->\n<!--<div id="treeContent" class="tab-content proposition-tree">-->\n<!--<div id="systemElems" class="tab-pane fade active in">-->\n<!--<jstree-->\n<!--tree-url="protected/systemlist"-->\n<!--tree-search="protected/jstree3_searchsystemlist"-->\n<!--search-update-div="#searchUpdateDiv"-->\n<!--search-validation-modal="#searchValidationModal"-->\n<!--search-no-results-modal="#searchNoResultsModal"-->\n<!--tree-css-url="assets/css/jstree-themes/default/style.css"-->\n<!--/>-->\n<!--<div id="searchUpdateDiv" class="searchUpdateMessage"></div>-->\n<!--</div>-->\n<!--<div id="userElems" class="tab-pane fade">-->\n<!--<div id="userTree"></div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--\n    <md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n        <cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n    </md-content> -->\n\n<!--<div id="definitionContainer" class="col-xs-8">-->\n<!--<form id="categorizationForm" class="vert-offset" role="form">-->\n<!--<div class="form-group">-->\n<!--<label for="patCohortDefName" class="control-label">Name</label>-->\n<!--<input type="text" id="patCohortDefName" ng-model="editCohort.cohortDestination.name"-->\n<!--class="form-control"/>-->\n<!--</div>-->\n<!--<div class="form-group">-->\n<!--<label for="patCohortDescription" class="control-label">Description</label>-->\n<!--<textarea id="patCohortDescription" class="form-control" ng-model="editCohort.cohortDestination.description"></textarea>-->\n<!--</div>-->\n<!--<div class="form-group">-->\n<!--<label for="patCohortDefinition" class="control-label">Members</label>-->\n<!--<div id="patCohortDefinition"-->\n<!--class="jstree-drop tree-drop tree-drop-multiple"-->\n<!--title="Drop the system and/or user-defined data element members that define your patient cohort in here">-->\n\n<!--<ul class="sortable"-->\n<!--data-drop-type="multiple"-->\n<!--data-proptype="empty"-->\n<!--ng-repeat="phenotype in editCohort.cohortDestination.phenotypes"-->\n<!--phenotype-editor="phenotype"-->\n<!--/>-->\n\n<!--</div>-->\n<!--</div>-->\n<!--<div class="form-group text-center vert-offset">-->\n<!--<button id="savePropositionButton" type="button" class="btn btn-primary">Save</button>-->\n<!--</div>-->\n<!--</form>-->\n<!--</div>-->\n<!--\n    <md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n        <md-card>\n            <md-card-content>\n                <h2 class="md-headline" style="margin-top: 0">Edit Cohort</h2>\n                <p>\n                    Select the system and user-defined elements from the ontology that will define the patient cohort.\n                </p>\n                <form name="userForm">\n                    <md-input-container flex>\n                        <label>Name</label>\n                        <input ng-model="newCohort.cohort.name">\n                    </md-input-container>\n                    <md-input-container flex>\n                        <label>Description</label>\n                        <textarea ng-model="newCohort.cohort.description" columns="1" md-maxlength="250"></textarea>\n                    </md-input-container>\n\n                    <cohort-members-drop-zone member-list="newCohort.memberList"></cohort-members-drop-zone>\n\n                </form>\n            </md-card-content>\n            <div class="md-actions md-padding" layout="row" layout-align="start center">\n                <md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n            </div>\n        </md-card>\n    </md-content>\n\n</div>\n<div id="deleteModal" class="modal fade" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="deleteModalLabel" class="modal-title">Delete Element</h4>\n            </div>\n            <div id="deleteContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button id="deleteButton" type="button" class="btn btn-primary">Delete</button>\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="replaceModal" class="modal fade" role="dialog" aria-labelledby="replaceModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="replaceModalLabel" class="modal-title">Replace Element</h4>\n            </div>\n            <div id="replaceContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button id="replaceButton" type="button" class="btn btn-primary">Replace</button>\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="errorModal" class="modal fade" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="errorModalLabel" class="modal-title">Error</h4>\n            </div>\n            <div id="errorContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="searchModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="searchModalLabel" class="modal-title">\n                    Broad Search Update\n                </h4>\n            </div>\n            <div id="searchContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="searchValidationModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="searchModalLabel" class="modal-title">\n                    Search String Validation Failed\n                </h4>\n            </div>\n            <div id="searchContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="searchNoResultsModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="searchModalLabel" class="modal-title">\n                    No Search Results\n                </h4>\n            </div>\n            <div id="searchContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>  -->');$templateCache.put('eureka/cohorts/views/main/main.html','<style>\n.myGrid {\n    width: 800px;\n    height: 250px;\n  }\n</style>\n\n<div class="row">\n    <div class="col-sm-12">\n        <h3>Cohorts</h3>\n        <p>Define a cohort to identify the patient population in your datasets.\n        </p>\n        <p>\n            <a ui-sref="newCohort" class="btn btn-primary"><span class="glyphicon glyphicon-plus-sign"></span>\n            Define New Cohort\n\t\t\t</a>\n        </p>\n        <!-- removing ui-grid for now -->\n        <!-- <div ui-grid="cohorts.gridOptions" ui-grid-pagination ui-grid-edit class="grid"></div> -->\n    </div>\n</div>\n<!-- ng-table -->\n<div class="row">\n    <div class="col-md-12">\n        <table ng-table="cohorts.tableParams" class="table" show-filter="true">\n            <tr ng-repeat="user in $data">\n                <td>\n                    <a ui-sref="editCohort({key: user.name})" title="Edit">\n                        <span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>\n                    </a>\n                    <span class="glyphicon glyphicon-remove delete-icon" title="Delete" ng-click="cohorts.deleteCohort(user.name, $index)"></span>\n                </td>\n                <td title="\'Name\'" filter="{ name: \'text\'}" sortable="\'name\'">\n                    {{user.name}}\n                </td>\n                <td title="\'Description\'" filter="{ description: \'text\'}" sortable="\'description\'">\n                    {{user.description}}\n                </td>\n                <td title="\'Type\'" filter="{ type: \'text\'}" sortable="\'type\'">\n                    {{user.type}}\n                </td>\n                <td title="\'Created\'" filter="{ created_at: \'text\'}" sortable="\'created_at\'">\n                    {{user.created_at | date:\'MM/dd/yyyy\'}}\n                </td>\n            </tr>\n        </table>\n    </div>\n</div>\n    <script type="text/ng-template" id="myModal.html">\n        <div class="modal-header">\n            <h3 class="modal-title">Delete Element</h3>\n        </div>\n        <div class="modal-body">\n            Are you sure you would like to remove this item?\n        </div>\n        <div class="modal-footer">\n            <button class="btn btn-primary" ng-click="mo.ok()">Delete</button>\n            <button class="btn btn-primary" ng-click="mo.cancel()">Close</button>\n        </div>\n    </script>\n\n    <script type="text/ng-template" id="errorModal.html">\n    <div class="modal-header">\n        <h3 class="modal-title">Error</h3>\n    </div>\n    <div class="modal-body">\n       {{mod.data}}\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-primary" ng-click="mod.cancel()">Close</button>\n    </div>\n</script>\n\n\n<!--\n<div layout>\n    <md-content flex layout-padding>\n        <md-card>  -->\n        <!--<h3>Cohorts</h3>-->\n\n        <!--<p>Define a cohort to identify the patient population in your datasets.-->\n        <!--</p>-->\n        <!--<a ui-sref="newCohort" class="btn btn-primary"><span-->\n                <!--class="glyphicon glyphicon-plus-sign"></span>Define New Cohort-->\n        <!--</a>-->\n        <!--<table class="table table-responsive vert-offset">-->\n            <!--<tr>-->\n                <!--<th>Action</th>-->\n                <!--<th>Name</th>-->\n                <!--<th>Description</th>-->\n                <!--<th>Created Date</th>-->\n                <!--<th>Last Modified</th>-->\n            <!--</tr>-->\n            <!--<tr ng-repeat="cohortDestination in cohorts.list">-->\n                <!--<td>-->\n                    <!--<a ui-sref="editCohort({key: cohortDestination.name})" title="Edit">-->\n                        <!--<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>-->\n                    <!--</a>-->\n                    <!--<span class="glyphicon glyphicon-remove delete-icon" title="Delete" ng-click="remove(cohortDestination.name)"></span>-->\n                <!--</td>-->\n                <!--<td>{{ cohortDestination.name }}</td>-->\n                <!--<td>{{ cohortDestination.description }}</td>-->\n                <!--<td>{{ cohortDestination.created_at | date : shortDate }}</td>-->\n                <!--<td>{{ cohortDestination.updated_at | date : shortDate }}</td>-->\n            <!--</tr>-->\n        <!--</table>-->\n\n        <!-- begin md-data-table \n        <md-data-table-toolbar ng-hide="cohorts.selected.length || cohorts.filter.show">\n            <h2 class="md-title">Cohortsxx</h2>\n            <div flex></div>\n            <md-button class="md-icon-button" ng-click="cohorts.filter.show = true">\n                <i class="material-icons md-dark">search</i>\n            </md-button>\n            <md-button class="md-icon-button" ui-sref="newCohort">\n                <i class="material-icons md-dark">add_circle</i>\n            </md-button>\n        </md-data-table-toolbar>\n\n        <md-data-table-toolbar ng-show="cohorts.filter.show && !cohorts.selected.length">\n            <i class="material-icons md-dark">search</i>\n            <form flex name="cohorts.filter.form">\n                <input type="text" ng-model="cohorts.query.filter" ng-model-options="cohorts.filter.options" placeholder="Search...">\n            </form>\n            <md-button class="md-icon-button" ng-click="cohorts.removeFilter()">\n                <i class="material-icons md-dark">close</i>\n            </md-button>\n        </md-data-table-toolbar>\n\n        <md-data-table-toolbar class="alternate" ng-show="cohorts.selected.length" layout-align="space-between">\n            <div>{{cohorts.selected.length}} {{cohorts.selected.length > 1 ? \'items\' : \'item\'}} selected</div>\n            <div flex></div>\n            <md-button class="md-icon-button" ng-show="cohorts.selected.length == 1" ui-sref="editCohort({ key: cohorts.selected[0].key })">\n                <i class="material-icons md-dark">edit</i>\n            </md-button>\n            <md-button class="md-icon-button">\n                <i class="material-icons md-dark">delete</i>\n            </md-button>\n        </md-data-table-toolbar>\n\n        <md-data-table-container>\n            <table md-data-table md-row-select="cohorts.selected" md-progress="cohorts.deferred">\n                <thead md-order="cohorts.query.order" md-trigger="cohorts.onOrderChange">\n                    <tr>\n                        <th name="Name" order-by="name"></th>\n                        <th name="Description" order-by="description"></th>\n                        <th name="Created" unit="date" order-by="created_at"></th>\n                        <th name="Last Modified" unit="date" order-by="updated_at"></th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr md-auto-select ng-repeat="cohort in cohorts.cohortsList">\n                        <td>{{cohort.name}}</td>\n                        <td>{{cohort.description}}</td>\n                        <td>{{cohort.created_at | date:\'shortDate\'}}</td>\n                        <td>{{cohort.updated_at | date:\'shortDate\'}}</td>\n                    </tr>\n                </tbody>\n            </table>\n        </md-data-table-container>\n\n        <md-data-table-pagination md-limit="cohorts.query.limit" md-page="cohorts.query.page" md-total="{{cohorts.cohortsList.length}}" md-trigger="cohorts.onPaginationChange"></md-data-table-pagination>\n        end md-data-table \n\n        </md-card>\n    </md-content>  -->\n</div>');$templateCache.put('eureka/cohorts/views/new/new.html','<div class="row">\n    <div class="col-sm-12">\n        <h3> New Cohort Editor</h3>\n    </div>\n</div>\n\n<div class="row">\n    <div class="col-md-12">\n    </div>\n</div>\n<div class="row">\n    <div class="col-md-12">\n        <div id="definitionContainer" class="col-md-8">\n            <form id="categorizationForm" class="vert-offset" role="form">\n                <div class="form-group">\n                    <label for="patCohortDefName" class="control-label">Name</label>\n                    <input type="text" id="patCohortDefName" class="form-control" ng-model="newCohort.name" />\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDescription" class="control-label">Description</label>\n                    <textarea id="patCohortDescription" class="form-control" ng-model="newCohort.description"></textarea>\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDefinition" class="control-label">Members</label>\n                    <div class="row">\n                        <tree-component current-memeber-list="newCohort.memberList"></tree-component>\n                    </div>\n                </div>\n\n                <div class="form-group text-center vert-offset">\n                    <button id="savePhenotypeButton" type="button" class="btn btn-primary" ng-click="newCohort.submitCohortForm()">Save</button>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n\n<!--<h3>Cohort Editor</h3>-->\n<!--<p>-->\n<!--Select the system and user-defined elements from the ontology that will define the patient cohort.-->\n<!--</p>-->\n\n<!--<div class="col-xs-4">-->\n\n<!--<ul class="nav nav-tabs">-->\n<!--<li ng-class="{active: newCohort.activeTab == 1}">-->\n<!--&lt;!&ndash;<a href = "#systemElems" data-toggle="tab">System</a>&ndash;&gt;-->\n<!--<a href ng-click="newCohort.activeTab = 1" >System</a>-->\n<!--</li>-->\n<!--<li ng-class="{active: newCohort.activeTab == 2}">-->\n<!--<a href ng-click="newCohort.activeTab = 2" >User</a>-->\n<!--</li>-->\n<!--</ul>-->\n<!--<div id="treeContent" ng-init="newCohort.activeTab = 1" class="tab-content proposition-tree">-->\n<!--&lt;!&ndash;<div id="systemElems" class="tab-pane fade active in" ng-show="tab.isSet(1)">&ndash;&gt;-->\n<!--<div id="systemElems" ng-show="newCohort.activeTab == 1">-->\n<!--<jstree-->\n<!--tree-url="/eureka-webapp/protected/systemlist"-->\n<!--tree-search="/eureka-webapp/protected/jstree3_searchsystemlist"-->\n<!--search-update-div="#searchUpdateDiv"-->\n<!--search-validation-modal="#searchValidationModal"-->\n<!--search-no-results-modal="#searchNoResultsModal"-->\n<!--tree-css-url="assets/css/jstree-themes/default/style.css"-->\n<!--/>-->\n<!--<div id="searchUpdateDiv" class="searchUpdateMessage"></div>-->\n<!--</div>-->\n<!--&lt;!&ndash;<div id="userElems" class="tab-pane fade" ng-show="tab.isSet(2)">&ndash;&gt;-->\n<!--<div id="userElems" ng-show="newCohort.activeTab == 2">-->\n<!--<div id="userTree"></div>-->\n<!--</div>-->\n<!--</div>-->\n\n\n<!--</div>-->\n<!--<div id="definitionContainer" class="col-xs-8">-->\n<!--<form id="categorizationForm" class="vert-offset" role="form">-->\n<!--<div class="form-group">-->\n<!--<label for="patCohortDefName" class="control-label">Name</label>-->\n<!--<input type="text" id="patCohortDefName" ng-model="newCohort.cohortDestination.name"-->\n<!--class="form-control"/>-->\n<!--</div>-->\n<!--<div class="form-group">-->\n<!--<label for="patCohortDescription" class="control-label">Description</label>-->\n<!--<textarea id="patCohortDescription" class="form-control" ng-model="newCohort.cohortDestination.description"></textarea>-->\n<!--</div>-->\n<!--<div class="form-group">-->\n<!--<label for="patCohortDefinition" class="control-label">Members</label>-->\n<!--<div id="patCohortDefinition"-->\n<!--class="jstree-drop tree-drop tree-drop-multiple"-->\n<!--title="Drop the system and/or user-defined data element members that define your patient cohort in here">-->\n<!--<ul class="sortable" data-drop-type="multiple" data-proptype="empty">-->\n<!--</ul>-->\n<!--</div>-->\n<!--</div>-->\n<!--<div class="form-group text-center vert-offset">-->\n<!--<button id="savePropositionButton" type="button" class="btn btn-primary">Save</button>-->\n<!--</div>-->\n<!--</form>-->\n<!--</div>-->\n<!-- begin angular-ui-tree -->\n<!--\n    <md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n        <cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n    </md-content>  -->\n<!--end angular-ui-tree  -->\n<!--\n    <md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n        <md-card>\n            <md-card-content>\n                <h2 class="md-headline" style="margin-top: 0">New Cohort</h2>\n                <p>\n                    Select the system and user-defined elements from the ontology that will define the patient cohort.\n                </p>\n                <form name="userForm">\n                    <md-input-container flex>\n                        <label>Name</label>\n                        <input ng-model="newCohort.cohort.name">\n                    </md-input-container>\n                    <md-input-container flex>\n                        <label>Description</label>\n                        <textarea ng-model="newCohort.cohort.description" columns="1" md-maxlength="250"></textarea>\n                    </md-input-container>\n\n                    <cohort-members-drop-zone member-list="newCohort.memberList"></cohort-members-drop-zone>\n\n                </form>\n            </md-card-content>\n            <div class="md-actions md-padding" layout="row" layout-align="start center">\n                <md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n            </div>\n        </md-card>\n    </md-content>\n\n</div>  -->\n<!--<div id="deleteModal" class="modal fade" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">-->\n<!--<div class="modal-dialog modal-lg">-->\n<!--<div class="modal-content">-->\n<!--<div class="modal-header">-->\n<!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n<!--<h4 id="deleteModalLabel" class="modal-title">Delete Element</h4>-->\n<!--</div>-->\n<!--<div id="deleteContent" class="modal-body">-->\n<!--</div>-->\n<!--<div class="modal-footer">-->\n<!--<button id="deleteButton" type="button" class="btn btn-primary">Delete</button>-->\n<!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--<div id="replaceModal" class="modal fade" role="dialog" aria-labelledby="replaceModalLabel" aria-hidden="true">-->\n<!--<div class="modal-dialog modal-lg">-->\n<!--<div class="modal-content">-->\n<!--<div class="modal-header">-->\n<!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n<!--<h4 id="replaceModalLabel" class="modal-title">Replace Element</h4>-->\n<!--</div>-->\n<!--<div id="replaceContent" class="modal-body">-->\n<!--</div>-->\n<!--<div class="modal-footer">-->\n<!--<button id="replaceButton" type="button" class="btn btn-primary">Replace</button>-->\n<!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--<div id="errorModal" class="modal fade" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">-->\n<!--<div class="modal-dialog modal-lg">-->\n<!--<div class="modal-content">-->\n<!--<div class="modal-header">-->\n<!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n<!--<h4 id="errorModalLabel" class="modal-title">Error</h4>-->\n<!--</div>-->\n<!--<div id="errorContent" class="modal-body">-->\n<!--</div>-->\n<!--<div class="modal-footer">-->\n<!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--<div id="searchModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">-->\n<!--<div class="modal-dialog modal-lg">-->\n<!--<div class="modal-content">-->\n<!--<div class="modal-header">-->\n<!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n<!--<h4 id="searchModalLabel" class="modal-title">-->\n<!--Broad Search Update-->\n<!--</h4>-->\n<!--</div>-->\n<!--<div id="searchContent" class="modal-body">-->\n<!--</div>-->\n<!--<div class="modal-footer">-->\n<!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--<div id="searchValidationModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">-->\n<!--<div class="modal-dialog modal-lg">-->\n<!--<div class="modal-content">-->\n<!--<div class="modal-header">-->\n<!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n<!--<h4 id="searchModalLabel" class="modal-title">-->\n<!--Search String Validation Failed-->\n<!--</h4>-->\n<!--</div>-->\n<!--<div id="searchContent" class="modal-body">-->\n<!--</div>-->\n<!--<div class="modal-footer">-->\n<!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--<div id="searchNoResultsModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">-->\n<!--<div class="modal-dialog modal-lg">-->\n<!--<div class="modal-content">-->\n<!--<div class="modal-header">-->\n<!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n<!--<h4 id="searchModalLabel" class="modal-title">-->\n<!--No Search Results-->\n<!--</h4>-->\n<!--</div>-->\n<!--<div id="searchContent" class="modal-body">-->\n<!--</div>-->\n<!--<div class="modal-footer">-->\n<!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n<!--</div>-->\n\n<!--<script language="JavaScript">-->\n<!--eureka.editor.setup(null,\'#userTree\', \'#definitionContainer\', \'#savePropositionButton\');-->\n<!--</script>-->');$templateCache.put('eureka/cohorts/views/test/test.html','<style>\n.myGrid {\n    width: 800px;\n    height: 250px;\n  }\n</style>\n\n\n<div class="row">\n    <div class="col-sm-12">\n        <h3>Cohorts</h3>\n        <p>Define a cohort to identify the patient population in your datasets.\n        </p>\n        <p>\n            <a href="editcohort" class="btn btn-primary"><span class="glyphicon glyphicon-plus-sign"></span>Define New Cohort\n\t\t\t\t</a>\n        </p>\n        <!-- ui-grid -->\n        <global-grid grid-options={{cohorts.columnDefs}} grid-data={{cohorts.testData}} class="grid"></global-grid>\n    </div>\n</div>\n<br><br><br>\n<!-- ng-table -->\n\n<!-- ng-table Directive  -->\n<table-directive-one table-data="cohorts.testData" table-parameters="cohorts.tableParams"></table-directive-one>\n\n</div>');$templateCache.put('eureka/help/views/main/main.html','<div class="help">\n                <h3>Help</h3>\n                <div class="row">\n                        <div class="col-sm-3">\n\t\t\t\t<span class="thumbnail text-center">\n\t\t\t\t\t<a ng-href="{{links.helpSiteUrl}}/get-started-guide/" class="imageAndCaption" target="eureka-help">\n\t\t\t\t\t\t<img alt="Getting Started" src="assets/images/100px-Help-getting-started.png"/>\n\t\t\t\t\t\t<span class="caption">\n\t\t\t\t\t\t\tGetting Started\n\t\t\t\t\t\t</span>\n                                        </a>\n\t\t\t\t</span>\n                        </div>\n                        <div class="col-sm-3">\n\t\t\t\t<span class="thumbnail text-center">\n\t\t\t\t\t<a ng-href="{{links.aiwUrl}}/faq/" class="imageAndCaption" target="eureka-help">\n\t\t\t\t\t\t<img alt="Frequently Asked Questions" src="assets/images/100px-Help-FAQ.png"/>\n\t\t\t\t\t\t<span class="caption">\n\t\t\t\t\t\t\tFrequently Asked Questions\n\t\t\t\t\t\t</span>\n                                        </a>\n\t\t\t\t</span>\n                        </div>\n                </div>\n                <p ng-if="modes.demoMode">\n                    NOTE: For privacy, data retention and other policies regarding this\n                    site, click on Frequently Asked Questions above.\n                </p>\n</div>\n');$templateCache.put('eureka/jobs/views/main/main.bak.html','<div layout="column" layout-gt-md="row">\n\t<md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n\t<cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n\t</md-content>\n\t<md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n\t<form name="userForm">\n\t\t<md-card>\n\t\t<md-toolbar class="md-primary md-hue-1">\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Submit Job</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t</md-toolbar>\n\t\t<md-card-content>\n\t\t</md-card-content>\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Data</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t<md-card-content>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Spreadsheet</label>\n\t\t\t<md-select ng-model="createPhenotype.property.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t</md-card-content>\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Action</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t<md-card-content>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Load into</label>\n\t\t\t<md-select ng-model="createPhenotype.property.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<!--<label>Start</label>  -->\n\t\t\t<md-radio-group ng-model="data.group1">\n\t\t\t<md-radio-button value="replace" aria-label="Label 1">Replace Data</md-radio-button>\n\t\t\t<md-radio-button value="update"> Update Data </md-radio-button>\n\t\t\t</md-radio-group>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<div flow-init="{target: \'/upload\'}" flow-files-submitted="$flow.upload()" flow-file-success="$file.msg = $message">\n\t\t\t\t<input type="file" flow-btn/>\n\t\t\t\t<table>\n\t\t\t\t\t<tr ng-repeat="file in $flow.files">\n\t\t\t\t\t\t<td>{{$index+1}}</td>\n\t\t\t\t\t\t<td>{{file.name}}</td>\n\t\t\t\t\t\t<td>{{file.msg}}</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</div>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t</md-card-content>\n\t\t<md-toolbar class="md-primary md-hue-1">\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Concepts</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t</md-toolbar>\n\t\t<md-card-content>\n\t\t<cohort-members-drop-zone member-list="createPhenotype.memberList"></cohort-members-drop-zone>\n\t\t</md-card-content>\n\t\t<md-toolbar class="md-primary md-hue-1">\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Date Range</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t</md-toolbar>\n\t\t<md-card-content>\n\t\t<cohort-members-drop-zone member-list="createPhenotype.memberList"></cohort-members-drop-zone>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Start</label>\n\t\t\t<md-select ng-model="createPhenotype.property1.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t\t<md-input-container flex>\n\t\t\t<label>Has Earliest Date</label>\n\t\t\t<input type="number" step="any" name="propertyValue1" ng-model="createPhenotype.property1.value" />\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Start</label>\n\t\t\t<md-select ng-model="createPhenotype.property1.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t\t<md-input-container flex>\n\t\t\t<label>Has Latest Date</label>\n\t\t\t<input type="number" step="any" name="propertyValue1" ng-model="createPhenotype.property1.value" />\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t</md-card-content>\n\t\t<div class="md-actions md-padding" layout="row" layout-align="start center">\n\t\t\t<md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n\t\t</div>\n\t\t</md-card>\n\t</form>\n\t</md-content>\n</div>');$templateCache.put('eureka/jobs/views/main/main.html','\n<div class="row">\n    <div class="col-sm-12">\n        <h3>Submit Job</h3>\n    </div>\n</div>\n\n<div class="row">\n    <div class="col-sm-12">\n        <div id="statusDefinitionContainer" class="col-md-12">\n            <form id="uploadForm" name="uploadForm" role="form" method="POST" action="upload" enctype="multipart/form-data">\n                \n                <fieldset>\n                    <legend>Job Information</legend>\n                    <div class="row">\n                        <div class="col-md-2 col-sm-4">\n                            <div class="form-group">\n                                    <label class="control-label" for="sourceConfig">\n                                            Source\n                                    </label>\n                                    <div id="sourceConfig"> \n                                            {{jobs.jobInfoSourceConfig}}\n                                    </div>\n                            </div>\n                        </div>\n                        <div class="col-md-2 col-sm-4">\n                            <div class="form-group">\n                                    <label class="control-label" for="destinationConfig">\n                                            Destination\n                                    </label>\n                                    <div id="destinationConfig">\n                                            {{jobs.jobInfoDestination}}\n                                    </div>\n                            </div>\n                        </div>   \n                        <div class="col-md-2 col-sm-4">\n                            <div class="form-group">\n                                    <label class="control-label">Job Status</label>\n                                    <div id="jobStatus" ng-show="jobs.jobInfoStatus!=null">\n                                            {{jobs.jobInfoStatus}}\n                                    </div>\n                                    <div id ="noJobStatus" ng-show="jobs.jobInfoStatus == null">\n                                            No jobs have been submitted\n\n                                    </div>\n                            </div>\n                        </div>\n                        <div class="col-md-2 col-sm-4">\n                            <div class="form-group">\n                                    <label class="control-label" for="startedDate">\n                                            Started\n                                    </label>\n                                    <div id="startedDate" ng-show="jobs.jobInfoStatus!=null">\n                                            {{jobs.jobInfoStartTimestamp}} \n                                    </div>\n                            </div>\n                        </div>\n                        <div class="col-md-2 col-sm-4">\n                            <div class="form-group">\n                                    <label class="control-label" for="finishedDate">\n                                            Finished\n                                    </label>\n                                    <div id="finishedDate" ng-show="jobs.jobInfoStatus!=null">\n                                            {{jobs.jobInfoFinishTimestamp}}\n                                    </div>\n                            </div>\n                        </div>\n                        <div class="col-md-2 col-sm-4">\n                            <div class="form-group">\n                                    <label class="control-label" for="links">\n                                            Links\n                                    </label>\n                                    <div id="links" style="display: none">\n                                    </div>\n                                    <div id ="getStatisticsSupported" style="display: none">\n                                    </div>\n                            </div>\n                        </div>\n                    </div>\n                </fieldset>\n                \n                <div class="row">\n                    <div class="col-md-6">\n                        <fieldset id ="data">\n                            <legend>Data</legend>\n                            \n                            <div>{{jobs.jobSourceConfig.displayName}}</div>\n                            \n                            <div class="form-group">\n                                <select class="form-control" ng-model="jobs.jobSourceConfig" ng-options="sc.displayName for sc in jobs.sourceConfigs ">\n                                </select>\n                            </div>  \n                            <div class="form-group">\n                                <div flow-init="{target: \'/upload\'}" flow-files-submitted="$flow.upload()" flow-file-success="$file.msg = $message">\n                                    <input type="file" flow-btn/>\n                                    <table>\n                                      <tr ng-repeat="file in $flow.files">\n                                          <td>{{$index+1}}</td>\n                                          <td>{{file.name}}</td>\n                                          <td>{{file.msg}}</td>\n                                      </tr>\n                                    </table>\n                                </div>\n                            </div>\n                        </fieldset>\n                    </div>\n                    \n                    <div class="col-md-6">\n                        <fieldset id ="data">\n                            <legend>Action</legend>\n                            \n                            <div>{{jobs.jobDestination.name}}</div>\n                            \n                            <div class="form-group">\n                                <select class="form-control" ng-model="jobs.jobDestination" ng-options="d.name for d in jobs.destinations">\n                                </select>                                \n                            </div>  \n\n                            <div class="form-group">\n                                <label>\n                                    <input type ="radio" ng-model="jobs.radioData" value="1">Replace Data\n                                </label>\n                                <label>\n                                    <input type ="radio" ng-model="jobs.radioData" value="2">Update Data\n                                </label> \n                            </div>\n                        </fieldset>\n                    </div>                    \n                </div>\n                   \n                <div class="row">\n                    <div class="col-md-6">\n                        <fieldset id ="concepts">\n                            <legend>Concepts</legend>\n                            <div class="row">\n                                <div class="col-xs-9">\n                                    <div class="form-group">\n                                        <div id="conceptsList"\n                                                 class="jstree-drop tree-drop tree-drop-multiple"\n                                                 title="Drag and drop concepts to load here">\n                                                <div class="label-info text-center">\n                                                        Drop Here\n                                                </div>\n                                                <ul class="sortable" data-drop-type="multiple" data-proptype="empty">\n                                                </ul>\n                                        </div>\n                                    </div>\n                                </div>                                \n                            </div>\n                        </fieldset>\n                        \n                        <fieldset id ="dateRange">\n                            <legend>Date range</legend>\n                            <div class="row">\n                                <div class="col-xs-9">\n                                    <div class="form-group">\n                                        <label for="dateRangePhenotypeKey">\n                                                Data element for date range\n                                        </label>\n                                        <div id="dateRangePhenotypeKey"\n                                                 class="tree-drop tree-drop-single jstree-drop form-control-static">\n                                                <div class="label-info text-center">\n                                                        Drop Here\n                                                </div>\n                                                <ul data-type="main" data-drop-type="single" class="sortable">\n                                                </ul>\n                                        </div>\n                                        <input type="hidden" name="dateRangePhenotypeKey">\n                                    </div>\n                                </div>                                \n                            </div>\n                            <div class="row form-inline vert-offset">\n                                    <div class="col-xs-12">\n                                            <div class="form-group">\n                                                    <select name="dateRangeEarliestDateSide" class="form-control">\n                                                        <option value="START">start</option>\n                                                        <option value="FINISH">finish</option>\n                                                    </select>\n                                                    <span class="dateRangePhenotypeName"></span>\n                                                    <label>\n                                                            has earliest date:\n                                                    </label>\n                                                    \n                                                    <div class="dropdown">\n                                                        <div class="input-group">\n                                                            <input type="text" class="form-control" data-ng-model="jobs.eDate" id="dropdown1">\n                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>\n                                                        </div>\n                                                        <ul class="dropdown-menu" role="menu">\n                                                            <datetimepicker data-ng-model="jobs.eDate"\n                                                                            data-on-set-time="earliestDate(newDate)"\n                                                                            data-datetimepicker-config="{ dropdownSelector: \'#dropdown1\' }"></datetimepicker>\n                                                        </ul>\n                                                    </div>\n                                            </div>\n                                    </div>\n                            </div> \n                            <div class="row form-inline vert-offset">\n                                    <div class="col-xs-12">\n                                            <div class="form-group">\n                                                    <select name="dateRangeLatestDateSide" class="form-control">\n                                                        <option value="START">start</option>\n                                                        <option value="FINISH">finish</option>\n                                                    </select>\n                                                    <span class="dateRangePhenotypeName"></span>\n                                                    <label>\n                                                            has latest date:\n                                                    </label>\n                                                    <div class="dropdown">\n                                                        <div class="input-group">\n                                                            <input type="text" class="form-control" data-ng-model="jobs.lDate" id="dropdown2">\n                                                            <span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>\n                                                        </div>\n                                                        <ul class="dropdown-menu" role="menu">\n                                                            <datetimepicker data-ng-model="jobs.lDate"\n                                                                            data-on-set-time="latestDate(newDate)"\n                                                                            data-datetimepicker-config="{ dropdownSelector: \'#dropdown2\' }"></datetimepicker>\n                                                        </ul>\n                                                    </div>                                                    \n                                            </div>\n                                    </div>\n                            </div>                            \n                        </fieldset>\n\n                        <div class="form-group">\n                              <input type="submit" id="startButton" class="btn btn-primary" value="Start">\n                        </div>                        \n                    </div>\n                </div>\n                \n            </form>\n        </div>\n    </div>\n</div>\n<div class="row">\n\n</div>');$templateCache.put('eureka/phenotypes/directives/phenotype-editor/phenotype-editor.html','<li\n    data-key="{{item.phenotypeKey}}"\n    data-desc="{{item.phenotypeDisplayName}}" data-type="{{item.type}}"\n    data-subtype="{{item.type == \'CATEGORIZATION\' ? item.categoricalType : \'\'}}">\n\n            <span class="glyphicon glyphicon-remove delete-icon"\n                  title="Remove this phenotype from the category"></span>\n\n    <span>{{item.phenotypeDisplayName}} ({{item.phenotypeKey}})</span>\n</li>');$templateCache.put('eureka/phenotypes/views/edit/categorization.html','<!-- Categorization  -->\n<form id="categorizationForm" class="vert-offset" role="form">\n    <div class="form-group">\n        <label for="patCohortDefName" class="control-label">Name</label>\n        <input type="text" id="patCohortDefName" class="form-control" ng-model="editPhenotype.currentObject.displayName" />\n    </div>\n    <div class="form-group">\n        <label for="patCohortDescription" class="control-label">Description</label>\n        <textarea id="patCohortDescription" class="form-control" ng-model="editPhenotype.currentObject.description"></textarea>\n    </div>\n    <div class="form-group">\n        <label for="patCohortDefinition" class="control-label">Members</label>\n        <div class="form-group text-center vert-offset ">\n            <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="editPhenotype.addCategorizationPhenotype();">Add Members</button>\n        </div>\n        <div class="row">\n            <div class="col-md-12">\n                <div class="col-md-5" style="background:#f5f5f5">\n                    <form>\n                        <fieldset>\n                            <legend>Items Added&nbsp;</legend>\n                            <p ng-repeat="selectedNode in editPhenotype.myList">\n                                <span>{{selectedNode.displayName}}</span>\n                                <p>\n                        </fieldset>\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class="form-group text-center vert-offset ">\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="editPhenotype.createCategorization()">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/edit/edit.html','<style>\n    .ng-table-pager {\n        display: none;\n    }\n    \n    table.ng-table td {\n        text-align: left;\n        width: 94%;\n    }\n    \n    a.add-node {\n        color: green;\n    }\n</style>\n<div class="row">\n    <div class="col-sm-12">\n        <h3>{{editPhenotype.name}} Editor</h3>\n        <p>\n            {{editPhenotype.description}}\n        </p>\n    </div>\n</div>\n<div class="col-md-12">\n    <div class="col-md-5">\n        <div ng-show="editPhenotype.viewObject.showTree">\n            <!--  <tree-component current-memeber-list="editPhenotype.memberList"></tree-component>  -->\n            <!-- tree -->\n\n            <div class="col-md-12">\n                <div class="row">\n                    <ol class="breadcrumb">\n                        <li class="breadcrumb-item" ng-repeat="x in editPhenotype.breadCrumbs"><a href ng-click="editPhenotype.setBreadCrumbs(x)">{{x.displayName}}</a></li>\n                    </ol>\n                </div>\n            </div>\n            <div class="col-md-7">\n                <table ng-table="editPhenotype.tableParams" class="table" show-filter="true">\n                    <tr>\n                        <div style="font-size: 21px; color:#333">System</div>\n                    </tr>\n                    <tr ng-repeat="user in $data" class="animate">\n                        <td>\n                            <span ng-if="user.parent === false" ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""> {{user.displayName}}</span>\n                            <a title="Edit" ng-click="editPhenotype.selectNode(user) " ng-if="user.parent===true">\n                                <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""></span> {{user.displayName}}\n                            </a>\n                        </td>\n                        <td>\n                            <a title="Edit" ng-click="editPhenotype.addNode(user) " class="add-node">\n                                <span class="glyphicon glyphicon-plus" title=""></span>\n                            </a>\n                        </td>\n                    </tr>\n                </table>\n                <table ng-table="editPhenotype.tableParamsUser" class="table" show-filter="true">\n                    <tr>\n                        <div style="font-size: 21px; color:#333">User</div>\n                    </tr>\n                    <tr ng-repeat="user1 in $data" class="animate">\n                        <td>\n                            <span ng-if="user1.children === false" ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""> {{user1.text}} </span>\n                            <a title="Edit" ng-if="user1.children === true" ng-click="editPhenotype.selectNode(user1) ">\n                                <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""></span> {{user1.text}}\n                            </a>\n                        </td>\n                        <td>\n                            <a title="Edit" ng-click="editPhenotype.addUserNode(user1) " class="add-node">\n                                <span class="glyphicon glyphicon-plus" title=""></span>\n                            </a>\n                        </td>\n                    </tr>\n                </table>\n            </div>\n            <div class="col-md-5" style="background:#f5f5f5">\n                <form>\n                    <fieldset>\n                        <legend>Items Added&nbsp;</legend>\n                        <p ng-repeat="selectedNode in editPhenotype.currentMemeberList">\n                            <span>{{selectedNode.displayName}}</span>\n                            <a title="remove" ng-click="editPhenotype.removeNode(selectedNode) ">\n                                <span class="glyphicon glyphicon-remove" title="" style="color:red;"></span>\n                            </a>\n                            <p>\n                    </fieldset>\n                </form>\n            </div>\n            <div class="form-group text-center vert-offset ">\n                <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="editPhenotype.addMembers()">Add</button>\n            </div>\n        </div>\n        <!-- end of tree -->\n    </div>\n    <div id="definitionContainer" class="col-md-7">\n        <div ng-if="editPhenotype.type === \'Threshold\'" ng-include="\'eureka/phenotypes/views/edit/threshold.html\'"></div>\n        <div ng-if="editPhenotype.type === \'CATEGORIZATION\'" ng-include="\'eureka/phenotypes/views/edit/categorization.html\'"></div>\n        <div ng-if="editPhenotype.type === \'FREQUENCY\'" ng-include="\'eureka/phenotypes/views/edit/frequency.html\'"></div>\n        <div ng-if="editPhenotype.type === \'SEQUENCE\'" ng-include="\'eureka/phenotypes/views/edit/sequence.html\'"></div>\n    </div>');$templateCache.put('eureka/phenotypes/views/edit/frequency.html','<form id="categorizationForm " class="vert-offset " role="form ">\n    <div class="form-group ">\n        <label for="patCohortDefName " class="control-label ">Name</label>\n        <input type="text " id="patCohortDefName " class="form-control " ng-model="editPhenotype.frequencyObject.displayName" />\n    </div>\n    <div class="form-group ">\n        <label for="patCohortDescription " class="control-label ">Description</label>\n        <textarea id="patCohortDescription " class="form-control " ng-model="editPhenotype.frequencyObject.description"></textarea>\n    </div>\n    <div class="form-group ">\n    </div>\n    <fieldset>\n        <legend>Threshold</legend>\n        <div class="form-group ">\n            <div class="col-md-4">\n                <select ng-model="editPhenotype.frequencyThreshold" class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;\n    width: 190px;">\n                    <option ng-repeat="threshold in editPhenotype.thresholdUnits">{{threshold}}</option>\n                </select>\n            </div>\n            <div class="col-md-4">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="editPhenotype.frequencyThresholdValue" />\n            </div>\n            <div class="row" style="padding-top: 10px;">\n                <div class="col-md-12">\n                </div>\n            </div>\n        </div>\n    </fieldset>\n    <div class="form-group">\n        <label for="patCohortDefinition" class="control-label">Members</label>\n        <div class="form-group text-center vert-offset ">\n            <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="editPhenotype.addFrequencyPhenotype();">Add Members</button>\n        </div>\n        <div class="row">\n            <div class="col-md-12">\n                <div class="col-md-5" style="background:#f5f5f5">\n                    <form>\n                        <fieldset>\n                            <legend>Items Added&nbsp;</legend>\n                            <p ng-repeat="selectedNode in editPhenotype.myList">\n                                <span>{{selectedNode.displayName}}</span>\n                                <p>\n                        </fieldset>\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n    <fieldset>\n        <legend style="padding-top:20px;">\n            <input type="checkbox" value="" ng-model="editPhenotype.frequencyObject.phenotype.hasDuration"></input>&nbsp; Duration</legend>\n        <div class="form-group ">\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="editPhenotype.frequencyObject.phenotype.minDuration" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="editPhenotype.frequencyObject.phenotype.minDurationUnits">\n                    <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n            <div class="col-md-2">\n                <span>to</span>\n            </div>\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="editPhenotype.frequencyObject.phenotype.maxDuration" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="editPhenotype.frequencyObject.phenotype.maxDurationUnits">\n                    <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n        </div>\n    </fieldset>\n    <fieldset>\n        <legend style="padding-top:20px;">\n            <input type="checkbox" value="" ng-model="editPhenotype.frequencyObject.phenotype.hasPropertyConstraint"></input>&nbsp; Property Value</legend>\n        <div class="form-group ">\n            <div class="col-md-4">\n                <select class="selectpicker" ng-model="editPhenotype.frequencyObject.phenotype.property" style="    height: 33px; width: 190px;">\n                    <option ng-repeat="pp in editPhenotype.phenotypeProperties">{{pp}}</option>\n                </select>\n            </div>\n            <div class="col-md-4">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="editPhenotype.frequencyObject.phenotype.propertyValue" />\n            </div>\n        </div>\n    </fieldset>\n    <fieldset>\n        <legend style="padding-top:20px;">\n            <input type="checkbox" value="" ng-model="editPhenotype.frequencyObject.isWithin"></input>&nbsp; Disatance value</legend>\n        <div class="form-group ">\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="editPhenotype.frequencyObject.withinAtLeast" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" ng-model="editPhenotype.frequencyObject.withinAtLeastUnits" style="    height: 33px;">\n                    <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n            <div class="col-md-2">\n                <span>to</span>\n            </div>\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="editPhenotype.frequencyObject.withinAtMost" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" ng-model="editPhenotype.frequencyObject.withinAtMostUnits" style="    height: 33px;">\n                    <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n        </div>\n    </fieldset>\n    <div class="form-group text-center vert-offset ">\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="editPhenotype.createFrequency();">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/edit/sequence.html','<form id="sequenceForm " class="vert-offset " role="form ">\n    <div class="form-group ">\n        <label for="patCohortDefName " class="control-label ">Name</label>\n        <input type="text " id="patCohortDefName " class="form-control " ng-model="editPhenotype.seqObject.displayName" />\n    </div>\n    <div class="form-group ">\n        <label for="patCohortDescription " class="control-label ">Description</label>\n        <textarea id="patCohortDescription " class="form-control " ng-model="editPhenotype.seqObject.description"></textarea>\n    </div>\n    <div class="form-group ">\n        <div id="propDefinition " class="col-sm-12 panel panel-default ">\n            <div class="row panel-heading ">\n                <h4 class="panel-title ">Main Phenotype</h4>\n            </div>\n            <div class="form-group ">\n                <div class="col-sm-12 ">\n                    <label class="sr-only " for="mainPhenotype ">Main phenotype</label>\n                </div>\n            </div>\n            <div class="form-group text-center vert-offset ">\n                <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="editPhenotype.addMainPhenotype();">Add Members</button>\n            </div>\n            <div class="row" style="padding-top: 10px;">\n                <div class="col-md-12">\n                    <div class="col-md-5" style="background:#f5f5f5">\n                        <form>\n                            <fieldset>\n                                <legend>Items Added&nbsp;</legend>\n                                <p>\n                                    <span>{{editPhenotype.seqObject.primaryPhenotype.phenotypeKey}}</span>\n                                    <p>\n                            </fieldset>\n                        </form>\n                    </div>\n                </div>\n            </div>\n            <fieldset>\n                <legend style="padding-top:20px;">\n                    <input type="checkbox" value="" ng-model="editPhenotype.seqObject.primaryPhenotype.hasDuration"></input>&nbsp; Duration</legend>\n                <div class="form-group ">\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="editPhenotype.seqObject.primaryPhenotype.minDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="editPhenotype.seqObject.primaryPhenotype.minDurationUnits">\n                            <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-2">\n                        <span>to</span>\n                    </div>\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="editPhenotype.seqObject.primaryPhenotype.maxDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="editPhenotype.seqObject.primaryPhenotype.maxDurationUnits">\n                            <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                </div>\n            </fieldset>\n            <fieldset style="padding-bottom:10px">\n                <legend style="padding-top:20px;">\n                    <input type="checkbox" value="" ng-model="editPhenotype.seqObject.primaryPhenotype.hasPropertyConstraint"></input>&nbsp; Property Value</legend>\n                <div class="form-group ">\n                    <div class="col-md-4">\n                        <select class="selectpicker" ng-model="editPhenotype.seqObject.primaryPhenotype.property" style="    height: 33px; width: 190px;">\n                            <option ng-repeat="pp in editPhenotype.phenotypeProperties" value="{{pp}}">{{pp}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-4">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="editPhenotype.seqObject.primaryPhenotype.propertyValue" />\n                    </div>\n                </div>\n            </fieldset>\n        </div>\n    </div>\n    <div class="form-group " ng-repeat="relatedPhenotype in editPhenotype.seqObject.relatedPhenotypes">\n        <div id="sequenceRelatedPhenotypes " class="sequence-relations-container ">\n            <div class="sequence-relation drop-parent panel panel-default col-sm-12 ">\n                <div class="row panel-heading ">\n                    <h4 class="panel-title ">Related phenotype <span class="count ">{{$index + 1}}</span></h4>\n                </div>\n                <div class="form-group ">\n                    <div class="col-sm-12 ">\n                        <label class="sr-only " for="relatedPhenotype${status.count} ">Related phenotype </label>\n                    </div>\n                </div>\n                <div class="form-group text-center vert-offset ">\n                    <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="editPhenotype.addPhenotypeToRelated($index+1);">Add Members</button>\n                </div>\n                <div class="row" style="padding-top: 10px;">\n                    <div class="col-md-12">\n                        <div class="col-md-5" style="background:#f5f5f5">\n                            <form>\n                                <fieldset>\n                                    <legend>Items Added&nbsp;</legend>\n                                    <p>\n                                        <span>{{relatedPhenotype.phenotypeField.phenotypeKey}}</span>\n                                        <p>\n                                </fieldset>\n                            </form>\n                        </div>\n                    </div>\n                </div>\n                <fieldset>\n                    <legend style="padding-top:20px;">\n                        <input type="checkbox" value="" ng-model="relatedPhenotype.phenotypeField.hasDuration"></input>&nbsp; Duration</legend>\n                    <div class="form-group ">\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="relatedPhenotype.phenotypeField.minDuration" />\n                        </div>\n                        <div class="col-md-3">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="relatedPhenotype.phenotypeField.minDurationUnits">\n                                <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-2">\n                            <span>to</span>\n                        </div>\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="relatedPhenotype.phenotypeField.maxDuration" />\n                        </div>\n                        <div class="col-md-3">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="relatedPhenotype.phenotypeField.maxDurationUnits">\n                                <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend style="padding-top:20px;">\n                        <input type="checkbox" value="" ng-model="relatedPhenotype.phenotypeField.hasPropertyConstraint"></input>&nbsp; Property Value</legend>\n                    <div class="form-group ">\n                        <div class="col-md-4">\n                            <select class="selectpicker" ng-model="relatedPhenotype.phenotypeField.property" style="    height: 33px; width: 190px;">\n                                <option ng-repeat="pp in relatedPhenotype.phenotypeField.properties" value="{{pp}}">{{pp}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-4">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="relatedPhenotype.phenotypeField.propertyValue" />\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset style="padding-bottom:10px">\n                    <legend style="padding-top:20px;"> Temporal relationship</legend>\n                    <div class="form-group ">\n                        <div class="col-md-6">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px; width:100%" ng-model="relatedPhenotype.relationOperator">\n                                <option ng-repeat="sr in editPhenotype.sequenceRelations" value="{{sr.value}}">{{sr.name}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-6" style="padding-bottom: 24px;">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px; width:100%" ng-model="relatedPhenotype.sequentialPhenotype">\n                                <option ng-repeat="rtp in editPhenotype.releatedTemporalArray">{{rtp}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-2">\n                            <span>by</span>\n                        </div>\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="relatedPhenotype.relationMinCount" />\n                        </div>\n                        <div class="col-md-2">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="relatedPhenotype.relationMinUnits">\n                                <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-2">\n                            <span>to</span>\n                        </div>\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="relatedPhenotype.relationMaxCount" />\n                        </div>\n                        <div class="col-md-2">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="relatedPhenotype.relationMaxUnits">\n                                <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                    </div>\n                </fieldset>\n            </div>\n        </div>\n    </div>\n    <div class="form-group text-center vert-offset ">\n        <button id="addRelatedPhenotype" type="button " class="btn btn-primary " ng-click="editPhenotype.addRelatedPhenotypes();">\n            <span class="glyphicon glyphicon-plus "></span> Add Related Phenotype\n        </button>\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="editPhenotype.createSequence();">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/edit/threshold.html','<form id="thresholdForm" class="vert-offset" role="form">\n    <div class="form-group">\n        <label for="patCohortDefName" class="control-label">Name</label>\n        <input type="text" id="patCohortDefName" class="form-control" ng-model="editPhenotype.thresholdObject.displayName" />\n    </div>\n    <div class="form-group">\n        <label for="patCohortDescription" class="control-label">Description</label>\n        <textarea id="patCohortDescription" class="form-control" ng-model="editPhenotype.thresholdObject.description"></textarea>\n    </div>\n    <div class="form-group">\n        <div>\n            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="width:50%; height: 33px;" ng-model="editPhenotype.thresholdObject.thresholdsOperator">\n                <option ng-repeat="tt in editPhenotype.thresholdtypes" value="{{tt.value}}">{{tt.display}}</option>\n            </select>\n        </div>\n    </div>\n    <div class="form-group " ng-repeat="valueThreshold in editPhenotype.thresholdObject.valueThresholds">\n        <div id="propDefinition " class="col-sm-12 panel panel-default ">\n            <div class="row panel-heading ">\n                <h4 class="panel-title ">Value Threshold <span class="count ">{{$index + 1}}</span></h4>\n            </div>\n            <div class="form-group ">\n                <div class="col-sm-12 ">\n                    <label class="sr-only " for="mainPhenotype ">Main phenotype</label>\n                </div>\n            </div>\n            <div class="row" style="padding-top: 10px;">\n                <div class="col-md-12">\n                    <div class="form-group text-center vert-offset ">\n                        <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="editPhenotype.addPhenotypeToThreshold($index+1);">Add Members</button>\n                    </div>\n                    <div class="row" style="padding-top: 10px;">\n                        <div class="col-md-12">\n                            <div class="col-md-5" style="background:#f5f5f5">\n                                <form>\n                                    <fieldset>\n                                        <legend>Items Added&nbsp;</legend>\n                                        <p>\n                                            <span>{{valueThreshold.phenotype.phenotypeKey}}</span>\n                                            <p>\n                                    </fieldset>\n                                </form>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <fieldset>\n                <legend style="padding-top:20px;">&nbsp;</legend>\n                <div class="form-group ">\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="editPhenotype.seqObject.phenotype.minDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="editPhenotype.valueThreshold.phenotype.lowerValue">\n                            <option ng-repeat="th in editPhenotype.thresholdCompValues" value="{{th.value}}">{{th.display}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-2">\n                        <span>to</span>\n                    </div>\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="editPhenotype.seqObject.phenotype.maxDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="editPhenotype.valueThreshold.phenotype.upperValue">\n                            <option ng-repeat="th in editPhenotype.thresholdCompValues" value="{{th.value}}">{{th.display}}</option>\n                        </select>\n                    </div>\n                </div>\n                <legend style="padding-top:20px;">Context(s)</legend>\n                <div class="form-group text-center vert-offset ">\n                    <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="editPhenotype.addPhenotypeToThreshold($index+1, \'relatedPhenotypes\');">Add Members</button>\n                </div>\n                <div class="row" style="padding-top: 10px; padding-bottom: 10px;">\n                    <div class="col-md-12">\n                        <div class="col-md-5" style="background:#f5f5f5">\n                            <form>\n                                <fieldset>\n                                    <legend>Items Added&nbsp;</legend>\n                                    <p>\n                                        <span>{{valueThreshold.phenotype.relatedPhenotypeKey}}</span>\n                                        <p>\n                                </fieldset>\n                            </form>\n                        </div>\n                    </div>\n                </div>\n                <div class="form-group ">\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="editPhenotype.valueThreshold.phenotype.withinAtLeast" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="editPhenotype.valueThreshold.phenotype.withinAtLeastUnit">\n                            <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-2">\n                        <span>to</span>\n                    </div>\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="editPhenotype.valueThreshold.phenotype.withinAtMost" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="editPhenotype.valueThreshold.phenotype.withinAtMostUnit">\n                            <option ng-repeat="tu in editPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-12" style="padding-top: 10px; padding-bottom: 10px;">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style=" width:50%;   height: 33px;" ng-model="editPhenotype.valueThreshold.phenotype.relationOperator">\n                            <option ng-repeat="tt in editPhenotype.thresholdRelationTypes" value="{{tt.value}}">{{tt.display}}</option>\n                        </select>\n                    </div>\n                </div>\n            </fieldset>\n        </div>\n    </div>\n    <div class="form-group text-center vert-offset ">\n        <button id="addRelatedPhenotype" type="button " class="btn btn-primary " ng-click="editPhenotype.addNewThreshold();">\n            <span class="glyphicon glyphicon-plus "></span> Add Threshold\n        </button>\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="editPhenotype.createThreshold();">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/create/categorization.html','<!-- Categorization  -->\n<form id="categorizationForm" class="vert-offset" role="form">\n    <div class="form-group">\n        <label for="patCohortDefName" class="control-label">Name</label>\n        <input type="text" id="patCohortDefName" class="form-control" ng-model="createPhenotype.currentObject.displayName" />\n    </div>\n    <div class="form-group">\n        <label for="patCohortDescription" class="control-label">Description</label>\n        <textarea id="patCohortDescription" class="form-control" ng-model="createPhenotype.currentObject.description"></textarea>\n    </div>\n    <div class="form-group">\n        <label for="patCohortDefinition" class="control-label">Members</label>\n        <div class="form-group text-center vert-offset ">\n            <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="createPhenotype.addCategorizationPhenotype();">Add Members</button>\n        </div>\n        <div class="row">\n            <div class="col-md-12">\n                <div class="col-md-5" style="background:#f5f5f5">\n                    <form>\n                        <fieldset>\n                            <legend>Items Added&nbsp;</legend>\n                            <p ng-repeat="selectedNode in createPhenotype.myList">\n                                <span>{{selectedNode.displayName}}</span>\n                                <p>\n                        </fieldset>\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class="form-group text-center vert-offset " ng-if="createPhenotype.type === \'Categorization\'">\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="createPhenotype.createCategorization()">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/create/create.html','<style>\n    .ng-table-pager {\n        display: none;\n    }\n    \n    table.ng-table td {\n        text-align: left;\n        width: 94%;\n    }\n    \n    a.add-node {\n        color: green;\n    }\n</style>\n<div class="row">\n    <div class="col-sm-12">\n        <h3>{{createPhenotype.type}} Editor</h3>\n        <p>\n            {{createPhenotype.description}}\n        </p>\n    </div>\n</div>\n<div class="col-md-12">\n    <div class="col-md-5">\n        <div ng-show="createPhenotype.viewObject.showTree">\n            <!--  <tree-component current-memeber-list="createPhenotype.memberList"></tree-component>  -->\n            <!-- tree -->\n\n            <div class="col-md-12">\n                <div class="row">\n                    <ol class="breadcrumb">\n                        <li class="breadcrumb-item" ng-repeat="x in createPhenotype.breadCrumbs"><a href ng-click="createPhenotype.setBreadCrumbs(x)">{{x.displayName}}</a></li>\n                    </ol>\n                </div>\n            </div>\n            <div class="col-md-7">\n                <table ng-table="createPhenotype.tableParams" class="table" show-filter="true">\n                    <tr>\n                        <div style="font-size: 21px; color:#333">System</div>\n                    </tr>\n                    <tr ng-repeat="user in $data" class="animate">\n                        <td>\n                            <span ng-if="user.parent === false" ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""> {{user.displayName}}</span>\n                            <a title="Edit" ng-click="createPhenotype.selectNode(user) " ng-if="user.parent===true">\n                                <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""></span> {{user.displayName}}\n                            </a>\n                        </td>\n                        <td>\n                            <a title="Edit" ng-click="createPhenotype.addNode(user) " class="add-node">\n                                <span class="glyphicon glyphicon-plus" title=""></span>\n                            </a>\n                        </td>\n                    </tr>\n                </table>\n                <table ng-table="createPhenotype.tableParamsUser" class="table" show-filter="true">\n                    <tr>\n                        <div style="font-size: 21px; color:#333">User</div>\n                    </tr>\n                    <tr ng-repeat="user1 in $data" class="animate">\n                        <td>\n                            <span ng-if="user1.children === false" ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""> {{user1.text}} </span>\n                            <a title="Edit" ng-if="user1.children === true" ng-click="createPhenotype.selectNode(user1) ">\n                                <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""></span> {{user1.text}}\n                            </a>\n                        </td>\n                        <td>\n                            <a title="Edit" ng-click="createPhenotype.addUserNode(user1) " class="add-node">\n                                <span class="glyphicon glyphicon-plus" title=""></span>\n                            </a>\n                        </td>\n                    </tr>\n                </table>\n            </div>\n            <div class="col-md-5" style="background:#f5f5f5">\n                <form>\n                    <fieldset>\n                        <legend>Items Added&nbsp;</legend>\n                        <p ng-repeat="selectedNode in createPhenotype.currentMemeberList">\n                            <span>{{selectedNode.displayName}}</span>\n                            <a title="remove" ng-click="createPhenotype.removeNode(selectedNode) ">\n                                <span class="glyphicon glyphicon-remove" title="" style="color:red;"></span>\n                            </a>\n                            <p>\n                    </fieldset>\n                </form>\n            </div>\n            <div class="form-group text-center vert-offset ">\n                <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="createPhenotype.addMembers()">Add</button>\n            </div>\n        </div>\n        <!-- end of tree -->\n    </div>\n    <div id="definitionContainer" class="col-md-7">\n        <div ng-if="createPhenotype.type === \'Threshold\'" ng-include="\'eureka/phenotypes/views/create/threshold.html\'"></div>\n        <div ng-if="createPhenotype.type === \'Categorization\'" ng-include="\'eureka/phenotypes/views/create/categorization.html\'"></div>\n        <div ng-if="createPhenotype.type === \'Frequency\'" ng-include="\'eureka/phenotypes/views/create/frequency.html\'"></div>\n        <div ng-if="createPhenotype.type === \'Sequence\'" ng-include="\'eureka/phenotypes/views/create/sequence.html\'"></div>\n    </div>');$templateCache.put('eureka/phenotypes/views/create/frequency.html','<form id="categorizationForm " class="vert-offset " role="form ">\n    <div class="form-group ">\n        <label for="patCohortDefName " class="control-label ">Name</label>\n        <input type="text " id="patCohortDefName " class="form-control " ng-model="createPhenotype.frequencyObject.displayName" />\n    </div>\n    <div class="form-group ">\n        <label for="patCohortDescription " class="control-label ">Description</label>\n        <textarea id="patCohortDescription " class="form-control " ng-model="createPhenotype.frequencyObject.description"></textarea>\n    </div>\n    <div class="form-group ">\n    </div>\n    <fieldset>\n        <legend>Threshold</legend>\n        <div class="form-group ">\n            <div class="col-md-4">\n                <select ng-model="createPhenotype.frequencyThreshold" class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;\n    width: 190px;">\n                    <option ng-repeat="threshold in createPhenotype.thresholdUnits">{{threshold}}</option>\n                </select>\n            </div>\n            <div class="col-md-4">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="createPhenotype.frequencyThresholdValue" />\n            </div>\n            <div class="row" style="padding-top: 10px;">\n                <div class="col-md-12">\n                </div>\n            </div>\n        </div>\n    </fieldset>\n    <div class="form-group">\n        <label for="patCohortDefinition" class="control-label">Members</label>\n        <div class="form-group text-center vert-offset ">\n            <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="createPhenotype.addFrequencyPhenotype();">Add Members</button>\n        </div>\n        <div class="row">\n            <div class="col-md-12">\n                <div class="col-md-5" style="background:#f5f5f5">\n                    <form>\n                        <fieldset>\n                            <legend>Items Added&nbsp;</legend>\n                            <p ng-repeat="selectedNode in createPhenotype.myList">\n                                <span>{{selectedNode.displayName}}</span>\n                                <p>\n                        </fieldset>\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n    <fieldset>\n        <legend style="padding-top:20px;">\n            <input type="checkbox" value="" ng-model="createPhenotype.frequencyObject.phenotype.hasDuration"></input>&nbsp; Duration</legend>\n        <div class="form-group ">\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="createPhenotype.frequencyObject.phenotype.minDuration" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="createPhenotype.frequencyObject.phenotype.minDurationUnits">\n                    <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n            <div class="col-md-2">\n                <span>to</span>\n            </div>\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="createPhenotype.frequencyObject.phenotype.maxDuration" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="createPhenotype.frequencyObject.phenotype.maxDurationUnits">\n                    <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n        </div>\n    </fieldset>\n    <fieldset>\n        <legend style="padding-top:20px;">\n            <input type="checkbox" value="" ng-model="createPhenotype.frequencyObject.phenotype.hasPropertyConstraint"></input>&nbsp; Property Value</legend>\n        <div class="form-group ">\n            <div class="col-md-4">\n                <select class="selectpicker" ng-model="createPhenotype.frequencyObject.phenotype.property" style="    height: 33px; width: 190px;">\n                    <option ng-repeat="pp in createPhenotype.phenotypeProperties">{{pp}}</option>\n                </select>\n            </div>\n            <div class="col-md-4">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="createPhenotype.frequencyObject.phenotype.propertyValue" />\n            </div>\n        </div>\n    </fieldset>\n    <fieldset>\n        <legend style="padding-top:20px;">\n            <input type="checkbox" value="" ng-model="createPhenotype.frequencyObject.isWithin"></input>&nbsp; Disatance value</legend>\n        <div class="form-group ">\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="createPhenotype.frequencyObject.withinAtLeast" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" ng-model="createPhenotype.frequencyObject.withinAtLeastUnits" style="    height: 33px;">\n                    <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n            <div class="col-md-2">\n                <span>to</span>\n            </div>\n            <div class="col-md-2">\n                <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="createPhenotype.frequencyObject.withinAtMost" />\n            </div>\n            <div class="col-md-3">\n                <select class="selectpicker" ng-model="createPhenotype.frequencyObject.withinAtMostUnits" style="    height: 33px;">\n                    <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                </select>\n            </div>\n        </div>\n    </fieldset>\n    <div class="form-group text-center vert-offset " ng-if="createPhenotype.type===\'Frequency\'">\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="createPhenotype.createFrequency();">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/create/sequence.html','<form id="sequenceForm " class="vert-offset " role="form ">\n    <div class="form-group ">\n        <label for="patCohortDefName " class="control-label ">Name</label>\n        <input type="text " id="patCohortDefName " class="form-control " ng-model="createPhenotype.seqObject.displayName" />\n    </div>\n    <div class="form-group ">\n        <label for="patCohortDescription " class="control-label ">Description</label>\n        <textarea id="patCohortDescription " class="form-control " ng-model="createPhenotype.seqObject.description"></textarea>\n    </div>\n    <div class="form-group ">\n        <div id="propDefinition " class="col-sm-12 panel panel-default ">\n            <div class="row panel-heading ">\n                <h4 class="panel-title ">Main Phenotype</h4>\n            </div>\n            <div class="form-group ">\n                <div class="col-sm-12 ">\n                    <label class="sr-only " for="mainPhenotype ">Main phenotype</label>\n                </div>\n            </div>\n            <div class="form-group text-center vert-offset ">\n                <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="createPhenotype.addMainPhenotype();">Add Members</button>\n            </div>\n            <div class="row" style="padding-top: 10px;">\n                <div class="col-md-12">\n                    <div class="col-md-5" style="background:#f5f5f5">\n                        <form>\n                            <fieldset>\n                                <legend>Items Added&nbsp;</legend>\n                                <p>\n                                    <span>{{createPhenotype.seqObject.primaryPhenotype.phenotypeKey}}</span>\n                                    <p>\n                            </fieldset>\n                        </form>\n                    </div>\n                </div>\n            </div>\n            <fieldset>\n                <legend style="padding-top:20px;">\n                    <input type="checkbox" value="" ng-model="createPhenotype.seqObject.primaryPhenotype.hasDuration"></input>&nbsp; Duration</legend>\n                <div class="form-group ">\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="createPhenotype.seqObject.primaryPhenotype.minDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="createPhenotype.seqObject.primaryPhenotype.minDurationUnits">\n                            <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-2">\n                        <span>to</span>\n                    </div>\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="createPhenotype.seqObject.primaryPhenotype.maxDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="createPhenotype.seqObject.primaryPhenotype.maxDurationUnits">\n                            <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                </div>\n            </fieldset>\n            <fieldset style="padding-bottom:10px">\n                <legend style="padding-top:20px;">\n                    <input type="checkbox" value="" ng-model="createPhenotype.seqObject.primaryPhenotype.hasPropertyConstraint"></input>&nbsp; Property Value</legend>\n                <div class="form-group ">\n                    <div class="col-md-4">\n                        <select class="selectpicker" ng-model="createPhenotype.seqObject.primaryPhenotype.property" style="    height: 33px; width: 190px;">\n                            <option ng-repeat="pp in createPhenotype.phenotypeProperties" value="{{pp}}">{{pp}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-4">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="createPhenotype.seqObject.primaryPhenotype.propertyValue" />\n                    </div>\n                </div>\n            </fieldset>\n        </div>\n    </div>\n    <div class="form-group " ng-repeat="relatedPhenotype in createPhenotype.seqObject.relatedPhenotypes">\n        <div id="sequenceRelatedPhenotypes " class="sequence-relations-container ">\n            <div class="sequence-relation drop-parent panel panel-default col-sm-12 ">\n                <div class="row panel-heading ">\n                    <h4 class="panel-title ">Related phenotype <span class="count ">{{$index + 1}}</span></h4>\n                </div>\n                <div class="form-group ">\n                    <div class="col-sm-12 ">\n                        <label class="sr-only " for="relatedPhenotype${status.count} ">Related phenotype </label>\n                    </div>\n                </div>\n                <div class="form-group text-center vert-offset ">\n                    <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="createPhenotype.addPhenotypeToRelated($index+1);">Add Members</button>\n                </div>\n                <div class="row" style="padding-top: 10px;">\n                    <div class="col-md-12">\n                        <div class="col-md-5" style="background:#f5f5f5">\n                            <form>\n                                <fieldset>\n                                    <legend>Items Added&nbsp;</legend>\n                                    <p>\n                                        <span>{{relatedPhenotype.phenotypeField.phenotypeKey}}</span>\n                                        <p>\n                                </fieldset>\n                            </form>\n                        </div>\n                    </div>\n                </div>\n                <fieldset>\n                    <legend style="padding-top:20px;">\n                        <input type="checkbox" value="" ng-model="relatedPhenotype.phenotypeField.hasDuration"></input>&nbsp; Duration</legend>\n                    <div class="form-group ">\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="relatedPhenotype.phenotypeField.minDuration" />\n                        </div>\n                        <div class="col-md-3">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="relatedPhenotype.phenotypeField.minDurationUnits">\n                                <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-2">\n                            <span>to</span>\n                        </div>\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="relatedPhenotype.phenotypeField.maxDuration" />\n                        </div>\n                        <div class="col-md-3">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="relatedPhenotype.phenotypeField.maxDurationUnits">\n                                <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend style="padding-top:20px;">\n                        <input type="checkbox" value="" ng-model="relatedPhenotype.phenotypeField.hasPropertyConstraint"></input>&nbsp; Property Value</legend>\n                    <div class="form-group ">\n                        <div class="col-md-4">\n                            <select class="selectpicker" ng-model="relatedPhenotype.phenotypeField.property" style="    height: 33px; width: 190px;">\n                                <option ng-repeat="pp in relatedPhenotype.phenotypeField.properties" value="{{pp}}">{{pp}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-4">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " ng-model="relatedPhenotype.phenotypeField.propertyValue" />\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset style="padding-bottom:10px">\n                    <legend style="padding-top:20px;"> Temporal relationship</legend>\n                    <div class="form-group ">\n                        <div class="col-md-6">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px; width:100%" ng-model="relatedPhenotype.relationOperator">\n                                <option ng-repeat="sr in createPhenotype.sequenceRelations" value="{{sr.value}}">{{sr.name}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-6" style="padding-bottom: 24px;">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px; width:100%" ng-model="relatedPhenotype.sequentialPhenotype">\n                                <option ng-repeat="rtp in createPhenotype.releatedTemporalArray">{{rtp}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-2">\n                            <span>by</span>\n                        </div>\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="relatedPhenotype.relationMinCount" />\n                        </div>\n                        <div class="col-md-2">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="relatedPhenotype.relationMinUnits">\n                                <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                        <div class="col-md-2">\n                            <span>to</span>\n                        </div>\n                        <div class="col-md-2">\n                            <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="relatedPhenotype.relationMaxCount" />\n                        </div>\n                        <div class="col-md-2">\n                            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="relatedPhenotype.relationMaxUnits">\n                                <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                            </select>\n                        </div>\n                    </div>\n                </fieldset>\n            </div>\n        </div>\n    </div>\n    <div class="form-group text-center vert-offset ">\n        <button id="addRelatedPhenotype" type="button " class="btn btn-primary " ng-click="createPhenotype.addRelatedPhenotypes();">\n            <span class="glyphicon glyphicon-plus "></span> Add Related Phenotype\n        </button>\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="createPhenotype.createSequence();">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/create/threshold.html','<form id="thresholdForm" class="vert-offset" role="form">\n    <div class="form-group">\n        <label for="patCohortDefName" class="control-label">Name</label>\n        <input type="text" id="patCohortDefName" class="form-control" ng-model="createPhenotype.thresholdObject.displayName" />\n    </div>\n    <div class="form-group">\n        <label for="patCohortDescription" class="control-label">Description</label>\n        <textarea id="patCohortDescription" class="form-control" ng-model="createPhenotype.thresholdObject.description"></textarea>\n    </div>\n    <div class="form-group">\n        <div>\n            <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="width:50%; height: 33px;" ng-model="createPhenotype.thresholdObject.thresholdsOperator">\n                <option ng-repeat="tt in createPhenotype.thresholdtypes" value="{{tt.value}}">{{tt.display}}</option>\n            </select>\n        </div>\n    </div>\n    <div class="form-group " ng-repeat="valueThreshold in createPhenotype.thresholdObject.valueThresholds">\n        <div id="propDefinition " class="col-sm-12 panel panel-default ">\n            <div class="row panel-heading ">\n                <h4 class="panel-title ">Value Threshold <span class="count ">{{$index + 1}}</span></h4>\n            </div>\n            <div class="form-group ">\n                <div class="col-sm-12 ">\n                    <label class="sr-only " for="mainPhenotype ">Main phenotype</label>\n                </div>\n            </div>\n            <div class="row" style="padding-top: 10px;">\n                <div class="col-md-12">\n                    <div class="form-group text-center vert-offset ">\n                        <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="createPhenotype.addPhenotypeToThreshold($index+1);">Add Members</button>\n                    </div>\n                    <div class="row" style="padding-top: 10px;">\n                        <div class="col-md-12">\n                            <div class="col-md-5" style="background:#f5f5f5">\n                                <form>\n                                    <fieldset>\n                                        <legend>Items Added&nbsp;</legend>\n                                        <p>\n                                            <span>{{valueThreshold.phenotype.phenotypeKey}}</span>\n                                            <p>\n                                    </fieldset>\n                                </form>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <fieldset>\n                <legend style="padding-top:20px;">&nbsp;</legend>\n                <div class="form-group ">\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="createPhenotype.seqObject.phenotype.minDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="createPhenotype.valueThreshold.phenotype.lowerValue">\n                            <option ng-repeat="th in createPhenotype.thresholdCompValues" value="{{th.value}}">{{th.display}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-2">\n                        <span>to</span>\n                    </div>\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="createPhenotype.seqObject.phenotype.maxDuration" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="createPhenotype.valueThreshold.phenotype.upperValue">\n                            <option ng-repeat="th in createPhenotype.thresholdCompValues" value="{{th.value}}">{{th.display}}</option>\n                        </select>\n                    </div>\n                </div>\n                <legend style="padding-top:20px;">Context(s)</legend>\n                <div class="form-group text-center vert-offset ">\n                    <button id="addMainPhenotype " type="button " class="btn btn-primary " ng-click="createPhenotype.addPhenotypeToThreshold($index+1, \'relatedPhenotypes\');">Add Members</button>\n                </div>\n                <div class="row" style="padding-top: 10px; padding-bottom: 10px;">\n                    <div class="col-md-12">\n                        <div class="col-md-5" style="background:#f5f5f5">\n                            <form>\n                                <fieldset>\n                                    <legend>Items Added&nbsp;</legend>\n                                    <p>\n                                        <span>{{valueThreshold.phenotype.relatedPhenotypeKey}}</span>\n                                        <p>\n                                </fieldset>\n                            </form>\n                        </div>\n                    </div>\n                </div>\n                <div class="form-group ">\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="min" ng-model="createPhenotype.valueThreshold.phenotype.withinAtLeast" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="height: 33px;" ng-model="createPhenotype.valueThreshold.phenotype.withinAtLeastUnit">\n                            <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-2">\n                        <span>to</span>\n                    </div>\n                    <div class="col-md-2">\n                        <input type="number " min="1 " value=" " title="Specify the frequency count " class="form-control " placeholder="max" ng-model="createPhenotype.valueThreshold.phenotype.withinAtMost" />\n                    </div>\n                    <div class="col-md-3">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style="    height: 33px;" ng-model="createPhenotype.valueThreshold.phenotype.withinAtMostUnit">\n                            <option ng-repeat="tu in createPhenotype.timeUnits" value="{{tu.value}}">{{tu.name}}</option>\n                        </select>\n                    </div>\n                    <div class="col-md-12" style="padding-top: 10px; padding-bottom: 10px;">\n                        <select class="selectpicker" title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) " style=" width:50%;   height: 33px;" ng-model="createPhenotype.valueThreshold.phenotype.relationOperator">\n                            <option ng-repeat="tt in createPhenotype.thresholdRelationTypes" value="{{tt.value}}">{{tt.display}}</option>\n                        </select>\n                    </div>\n                </div>\n            </fieldset>\n        </div>\n    </div>\n    <div class="form-group text-center vert-offset ">\n        <button id="addRelatedPhenotype" type="button " class="btn btn-primary " ng-click="createPhenotype.addNewThreshold();">\n            <span class="glyphicon glyphicon-plus "></span> Add Threshold\n        </button>\n        <button id="savePhenotypeButton " type="button " class="btn btn-primary " ng-click="createPhenotype.createThreshold();">Save</button>\n    </div>\n</form>');$templateCache.put('eureka/phenotypes/views/main/main.html','<div class="row">\n    <div class="col-sm-12">\n        <h3>Phenotype Editor</h3>\n        <p> Specify the phenotypes that you want to compute in your datasets below. Phenotypes are patient features inferred from sequence, frequency and other temporal patterns in the events and observations in your dataset. These features are computed as\n            intervals with a start time and a stop time representing when they are present.\n        </p>\n        <p>\n            <div class="btn-group" uib-dropdown keyboard-nav>\n                <button id="simple-btn-keyboard-nav" type="button" class="btn btn-primary" uib-dropdown-toggle>\n          <span class="glyphicon glyphicon-plus-sign"></span>\n            <span>Create New Element</span> \n            <span class="caret"></span>\n        </button>\n                <ul class="dropdown-menu" uib-dropdown-menu role="menu" aria-labelledby="simple-btn-keyboard-nav">\n                    <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'categorization\')">{{phenotypes.messages.CATEGORIZATION.displayName}} <p>{{phenotypes.messages.CATEGORIZATION.description}}</p></a></li>\n                    <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'sequence\')">{{phenotypes.messages.SEQUENCE.displayName}} <p>{{phenotypes.messages.SEQUENCE.description}}</p></a></li>\n                    <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'frequency\')">{{phenotypes.messages.FREQUENCY.displayName}} <p>{{phenotypes.messages.FREQUENCY.description}}</p></a></li>\n                    <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'threshold\')">{{phenotypes.messages.THRESHOLD.displayName}} <p>{{phenotypes.messages.THRESHOLD.description}}</p></a></li>\n                </ul>\n            </div>\n        </p>\n    </div>\n</div>\n<!-- ng-table -->\n<div class="row">\n    <div class="col-md-12">\n        <table ng-table="phenotypes.tableParams" class="table" show-filter="true">\n            <tr ng-repeat="user in $data">\n                <td>\n                    <a title="Edit" ui-sref="editPhenotype({ id: user.key })">\n                        <span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>\n                    </a>\n                    <span class="glyphicon glyphicon-remove delete-icon" ng-click="phenotypes.deletePhenotype(user, $index)" title="Delete"></span>\n                </td>\n                <td title="\'Name\'" filter="{ displayName: \'text\'}" sortable="\'displayName\'">\n                    {{user.displayName}}\n                </td>\n                <td title="\'Description\'" filter="{ description: \'text\'}" sortable="\'description\'">\n                    {{user.description}}\n                </td>\n                <td title="\'Type\'" filter="{ type: \'text\'}" sortable="\'type\'">\n                    {{user.type}}\n                </td>\n                <td title="\'Created\'" filter="{ created: \'text\'}" sortable="\'created\'">\n                    {{user.created | date:\'MM/dd/yyyy\'}}\n                </td>\n                <td title="\'lastModified\'" filter="{ lastModified: \'text\'}" sortable="\'lastModified\'">\n                    {{user.lastModified | date:\'MM/dd/yyyy\'}}\n                </td>\n            </tr>\n        </table>\n    </div>\n</div>\n\n<script type="text/ng-template" id="myModal.html">\n    <div class="modal-header">\n        <h3 class="modal-title">Delete Element</h3>\n    </div>\n    <div class="modal-body">\n        Are you sure you would like to remove this item?\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-primary" ng-click="mo.ok()">Delete</button>\n        <button class="btn btn-primary" ng-click="mo.cancel()">Close</button>\n    </div>\n</script>\n\n<script type="text/ng-template" id="errorModal.html">\n    <div class="modal-header">\n        <h3 class="modal-title">Error</h3>\n    </div>\n    <div class="modal-body">\n        {{mod.data}}\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-primary" ng-click="mod.cancel()">Close</button>\n    </div>\n</script>');}]);
'use strict';

(function () {

    'use strict';

    var eurekaModule = angular.module('eureka');

    eurekaModule.service('AppPropertiesService', ['$http', function ($http) {
        return {
            getAppProperties: function getAppProperties() {
                return $http.get('proxy-resource/appproperties/');
            }
        };
    }]);

    var appProperties = {
        dataEndpoint: 'proxy-resource',
        dataProtectedEndPoint: 'protected',
        filterEndpoint: 'protected/jstree3_searchsystemlist'
    };

    /**
     * @ngdoc object
     * @name eureka.appProperties
     * @description
     * Simple configuration object that stores application properties.
     */

    angular.module('eureka').value('appProperties', appProperties);
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc directive
     * @name eureka.directive:compareTo
     * @element *
     * @function
     * @description
     * compareTo directive
     */
    angular.module('eureka').directive('compareTo', compareTo);

    function compareTo() {
        return {
            require: 'ngModel',
            scope: {
                otherModelValue: '=compareTo'
            },
            link: function link(scope, element, attributes, ngModel) {

                ngModel.$validators.compareTo = function (modelValue) {
                    return modelValue === scope.otherModelValue;
                };

                scope.$watch('otherModelValue', function () {
                    ngModel.$validate();
                });
            }
        };
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc directive
     * @name eureka.directive:jstree
     * @element *
     * @function
     * @description
     * jstree wrapper directive
     * @requires eureka.listDragAndDropService
     */
    angular.module('eureka').directive('jstree', jstree);

    jstree.$inject = ['listDragAndDropService'];

    function jstree(listDragAndDropService) {

        return {
            scope: {
                data: '='
            },
            template: '<div id="filter">Tree did not load.</div>',
            restrict: 'E',
            controller: function controller($scope, $element, $attrs, $rootScope) {},
            link: function link(scope, element, attrs) {
                self.droppedElements = {};
                self.propId = null;
                self.propType = null;
                self.propSubType = null;
                var initData = null;
                var searchUpdateDivElem = attrs.searchUpdateDiv;
                var searchModalElem = attrs.searchModal;
                var searchValidationModalElem = attrs.searchValidationModal;
                var searchNoResultsModalElem = attrs.searchNoResultsModal;
                var treeCssUrl = attrs.treeCssUrl;

                $(element).jstree({
                    core: {
                        data: {
                            url: attrs.treeUrl,
                            dataType: 'json',
                            data: function data(n) {
                                return {
                                    key: n.id === '#' ? 'root' : n.id
                                };
                            }

                        }

                    },

                    plugins: ['themes', 'json_data', 'ui', 'crrm', 'dnd', 'search']
                });

                $(element).before($('<form id="search">' + '<span></span>' + '<div class="input-group"><input id="searchText" class="form-control" type="text" />' + '<div class="input-group-btn">' + '<input id="searchTree" class="btn btn-default" type=submit value="search" />' + '<input class="btn btn-default" type="reset" value="X" /></div></div>' + '</form>').bind({
                    reset: function reset(evt) {
                        $(element).jstree('clear_search');
                        $(element).jstree(true).settings.core.data = initData;
                        $(element).jstree(true).refresh();
                        $('#search span').html('');
                    },

                    submit: function submit(evt) {
                        $(element).jstree('clear_search');
                        var searchvalue = $('#search input[type="text"]').val();
                        initData = $(element).jstree(true).settings.core.data;
                        if (searchvalue !== '' && searchvalue.length >= 4) {
                            $(element).hide();
                            var $elem = $(searchUpdateDivElem);
                            $elem.text('Search is in progress. Please wait...');
                            $elem.show();

                            $(element).jstree('destroy');
                            $(element).jstree({
                                'core': {
                                    'data': {
                                        'url': function url(node) {
                                            return node.id === '#' ? attrs.treeSearch + '?str=' + searchvalue : attrs.treeUrl;
                                        },
                                        'dataType': 'json',
                                        'data': function data(node) {
                                            return {
                                                key: node.id === '#' ? 'root' : node.id

                                            };
                                        }
                                    }
                                },
                                'themes': {
                                    'name': 'default',
                                    'theme': 'default',
                                    'url': treeCssUrl
                                },
                                'plugins': ['themes', 'json_data', 'ui', 'crrm', 'dnd', 'search']
                            }).bind('loaded.jstree', function (e, data) {

                                if (data.instance._cnt === 0) {
                                    console.log('empty');
                                    var $elemNoResults = $(searchNoResultsModalElem);
                                    $elemNoResults.find('#searchContent').html('There are no entries in our\n                                            database that matched your search criteria.');
                                    $elemNoResults.modal('toggle');

                                    $elemNoResults.hide();
                                    $(element).jstree('clear_search');
                                    $(element).jstree(true).settings.core.data = initData;
                                    $(element).jstree(true).refresh();
                                    $('#searchText').val('');

                                    $(element).show();

                                    $elemNoResults = $(searchUpdateDivElem);
                                    $elemNoResults.hide();
                                } else if (data.instance._cnt > 200) {
                                    var $elemSearchModal = $(searchModalElem);
                                    $elemSearchModal.find('#searchContent').html('The number of search results\n                                                exceeded the maximum limit and all results might not be displayed.\n                                                Please give a more specific search query to see all results.');
                                    $elemSearchModal.modal('toggle');

                                    $elemSearchModal.hide();
                                    $(element).jstree('clear_search');
                                    $(element).jstree(true).settings.core.data = initData;
                                    $(element).jstree(true).refresh();
                                    $('#searchText').val('');

                                    $(element).show();

                                    $elemSearchModal = $(searchUpdateDivElem);
                                    $elemSearchModal.hide();
                                }
                            });

                            $elem.hide();
                            $(element).show();
                        } else if (searchvalue.length < 4) {
                            var $elemValidationModal = $(searchValidationModalElem);
                            $elemValidationModal.find('#searchContent').html('Please enter a search value with\n                                        length greater than 3.');
                            $elemValidationModal.modal('toggle');
                            $(element).show();
                        }
                        return false;
                    }

                }));

                $(document).on('dnd_move.vakata', function (e, data) {
                    var t = $(data.event.target);
                    if (!t.closest('.jstree').length) {
                        if (t.closest('.tree-drop').length) {
                            data.helper.find('.jstree-icon').removeClass('jstree-er').addClass('jstree-ok');
                        } else {
                            data.helper.find('.jstree-icon').removeClass('jstree-ok').addClass('jstree-er');
                        }
                    }
                });

                $(document).on('dnd_stop.vakata', function (e, data) {
                    self.dropFinishCallback(data);
                });

                self.attachClearModalHandlers = function () {
                    var deleteModal = $('#deleteModal');
                    if (deleteModal) {
                        var $deleteButton = $(deleteModal).find('#deleteButton');
                        $(deleteModal).on('hidden.bs.modal', function (e) {
                            $deleteButton.off('click');
                        });
                    }
                    var replaceModal = $('#replaceModal');
                    if (replaceModal) {
                        var $replaceButton = $(replaceModal).find('#replaceButton');
                        $(replaceModal).on('hidden.bs.modal', function (e) {
                            $replaceButton.off('click');
                        });
                    }
                };

                self.dropFinishCallback = function (data) {
                    var target = data.event.target;
                    // SBA
                    target = $(target).closest('#patCohortDefinition');
                    var textContent = data.data.origin.get_node(data.data.obj[0].id).original.text;

                    if (listDragAndDropService.idIsNotInList(target, data.data.obj[0].id)) {
                        var sortable = $(target).find('ul.sortable');
                        var elementKey = data.data.obj[0].id;
                        var newItem = $('<li></li>').attr('data-space', data.data.origin.get_node(elementKey).original.attr['data-space']).attr('data-desc', textContent).attr('data-type', data.data.origin.get_node(elementKey).original.attr['data-type']).attr('data-subtype', data.data.origin.get_node(elementKey).original.attr['data-subtype'] || '').attr('data-key', data.data.origin.get_node(elementKey).original.attr['data-proposition'] || data.data.origin.get_node(elementKey).original.attr['data-key']);

                        // check that all types in the categorization are the same
                        // SBA look here
                        if ($(sortable).data('drop-type') === 'multiple' && $(sortable).data('proptype') !== 'empty') {
                            if ($(sortable).data('proptype') !== $(newItem).data('type')) {
                                return;
                            }
                        } else {
                            var tmptype = $(newItem).data('type');
                            $(sortable).data('proptype', tmptype);
                        }

                        //this loop is executed only during replacement of a system element when droptype==single.
                        // In all other cases(adding element to multiple droptype lists, adding a new element to an
                        // empty list) the else statement is executed.
                        if ($(sortable).data('drop-type') === 'single' && $(sortable).find('li').length > 0) {
                            var $toRemove = $(sortable).find('li');
                            var dialog = $('#replaceModal');
                            $(dialog).find('#replaceContent').html('Are you sure you want to replace data element &quot;' + $toRemove.text().trim() + '&quot;?');
                            $(dialog).find('#replaceButton').on('click', function (e) {
                                listDragAndDropService.deleteItem($toRemove, $(sortable), 0);
                                listDragAndDropService.addNewItemToList(data, $(sortable), newItem);
                                $(dialog).modal('hide');
                            });
                            $(dialog).modal('show');
                        } else {
                            listDragAndDropService.addNewItemToList(data, sortable, newItem);
                        }
                    }
                };
            }
        };
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.dragAndDropService
     * @description
     * This is the list drag and drop service.
     */

    angular.module('eureka').factory('dragAndDropService', dragAndDropService);

    dragAndDropService.$inject = [];

    function dragAndDropService() {
        var currentNodes = [];
        return {
            setNodes: setNodes,
            getNodes: getNodes,
            clearNodes: clearNodes

        };

        function getNodes() {
            return currentNodes;
        }

        function setNodes(obj, arg2) {
            if (arg2 == undefined || arg2 === null) {
                if (obj !== undefined) {
                    var currentList = [];
                    currentList = currentNodes;
                    var isDuplicate = false;
                    //lets do it the long way first then we will refactor.  Lets see if there are duplicates JS
                    if (currentList.length < 1) {
                        currentNodes.push(obj);
                    } else {
                        for (var i = 0; i < currentList.length; i++) {
                            if (currentList[i].hasOwnProperty('name')) {
                                if (currentList[i].name === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            } else if (currentList[i].hasOwnProperty('key')) {
                                if (currentList[i].key === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            }
                        }
                        if (isDuplicate !== true) {
                            currentNodes.push(obj);
                        }
                    }
                }
            } else {
                currentNodes = obj;
            }
        }

        function clearNodes() {
            currentNodes = [];
        }
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.listDragAndDropService
     * @description
     * This is the list drag and drop service.
     */

    angular.module('eureka').factory('listDragAndDropService', listDragAndDropService);

    listDragAndDropService.$inject = [];

    function listDragAndDropService() {

        return {
            getIn: getIn,
            setIn: setIn,
            removeIn: removeIn,
            objSize: objSize,
            addDroppedElement: addDroppedElement,
            deleteElement: deleteElement,
            deleteItem: deleteItem,
            removeDroppedElement: removeDroppedElement,
            addNewItemToList: addNewItemToList,
            idIsNotInList: idIsNotInList,
            setPropositionSelects: setPropositionSelects,
            attachDeleteAction: attachDeleteAction

        };

        function getIn(obj, path) {
            var current = obj;
            for (var i = 0; i < path.length; i++) {
                current = current[path[i]];
                if (!current) {
                    break;
                }
            }
            return current;
        }

        function setIn(obj, path, value) {
            var current = obj;
            for (var i = 0; i < path.length - 1; i++) {
                var tmp = current[path[i]];
                if (!tmp) {
                    tmp = {};
                    current[path[i]] = tmp;
                }
                current = tmp;
            }
            current[path[path.length - 1]] = value;
        }

        function removeIn(obj, path) {
            var current = obj;
            for (var i = 0; i < path.length - 1; i++) {
                current = current[path[i]];
                if (current === null) {
                    break;
                }
            }
            delete current[path[path.length - 1]];
        }

        function objSize(obj) {
            var size = 0;
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    size++;
                }
            }
            return size;
        }

        function addDroppedElement(dropped, dropTarget) {
            var elementKey = $(dropped).data('key');
            var sourceId = $(dropTarget).data('count');
            var sourcePath = [self.propType, elementKey, 'sources', sourceId];
            var defPath = [self.propType, elementKey, 'definition'];
            var definition = getIn(self.droppedElements, defPath);

            setIn(self.droppedElements, sourcePath, dropTarget);
            if (!definition) {
                var properties = ['key', 'desc', 'type', 'subtype', 'space'];
                definition = {};
                $.each(properties, function (i, property) {
                    definition[property] = $(dropped).data(property);
                });
                setIn(self.droppedElements, defPath, definition);
            }

            var allSourcesPath = [self.propType, elementKey, 'sources'];
            var allSources = getIn(self.droppedElements, allSourcesPath);
            var size = objSize(allSources);
            if (size > 1) {
                for (var key in allSources) {
                    if (allSources.hasOwnProperty(key)) {
                        var source = allSources[key];
                        var items = $(source).find('li');
                        $(items).each(function (i, item) {
                            var span = $(item).find('span.desc');
                            var newText = $(dropped).data('desc') + ' [' + $(source).data('count') + ']';
                            $(span).text(newText);
                        });
                    }
                }
            }
        }

        function deleteElement(displayName, key) {
            var $dialog = $('<div></div>').html('Are you sure you want to delete cohort &quot;' + displayName.trim() + '&quot;? You cannot undo this action.').dialog({
                title: 'Delete Data Element',
                modal: true,
                resizable: false,
                buttons: {
                    'Delete': function Delete() {
                        $.ajax({
                            type: 'POST',
                            url: 'deletecohort?key=' + encodeURIComponent(key),
                            success: function success(data) {
                                $(this).dialog('close');
                                window.location.href = 'editorhome';
                            },
                            error: function error(data, statusCode) {
                                var $errorDialog = $('<div></div>').html(data.responseText).dialog({
                                    title: 'Error Deleting Data Element',
                                    buttons: {
                                        'OK': function OK() {
                                            $(this).dialog('close');
                                        }
                                    },
                                    close: function close() {
                                        $dialog.dialog('close');
                                    }
                                });
                                $errorDialog.dialog('open');
                            }
                        });
                    },
                    'Cancel': function Cancel() {
                        $(this).dialog('close');
                    }
                },
                close: function close() {
                    // do nothing here.
                }
            });
            $dialog.dialog('open');
        }

        function removeDroppedElement(removed, removeTarget) {
            var elementKey = $(removed).data('key');
            var sourceId = $(removeTarget).data('count');
            var path = [self.propType, elementKey, 'sources', sourceId];
            removeIn(self.droppedElements, path);

            var allSourcesPath = [self.propType, elementKey, 'sources'];
            var allSources = getIn(self.droppedElements, allSourcesPath);
            var size = objSize(allSources);
            if (size <= 1) {
                for (var key in allSources) {
                    if (allSources.hasOwnProperty(key)) {
                        var source = allSources[key];
                        var items = $(source).find('li');
                        $(items).each(function (i, item) {
                            var span = $(item).find('span.desc');
                            var newText = $(removed).data('desc');
                            $(span).text(newText);
                        });
                    }
                }
            }
        }

        function deleteItem(toRemove, sortable, replace) {
            var infoLabel = sortable.siblings('div.label-info');
            var target = sortable.parent();
            removeDroppedElement(toRemove, sortable);
            setPropositionSelects(sortable.closest('[data-definition-container="true"]'));
            toRemove.remove();
            if (sortable.find('li').length === 0 && replace === 0) {
                sortable.data('proptype', 'empty');
                infoLabel.show();
            }

            // remove the properties from the drop down
            $('select[data-properties-provider=' + $(target).attr('id') + ']').each(function (i, item) {
                $(item).empty();
            });
            //remove the disabled attribute to the property textbox if any.
            var parentTable = $(target).parent().parent().parent();
            var inputProperty = $(parentTable).find('input.propertyValueField');
            $(inputProperty).removeAttr('disabled');
            var inputPropertycheckbox = $(parentTable).find('input.propertyValueConstraint');
            $(inputPropertycheckbox).removeAttr('disabled');

            // perform any additional delete actions
            if (self.deleteActions && self.deleteActions[self.propType]) {
                self.deleteActions[self.propType]();
            }
        }

        function idIsNotInList(target, id) {
            var retVal = true;
            $(target).find('ul.sortable').find('li').each(function (i, item) {
                if ($(item).data('key') === id) {
                    retVal = false;
                }
            });
            return retVal;
        }

        function addNewItemToList(data, sortable, newItem) {
            var target = $(sortable).parent();

            $(target).find('div.label-info').hide();

            var X = $('<span></span>', {
                'class': 'glyphicon glyphicon-remove delete-icon',
                'data-action': 'remove'
            });

            attachDeleteAction(X);
            var textContent = data.data.origin.get_node(data.data.obj[0].id).original.text;

            newItem.append(X);
            newItem.append(textContent);

            sortable.append(newItem);

            // set the properties in the properties select
            if ($(data.data.obj[0]).data('properties')) {
                var properties = $(data.data.obj[0]).data('properties').split(',');
                $('select[data-properties-provider=' + $(target).attr('id') + ']').each(function (i, item) {
                    $(item).empty();
                    $(properties).each(function (j, property) {
                        $(item).append($('<option></option>').attr('value', property).text(property));
                    });
                });
            } else {
                var parent = $(target).closest('.form-group').parent();
                var inputProperty = $(parent).find('input.propertyValueField');
                $(inputProperty).attr('disabled', 'disabled');
                var inputPropertycheckbox = $(parent).find('input.propertyValueConstraint');
                $(inputPropertycheckbox).attr('disabled', 'disabled');
            }

            // add the newly dropped element to the set of dropped elements
            addDroppedElement(newItem, sortable);
            setPropositionSelects($(sortable).closest('[data-definition-container="true"]'));

            // finally, call any actions specific to the type of proposition being entered/edited
            if (self.dndActions && self.dndActions[self.propType]) {
                self.dndActions[self.propType](data.data.obj[0]);
            }
        }

        function setPropositionSelects(elem) {
            var droppedElems = self.droppedElements[self.propType];

            // this prevents an error in the inner loop which tries to
            // loop over this null object.
            if (droppedElems === null) {
                return;
            }

            var selects = $(elem).find('select[name="propositionSelect"]');
            $(selects).each(function (i, sel) {
                var $sortable = $(sel).closest('.drop-parent').find('ul.sortable');
                var originalSource = $(sel).data('sourceid');
                $(sel).attr('data-sourceid', '');
                $(sel).empty();
                $.each(droppedElems, function (elemKey, elemValue) {
                    var sources = droppedElems[elemKey]['sources'];
                    $.each(sources, function (sourceKey, sourceValue) {
                        var $items = $(sourceValue).find('li');
                        var selectedItem;
                        $items.each(function (i, item) {
                            if ($(item).data('key') === elemKey) {
                                selectedItem = item;
                            }
                            if (selectedItem && $sortable.data('count') !== $(sourceValue).data('count')) {
                                var sourceId = $(sourceValue).data('count');
                                var value = $(selectedItem).data('key') + '__' + sourceId;
                                var desc = $(selectedItem).data('desc');
                                if (self.objSize(sources) > 1) {
                                    desc += ' [' + sourceKey + ']';
                                }
                                var opt = $('<option></option>', {
                                    'value': value
                                }).text(desc);
                                if (value === $(selectedItem).data('key') + '__' + originalSource) {
                                    opt.attr('selected', 'selected');
                                }
                                $(sel).append(opt);
                            }
                        });
                    });
                });
            });
        }

        function attachDeleteAction(elem) {
            $(elem).each(function (i, item) {
                $(item).click(function () {
                    var $toRemove = $(item).closest('li');
                    var $sortable = $toRemove.closest('ul.sortable');
                    var dialog = $('#deleteModal');
                    $(dialog).find('#deleteContent').html('Are you sure you want to remove data element &quot;' + $toRemove.text().trim() + '&quot;?');
                    $(dialog).find('#deleteButton').on('click', function (e) {
                        deleteItem($toRemove, $sortable, 0);
                        $(dialog).modal('hide');
                    });
                    $(dialog).modal('show');
                });
            });
        }

        self.dndActions = {};
        self.deleteActions = {};
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.modals
     * @description
     * modal service.
     */

    angular.module('eureka').factory('modals', modals);

    modals.$inject = ['$modal'];

    function modals($modal) {

        return {
            getIn: getIn

        };

        function getIn(obj, path) {

            return current;
        }
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.TreeService
     * @description
     * This will provide all services for tree component
     */

    angular.module('eureka').factory('TreeService', TreeService);

    TreeService.$inject = ['$http', '$q', 'appProperties'];

    function TreeService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;
        var dataProtectedEndPoint = appProperties.dataProtectedEndPoint;

        return {
            removePhenotype: removePhenotype,
            getPhenotype: getPhenotype,
            getTreeRoot: getTreeRoot,
            getTreeNode: getTreeNode,
            getUserListRoot: getUserListRoot
        };

        function getTreeRoot() {
            return $http.get(dataEndpoint + '/concepts').then(handleSuccess, handleError);
            // https://localhost:8443/eureka-webapp/protected/systemlist?key=root
            //https://localhost:8443/eureka-webapp/proxy-resource/systemlist?key=root
        }

        function getTreeNode(key) {
            if (key === 'root') {
                return $http.get(dataEndpoint + '/concepts/').then(handleSuccess, handleError);
            } else {
                return $http.get(dataEndpoint + '/concepts/' + key).then(handleSuccess, handleError);
                // https://localhost:8443/eureka-webapp/protected/systemlist?key=root
                //https://localhost:8443/eureka-webapp/proxy-resource/systemlist?key=root
            }
        }

        function getUserListRoot() {
            return $http.get(dataProtectedEndPoint + '/userproplist?key=root');
            //https://localhost:8443/eureka-webapp/protected/systemlist?key=root
        }

        function removePhenotype(id) {

            return $http['delete'](dataEndpoint + '/phenotypes/' + id).then(handleSuccess, handleError);
        }

        function getPhenotype(key) {
            return $http.get(dataEndpoint + '/phenotypes/' + key + '?summarize=true').then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

(function () {

    'use strict';

    /**
     * @ngdoc service
     * @name eureka.users
     * @description
     * This is the users service.
     * @requires $http
     * @requires $q
     * @requires eureka.appProperties
     */

    angular.module('eureka').factory('users', users);

    users.$inject = ['$http', '$q', 'appProperties'];

    var User = (function () {
        function User(info) {
            _classCallCheck(this, User);

            this.info = info;
        }

        _createClass(User, [{
            key: 'hasRole',
            value: function hasRole(name) {
                var roles = this.info.roles;

                return roles.some(function (role) {
                    return role.name === name;
                });
            }
        }, {
            key: 'getDisplayName',
            value: function getDisplayName() {
                var _info = this.info;
                var fullName = _info.fullName;
                var firstName = _info.firstName;
                var lastName = _info.lastName;
                var username = _info.username;

                if (fullName) {
                    return fullName;
                } else if (firstName || lastName) {
                    return [firstName, lastName].filter(function (val) {
                        return val && val.length > 0 ? val : undefined;
                    }).join(' ');
                } else {
                    return username;
                }
            }
        }]);

        return User;
    })();

    function users($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;

        return {
            getUser: getCurrentUser,
            getRole: getRole
        };

        function getRole(roleId) {
            return $http.get(dataEndpoint + '/roles/' + roleId).then(function (res) {
                return res.data;
            }, function (err) {
                console.error('role retrieval failed:', err);
                return err;
            });
        }

        function getCurrentUser() {
            return $http.get(dataEndpoint + '/users/me', {
                transformResponse: function transformResponse(data) {
                    try {
                        var jsonObject = JSON.parse(data); // verify that json is valid
                        return jsonObject;
                    } catch (e) {
                        console.log('User is not logged in!');
                    }
                }
            }).then(function (res) {
                var userInfo = res.data;
                if (!userInfo) {
                    return $q.when(null);
                }
                return $q.all(_.map(userInfo.roles, getRole)).then(function (roles) {
                    userInfo.roles = roles;
                    return new User(userInfo);
                });
            }, function (err) {
                console.error('error getting user:', err);
            });
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

var eurekaModule = angular.module('eureka');

eurekaModule.controller('NewsAndFundingController', ['$scope', '$sce', 'NewsAndFundingService', function ($scope, $sce, NewsAndFundingService) {
        var service = { versionHistory: [], supportedBy: [] };
        NewsAndFundingService.getVersionHistoryAsync().then(function (response) {
                $scope.versionHistory = response.data.versionHistory;
        });

        NewsAndFundingService.getSupportedByAsync().then(function (response) {
                var data = response.data;
                var result = data.supportedBy.slice(0, -1).join('; ');
                if (data.supportedBy.length > 1) {
                        result += '; and ';
                }
                result += data.supportedBy[data.supportedBy.length - 1];
                $scope.supportedByHTML = $sce.trustAsHtml(result);
        });
}]);
'use strict';

var eurekaModule = angular.module('eureka');

eurekaModule.service('NewsAndFundingService', ['$http', function ($http) {
    return {
        getVersionHistoryAsync: function getVersionHistoryAsync() {
            return $http.get('assets/data/version_history.json');
        },
        getSupportedByAsync: function getSupportedByAsync() {
            return $http.get('assets/data/supported_by.json');
        }
    };
}]);
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.cohorts.CohortFilterService
     * @description
     * This service provides an API to interact with the REST endpoint for cohorts.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.cohorts').factory('CohortFilterService', CohortFilterService);

    CohortFilterService.$inject = ['$http', '$q', 'appProperties'];

    function CohortFilterService($http, $q, appProperties) {

        return {
            filterCohorts: filterCohorts
        };

        function filterCohorts(filterString) {
            /* filter url looks like this: 
            https://localhost:8443/eureka-webapp/protected/jstree3_searchsystemlist?str=Patient&key=root 
            */
            return $http.get('' + appProperties.filterEndpoint, {
                cache: true,
                params: {
                    key: 'root',
                    str: filterString

                }
            }).then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }
        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.cohorts.CohortService
     * @description
     * This service provides an API to interact with the REST endpoint for cohorts.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.cohorts').factory('CohortService', CohortService);

    CohortService.$inject = ['$http', '$q', 'appProperties'];

    function CohortService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;

        return {
            getCohorts: getCohorts,
            getCohort: getCohort,
            getSystemElement: getSystemElement,
            getPhenotypes: getPhenotypes,
            removeCohort: removeCohort,
            createCohort: createCohort,
            updateCohort: updateCohort
        };

        function getCohorts() {

            var type = 'COHORT';
            return $http.get(dataEndpoint + '/destinations?type=' + type).then(handleSuccess, handleError);
        }

        function removeCohort(key) {

            return $http['delete'](dataEndpoint + '/destinations/' + key).then(handleSuccess, handleError);
        }

        function getSystemElement(key) {

            return $http.get(dataEndpoint + '/concepts/' + key + '?summary=true').then(handleSuccess, handleError);
        }

        function getCohort(cohortId) {
            return $http.get(dataEndpoint + '/destinations/' + cohortId).then(handleSuccess, handleError);
        }

        function getPhenotypes(cohort) {

            var cohorts = [];

            function traverse(node) {

                if (node.left_node !== undefined) {
                    traverse(node.left_node);
                }

                if (node.name !== undefined) {
                    cohorts.push(node.name);
                }

                if (node.right_node !== undefined) {
                    traverse(node.right_node);
                }
            }

            traverse(cohort.node);

            var promises = [];
            angular.forEach(cohorts, function (cohort) {
                var promise = $http.get(dataEndpoint + '/concepts/' + cohort + '?summary=true');
                promises.push(promise);
            });

            return $q.all(promises);
        }

        function createCohort(cohort) {
            /*This is what the data looks like being sent to server.  Does not look valid
            {"id":null,"type":"COHORT","ownerUserId":1,"name":"NameTest","description":"NameDescription",
            "phenotypeFields":null, "cohort":{"id":null,"node":{"id":null,"start":null,"finish":null,
            "type":"Literal","name":"\\ACT\\Medications\\"}},"read":false,"write":false,"execute":false,
            "created_at":null,"updated_at":null,"links":null}
            */
            var newCohort = {
                id: null,
                type: 'COHORT',
                ownerUserId: 1,
                phenotypeFields: null,
                cohort: {
                    id: null
                },
                read: false,
                write: false,
                execute: false,
                created_at: null,
                updated_at: null,
                links: null
            };
            var phenotypes = cohort.memberList;
            var node = { id: null, start: null, finish: null, type: 'Literal' };
            if (phenotypes.length === 1) {
                node.name = phenotypes[0].key;
            } else if (phenotypes.length > 1) {
                var first = true;
                var prev = null;
                for (var i = phenotypes.length - 1; i >= 0; i--) {
                    var literal = { id: null, start: null, finish: null, type: 'Literal' };
                    literal.name = phenotypes[i].key;
                    if (first) {
                        first = false;
                        prev = literal;
                    } else {
                        var binaryOperator = { id: null, type: 'BinaryOperator', op: 'OR' };
                        binaryOperator.left_node = literal;
                        binaryOperator.right_node = prev;
                        prev = binaryOperator;
                    }
                }
                node = prev;
            } else {
                node = null;
            }
            newCohort.name = cohort.name;
            newCohort.description = cohort.description;
            newCohort.cohort.id = null;
            newCohort.cohort.node = node;
            console.log(newCohort);
            var testCohort = { "id": null, "type": "COHORT", "ownerUserId": 1, "name": "jay23333", "description": "description 234", "phenotypeFields": null, "cohort": { "id": null, "node": { "id": null, "start": null, "finish": null, "type": "Literal", "name": "Encounter" } }, "read": false, "write": false, "execute": false, "created_at": null, "updated_at": null, "links": null };
            return $http.post(dataEndpoint + '/destinations/', newCohort).then(handleSuccess, handleError);
        }

        function updateCohort(cohort) {
            // will need to clean up after getting it to work; JS
            var newCohort = {
                id: null,
                type: 'COHORT',
                ownerUserId: 1,
                phenotypeFields: null,
                cohort: {
                    id: null
                },
                read: false,
                write: false,
                execute: false,
                created_at: null,
                updated_at: null,
                links: null
            };

            var existingList = [];

            var phenotypes = cohort.memberList;

            var node = { id: null, start: null, finish: null, type: 'Literal' };
            if (phenotypes.length === 1) {
                node.name = phenotypes[0].displayName;
            } else if (phenotypes.length > 1) {
                var first = true;
                var prev = null;
                for (var i = phenotypes.length - 1; i >= 0; i--) {
                    var literal = { id: null, start: null, finish: null, type: 'Literal' };
                    // if a key is there use the key else use the name, because the name is already the key
                    if (phenotypes[i].key === undefined) {
                        literal.name = phenotypes[i].name;
                    } else {
                        literal.name = phenotypes[i].key;
                    }

                    if (first) {
                        first = false;
                        prev = literal;
                    } else {
                        var binaryOperator = { id: null, type: 'BinaryOperator', op: 'OR' };
                        binaryOperator.left_node = literal;
                        binaryOperator.right_node = prev;
                        prev = binaryOperator;
                    }
                }
                node = prev;
            } else {
                node = null;
            }

            newCohort.name = cohort.name;
            newCohort.description = cohort.description;
            newCohort.id = cohort.id;
            newCohort.cohort.node = node;

            return $http.put(dataEndpoint + '/destinations/', newCohort).then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

(function () {
  'use strict';

  angular.module('eureka.cohorts').factory('CohortTreeService', CohortTreeService);

  CohortTreeService.$inject = ['$http', '$q', 'appProperties'];

  function CohortTreeService($http, $q, appProperties) {
    var dataEndpoint = appProperties.dataEndpoint;

    return {
      getTreeData: getTreeData
    };

    function getTreeData(id) {
      return $http.get(dataEndpoint + '/concepts/', {
        cache: true,
        params: {
          key: id
        }
      }).then(handleSuccess, handleError);
    }

    function handleSuccess(response) {
      return response.data;
    }

    function handleError(response) {
      if (!angular.isObject(response.data) && !response.data) {
        return $q.reject('An unknown error occurred.');
      }
      return $q.reject(response.data);
    }
  }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('CohortMembersDropZoneCtrl', CohortMembersDropZoneCtrl);

    CohortMembersDropZoneCtrl.$inject = [];

    function CohortMembersDropZoneCtrl() {
        var vm = this;

        vm.treeOptions = {
            accept: addMember
        };

        function nodeAllowed(node, memberList) {
            memberList = memberList || vm.memberList;
            if (memberList.indexOf(node) !== -1) {
                return false;
            }
            var differentType = vm.memberList.some(function (memberNode) {
                return node.type !== memberNode.type;
            });
            return !differentType;
        }

        function addMember(nodeScope, memberListScope) {
            var node = nodeScope.$modelValue;
            var memberList = memberListScope.$modelValue;
            return nodeAllowed(node, memberList);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('cohortMembersDropZone', CohortMembersDropZone);

    function CohortMembersDropZone() {
        return {
            restrict: 'E',
            bindToController: {
                memberList: '='
            },
            scope: {},
            replace: false,
            templateUrl: 'eureka/directives/cohort-members-drop-zone/cohort-members-drop-zone.html',
            controller: 'CohortMembersDropZoneCtrl',
            controllerAs: 'dropZone'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('CohortMembersTreeCtrl', CohortMembersTreeCtrl);

    CohortMembersTreeCtrl.$inject = ['CohortTreeService', 'CohortFilterService'];

    function CohortMembersTreeCtrl(CohortTreeService, CohortFilterService) {
        var vm = this;
        var getTreeData = CohortTreeService.getTreeData;
        var filterCohorts = CohortFilterService.filterCohorts;
        vm.toggleNode = toggleNode;
        vm.nodeAllowed = nodeAllowed;
        vm.filterCohortList = filterCohortList;
        vm.memberList = vm.memberList || [];

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        initTree();

        function initTree() {
            vm.loading = true;
            getTreeData('root').then(function (data) {
                console.log(data);
                vm.treeData = data;
                delete vm.loading;
            }, displayError);
        }

        function toggleNode(node) {
            if (!node.nodes) {
                node.loading = true;
                getTreeData(node.attr.id).then(function (data) {
                    console.log(data);
                    node.nodes = data;
                    delete node.loading;
                }, displayError);
            }
        }

        function nodeAllowed(node, memberList) {
            memberList = memberList || vm.memberList;
            if (memberList.indexOf(node) !== -1) {
                return false;
            }
            var differentType = vm.memberList.some(function (memberNode) {
                return node.type !== memberNode.type;
            });
            return !differentType;
        }

        function filterCohortList() {
            vm.loading = true;
            vm.treeData = [];
            filterCohorts(vm.treeSearch).then(function (data) {
                vm.treeData = data;
                delete vm.loading;
            }, displayError);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('cohortMembersTree', CohortMembersTree);

    function CohortMembersTree() {
        return {
            restrict: 'E',
            bindToController: {
                memberList: '='
            },
            scope: {},
            replace: false,
            templateUrl: 'eureka/directives/cohort-members-tree/cohort-members-tree.html',
            controller: 'CohortMembersTreeCtrl',
            controllerAs: 'tree'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('GlobalGridCtrl', GlobalGridCtrl);

    GlobalGridCtrl.$inject = ['CohortTreeService', 'CohortFilterService'];

    function GlobalGridCtrl(CohortTreeService, CohortFilterService) {
        var vm = this;
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('globalGrid', GlobalGrid);

    function GlobalGrid() {
        return {
            restrict: 'E',
            //scope: true,
            templateUrl: 'eureka/directives/global-grid/global-grid.html',
            scope: {
                options: '@'
            },
            link: function link(scope, element, attrs) {

                scope.gridOptions = {
                    enableSorting: true,
                    paginationPageSizes: [10, 20, 30],
                    paginationPageSize: 10,
                    columnDefs: [],
                    data: []
                };
                scope.gridOptions.columnDefs = JSON.parse(attrs.gridOptions);
                scope.gridOptions.data = JSON.parse(attrs.gridData);
            }
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('tableDirectiveOne', TableDirectiveOne);

    function TableDirectiveOne() {
        return {
            restrict: 'EA',
            scope: true,
            link: function link(scope, element, attrs) {
                scope.tableData = scope.$eval(attrs.tableData);
                scope.tableParameters = scope.$eval(attrs.tableParameters);
            },
            templateUrl: 'eureka/directives/table-directive-one/table-directive-one.html'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('TreeComponentCtrl', TreeComponentCtrl);

    TreeComponentCtrl.$inject = ['PhenotypeService', 'NgTableParams', 'TreeService', '$scope'];

    function TreeComponentCtrl(PhenotypeService, NgTableParams, TreeService, $scope) {
        var vm = this;

        vm.breadCrumbs = [{ key: 'root', displayName: 'root' }];
        var currentNodes = [];

        TreeService.getTreeRoot().then(function (data) {
            // NG Table
            vm.tableParams = new NgTableParams({}, { dataset: data });
            callUserRoot();
        }, displayError);

        function init() {
            // clearNodes();

        }

        function callUserRoot() {
            TreeService.getUserListRoot().then(function (data) {
                // NG Table
                vm.tableParamsUser = new NgTableParams({}, { dataset: data.data });
            }, displayError);
        }
        vm.selectNode = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            if (hasChildren !== false) {
                TreeService.getTreeNode(currentNode.key).then(function (data) {
                    // NG Table
                    if (hasChildren) {
                        vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName, parent: currentNode.parent });
                    }
                    vm.tableParams = new NgTableParams({}, { dataset: data.children });
                }, displayError);
            } else {
                //do nothing it is a document
            }
        };
        vm.addNode = function (node) {
            console.log(vm.currentMemeberList + '  1');
            console.log(currentNodes + '@@');
            if (node) {

                setNodes(node);
            }
            getMemberList();
        };
        vm.addUserNode = function (node) {
            /* After changes add user node will need to be refactored will take care of later in week.
            if (node) {
                node.displayName = node.text;
                dragAndDropService.setNodes(node);
            }
            getMemberList() */
        };
        vm.removeNode = function (node) {
            for (var i = 0; i < vm.currentMemeberList.length; i++) {
                // we will need to look for both key and name.  name is key in update, but key is present on create.
                if (node.key === undefined) {
                    if (vm.currentMemeberList[i].name === node.name) {
                        vm.currentMemeberList.splice(i, 1);
                        break;
                    }
                } else {
                    if (vm.currentMemeberList[i].key === node.key) {
                        vm.currentMemeberList.splice(i, 1);
                        break;
                    }
                }
            }
        };
        vm.setBreadCrumbs = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            var pos = 0;
            var returnedData = [];

            TreeService.getTreeNode(currentNode.key).then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                if (data.hasOwnProperty('parent') && data['parent']) {
                    returnedData = data.children;
                } else {
                    returnedData = data;
                }
                if (hasChildren) {
                    vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName });
                }

                vm.tableParams = new NgTableParams({}, { dataset: returnedData });

                pos = vm.breadCrumbs.map(function (e) {
                    return e.key;
                }).indexOf(currentNode.key);
                vm.breadCrumbs.length = pos + 1;
            }, displayError);
        };

        function getMemberList() {
            vm.currentMemeberList = getNodes();
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        function setNodes(obj, arg2) {
            currentNodes = vm.currentMemeberList;
            if (arg2 == undefined || arg2 === null) {
                if (obj !== undefined) {
                    var currentList = [];
                    currentList = currentNodes;
                    var isDuplicate = false;
                    //lets do it the long way first then we will refactor.  Lets see if there are duplicates JS
                    if (currentList.length < 1) {
                        currentNodes.push(obj);
                    } else {
                        for (var i = 0; i < currentList.length; i++) {
                            if (currentList[i].hasOwnProperty('name')) {
                                if (currentList[i].name === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            } else if (currentList[i].hasOwnProperty('key')) {
                                if (currentList[i].key === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            }
                        }
                        if (isDuplicate !== true) {
                            currentNodes.push(obj);
                        }
                    }
                }
            } else {
                currentNodes = obj;
            }
        }

        function getNodes() {
            return currentNodes;
        }

        function clearNodes() {
            currentNodes = [];
        }
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('treeComponent', TreeComponent);

    function TreeComponent() {
        return {
            restrict: 'E',
            scope: {
                currentMemeberList: '='
            },
            bindToController: true,

            replace: false,
            templateUrl: 'eureka/directives/tree-component/tree-component.html',
            controller: 'TreeComponentCtrl',
            controllerAs: 'vm'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.jobs.JobService
     * @description
     * This service provides an API to interact with the REST endpoint for jobs.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.jobs').factory('JobService', JobService);

    JobService.$inject = ['$http', '$q', 'appProperties'];

    function JobService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;

        return {
            fileUpload: fileUpload,
            getJobs: getJobs,
            getJob: getJob,
            getLatestJobs: getLatestJobs,
            getDestinations: getDestinations,
            getSourceConfigs: getSourceConfigs
        };

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }

        function fileUpload(sourceId) {

            return $http.post(dataEndpoint + '/file/upload' + sourceId).then(handleSuccess, handleError);
        }

        function getJobs() {

            return $http.get(dataEndpoint + '/jobs').then(handleSuccess, handleError);
        }

        function getJob(id) {

            return $http.get(dataEndpoint + '/job/' + id).then(handleSuccess, handleError);
        }

        //get a list of existing jobs, with latest one as the first one
        function getLatestJobs() {

            return $http.get(dataEndpoint + '/jobs/latest').then(handleSuccess, handleError);
        }

        //get a list of destinations
        function getDestinations() {

            return $http.get(dataEndpoint + '/destinations').then(handleSuccess, handleError);
        }

        //get a list of sourceConfigs
        function getSourceConfigs() {

            return $http.get(dataEndpoint + '/sourceconfig').then(handleSuccess, handleError);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.phenotypes.PhenotypeService
     * @description
     * This service provides an API to interact with the REST endpoint for phenotypes.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.phenotypes').factory('PhenotypeService', PhenotypeService);

    PhenotypeService.$inject = ['$http', '$q', 'appProperties'];

    function PhenotypeService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;
        var dataProtectedEndPoint = appProperties.dataProtectedEndPoint;

        return {
            getSummarizedUserElements: getSummarizedUserElements,
            getPhenotypeMessages: getPhenotypeMessages,
            createPhenotype: createPhenotype,
            getPhenotype: getPhenotype,
            updatePhenotype: updatePhenotype,
            removePhenotype: removePhenotype
        };

        function getSummarizedUserElements() {
            return $http.get(dataEndpoint + '/phenotypes?summarize=true').then(handleSuccess, handleError);
        }

        function getPhenotypeMessages() {
            return {
                'CATEGORIZATION': {
                    'displayName': 'Categorization',
                    'description': 'For defining a significant category of codes or clinical events or observations.'
                },
                'SEQUENCE': {
                    'displayName': 'Sequence',
                    'description': 'For defining a disease, finding or patient care process to be reflected by codes,\n                    clinical events and/or observations in a specified sequential temporal pattern.'
                },
                'FREQUENCY': {
                    'displayName': 'Frequency',
                    'description': 'For defining a disease, finding or patient care process to be reflected by codes,\n                    clinical events and/or observations in a specified frequency.'
                },
                'THRESHOLD': {
                    'displayName': 'Threshold',
                    'description': 'For defining clinically significant thresholds on the value of an observation.'
                }
            };
        }

        function createPhenotype(newObject) {

            return $http.post(dataEndpoint + '/phenotypes', newObject).then(handleSuccess, handleError);
        }

        function updatePhenotype(updateObject) {

            return $http.put(dataEndpoint + '/phenotypes/' + updateObject.id, updateObject).then(handleSuccess, handleError);
        }

        function getPhenotype(id) {
            return $http.get(dataEndpoint + '/phenotypes/' + id).then(handleSuccess, handleError);
        }

        function removePhenotype(id) {
            return $http['delete'](dataEndpoint + '/phenotypes/' + id).then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:MainCtrl
     * @description
     * This is the main controller for the cohorts section of the application.
     * @requires cohorts.CohortService
     */

    angular.module('eureka.cohorts').controller('cohorts.ModalCtrl', ModalCtrl).controller('cohorts.DeleteModalCtrl', DeleteModalCtrl).controller('cohorts.MainCtrl', MainCtrl);

    ModalCtrl.$inject = ['$uibModalInstance'];
    DeleteModalCtrl.$inject = ['$uibModalInstance', 'data'];
    MainCtrl.$inject = ['CohortService', 'NgTableParams', '$uibModal'];

    function ModalCtrl($uibModalInstance, currentUser) {
        var mo = this;
        mo.currentUser = currentUser;
        mo.ok = function () {
            $uibModalInstance.close();
        };

        mo.cancel = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }

    function DeleteModalCtrl($uibModalInstance, data) {
        var mo = this;
        mo.data = data;
        mo.ok = function () {
            $uibModalInstance.close();
        };

        mo.cancel = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }

    function MainCtrl(CohortService, NgTableParams, $uibModal) {
        var vm = this;
        var copyData = [];

        vm.remove = remove;
        vm.currentSelectedItem = {};

        function remove(key) {
            CohortService.removeCohort(key);
            vm.tableParams.filter({});
            for (var i = 0; i < vm.copyData.length; i++) {
                if (vm.copyData[i].name === key) {
                    vm.copyData.splice(i, 1);
                    break;
                }
            }
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        vm.selected = [];

        vm.filter = {
            options: {
                debounce: 500
            }
        };

        vm.query = {
            filter: '',
            order: 'name',
            limit: 5,
            page: 1
        };

        function success(cohorts) {
            vm.cohortsList = cohorts;
            vm.gridOptions.data = cohorts;
            vm.copyData = cohorts;
            // NG Table
            vm.tableParams = new NgTableParams({}, { dataset: vm.copyData });
        }

        vm.removeFilter = function () {
            vm.filter.show = false;
            vm.query.filter = '';

            if (vm.filter.form.$dirty) {
                vm.filter.form.$setPristine();
            }
        };

        vm.deleteCohort = function (user, indexOfRow) {
            var currentItem = user;
            var currentRow = indexOfRow;

            $uibModal.open({
                templateUrl: 'myModal.html',
                controller: 'cohorts.ModalCtrl',
                controllerAs: 'mo',
                resolve: {
                    currentUser: function currentUser() {
                        return user;
                    }
                }
            }).result.then(function () {
                removeCohort(currentItem);
            }, function (arg) {
                console.log(arg);
            });
        };

        function deleteSuccess() {
            vm.tableParams.filter({});
            for (var i = 0; i < vm.copyData.length; i++) {
                if (vm.copyData[i].name === vm.currentSelectedItem) {
                    vm.copyData.splice(i, 1);
                    break;
                }
            }
            vm.tableParams.reload();
        }

        function deleteError(_data) {
            $uibModal.open({
                templateUrl: 'errorModal.html',
                controller: 'phenotypes.DeleteModalCtrl',
                controllerAs: 'mod',
                resolve: {
                    data: function data() {
                        return _data;
                    }
                }
            }).result.then(function () {
                // nothing to do here
            }, function (arg) {
                // nothing to do here
            });
        }

        function removeCohort(data) {
            vm.currentSelectedItem = data;
            vm.deferred = CohortService.removeCohort(data).then(deleteSuccess, deleteError);
        }

        vm.onOrderChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        vm.onPaginationChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        // UI-Grid
        vm.gridOptions = {
            enableSorting: true,
            paginationPageSizes: [10, 20, 30],
            paginationPageSize: 10,
            columnDefs: [{
                name: ' ', field: 'edit',
                cellTemplate: '<a href="${editUrl}" title="Edit">' + '<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span></a> ' + '<span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>'
            }, { name: 'Name', field: 'name' }, { name: 'Descripton', field: 'description' }, { name: 'Type', field: 'type' }, { name: 'Created', field: 'created_at', enableCellEdit: false, cellFilter: 'date:"longDate"' }],
            data: []
        };

        CohortService.getCohorts().then(success, displayError);
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:EditCtrl
     * @description
     * This is the edit controller for the cohorts section of the application.
     * @requires cohorts.CohortService
     * @requires $stateParams
     */

    angular.module('eureka.cohorts').controller('cohorts.EditCtrl', EditCtrl);

    EditCtrl.$inject = ['CohortService', '$stateParams', '$state', 'dragAndDropService'];

    function EditCtrl(CohortService, $stateParams, $state, dragAndDropService) {
        var vm = this;
        var updateCohortCall = CohortService.updateCohort;
        vm.memberList = [];
        vm.description;
        vm.name;
        vm.currentCohort = {};

        if ($stateParams.key) {
            vm.memberList = [];
            CohortService.getCohort($stateParams.key).then(function (data) {
                var test = [];
                vm.destination = data;
                vm.currentCohort.name = data.name;
                vm.currentCohort.description = data.description;
                vm.currentCohort.id = data.id;
                console.log(data.cohort.node);

                // lets call the traverse function to go through the returned nodes structure
                traverseNodes(data.cohort.node);
            }, displayError);
        }

        vm.updateCohort = function () {
            vm.currentCohort.name = vm.destination.name;
            vm.currentCohort.description = vm.destination.description;

            updateCohortCall(vm.currentCohort).then(function (data) {
                console.log('we made it back', data);
                $state.transitionTo('cohorts');
            }, displayError);
        };

        // This function takes the saved nodes and goes through the tree and plucks all with a valid id. Then adds to membelist which populates the dropzone
        function traverseNodes(data) {

            var reducer = function reducer(results, node) {
                //         console.log(results);
                //console.log(node, !_.isEmpty(node.id), node.id, _.isEmpty(node.id));
                node.id && results.push(node);
                _.without([node.left_node, node.right_node], undefined).reduce(reducer, results);
                return results;
            };

            var fullResults = [data].reduce(reducer, []);
            console.log(fullResults + '%%%%%%%%%');

            for (var i = 0; i < fullResults.length; i++) {
                fullResults[i].displayName = fullResults[i].name;
            }
            vm.memberList = fullResults;
            //dragAndDropService.setNodes(fullResults, 'arg2');

            vm.currentCohort.memberList = vm.memberList;
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:NewCtrl
     * @description
     * This is the new controller for the cohorts section of the application.
     */

    angular.module('eureka.cohorts').controller('cohorts.NewCtrl', NewCtrl);

    NewCtrl.$inject = ['CohortService', '$state', '$rootScope'];

    function NewCtrl(CohortService, $state, $rootScope) {
        var vm = this;
        var createCohort = CohortService.createCohort;
        var userId = $rootScope.user.info.id;

        vm.submitCohortForm = submitCohortForm;
        vm.memberList = [];
        vm.currentMemeberList = [];

        function submitCohortForm() {
            var cohortObject = {};
            cohortObject.name = vm.name;
            cohortObject.description = vm.description;
            cohortObject.memberList = vm.memberList;

            createCohort(cohortObject).then(function (data) {
                // if successful we prob need to redirect back to the main table
                console.log('we made it back', data);
                $state.transitionTo('cohorts');
            }, displayError);
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:TestCtrk
     * @description
     * This is the test controller for the cohorts section of the application.
     * @requires cohorts.CohortService
     */

    angular.module('eureka.cohorts').controller('cohorts.TestCtrl', TestCtrl);

    TestCtrl.$inject = ['CohortService', 'NgTableParams'];

    function TestCtrl(CohortService, NgTableParams) {
        var vm = this;
        var copyData = [];
        vm.columnDefs = [{
            name: ' ', field: 'edit',
            cellTemplate: '<a href="${editUrl}" title="Edit">' + '<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span></a> ' + '<span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>'
        }, { name: 'Name', field: 'name' }, { name: 'Descripton', field: 'description' }, { name: 'Type', field: 'type' }, { name: 'Created', field: 'created_at', enableCellEdit: false, cellFilter: 'date:"longDate"' }];
        vm.testData = [{
            'name': 'Vital1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Vital2',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Vital3',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test2',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Patient Test',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Updated Patient',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Procedure Codes',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Procedure 12',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'ICD9',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'ICD10',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test ICD10',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test ICD9',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data Test',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }];
        vm.remove = remove;

        function remove(key) {
            CohortService.removeCohort(key);
            for (var i = 0; i < vm.cohortsList.length; i++) {
                if (vm.cohortsList[i].name === key) {
                    vm.cohortsList.splice(i, 1);
                    break;
                }
            }
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        vm.selected = [];

        vm.filter = {
            options: {
                debounce: 500
            }
        };

        vm.query = {
            filter: '',
            order: 'name',
            limit: 5,
            page: 1
        };

        function success(cohorts) {
            vm.cohortsList = cohorts;
            //using dummy data
            vm.gridOptions.data = vm.testData.concat(cohorts);
            copyData = vm.testData.concat(cohorts);
            // NG Table
            vm.tableParams = new NgTableParams({}, { dataset: copyData });
        }

        vm.removeFilter = function () {
            vm.filter.show = false;
            vm.query.filter = '';

            if (vm.filter.form.$dirty) {
                vm.filter.form.$setPristine();
            }
        };

        // in the future we may see a few built in alternate headers but in the mean time
        // you can implement your own search header and do something like
        vm.search = function (predicate) {
            vm.filter = predicate;
            vm.deferred = CohortService.getCohorts(vm.query).then(success, displayError);
        };

        vm.onOrderChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        vm.onPaginationChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        // UI-Grid
        vm.gridOptions = {
            enableSorting: true,
            paginationPageSizes: [10, 20, 30],
            paginationPageSize: 10,
            columnDefs: [{ name: ' ', field: 'edit',
                cellTemplate: '<a href="${editUrl}" title="Edit">' + '<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span></a> ' + '<span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>'
            }, { name: 'Name', field: 'name' }, { name: 'Descripton', field: 'description' }, { name: 'Type', field: 'type' }, { name: 'Created', field: 'created_at', enableCellEdit: false, cellFilter: 'date:"longDate"' }],
            data: []
        };

        CohortService.getCohorts().then(success, displayError);
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.jobs.controller:MainCtrl
     * @description
     * This is the main controller for the jobs section of the application.
     * @requires jobs.JobService
     */

    angular.module('eureka.jobs').controller('jobs.MainCtrl', MainCtrl);

    MainCtrl.$inject = ['JobService'];

    function MainCtrl(JobService) {
        var vm = this;
        vm.radioData = 1;

        vm.earliestDate = earliestDate;
        vm.latestDate = latestDate;

        function displayError(msg) {
            console.log(msg);
            vm.errorMsg = msg;
        }
        function success(msg) {
            console.log(msg);
            vm.successMsg = msg;
        }

        JobService.getLatestJobs().then(function (data) {

            vm.jobsLatest = data;

            vm.jobLatest = vm.jobsLatest[0];

            vm.jobInfoSourceConfig = vm.jobLatest.sourceConfigId;

            vm.jobInfoDestination = vm.jobLatest.destinationId;

            vm.jobInfoStatus = vm.jobLatest.status;

            vm.jobInfoStartTimestamp = vm.jobLatest.startTimestamp;

            vm.jobInfoFinishTimestamp = vm.jobLatest.finishTimeStamp;
        });

        JobService.getDestinations().then(function (data) {

            vm.destinations = data;

            vm.jobDestination = vm.destinations[0];
        });

        JobService.getSourceConfigs().then(function (data) {

            vm.sourceConfigs = data;

            vm.jobSourceConfig = vm.sourceConfigs[0];
        });

        function earliestDate(ed) {
            console.log(ed);
        }

        function latestDate(ld) {
            console.log(ld);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc directive
     * @name eureka.phenotypes.directive:phenotypeEditor
     * @element *
     * @function
     * @description
     * Phenotype editor directive.
     * @requires $http
     * @requires $templateCache
     * @requires $timeout
     * @requires eureka.listDragAndDropService
     */

    angular.module('eureka.phenotypes').directive('phenotypeEditor', phenotypeEditor);

    phenotypeEditor.$inject = ['$http', '$templateCache', '$timeout', 'listDragAndDropService'];

    function phenotypeEditor(http, templateCache, timer, listDragAndDropService) {

        return {
            scope: {
                item: '=phenotypeEditor'
            },
            replace: true,
            restrict: 'EA',
            templateUrl: 'eureka/phenotypes/directives/phenotype-editor/phenotype-editor.html',
            link: function link(scope, element, attrs, ctrl, transclude) {
                scope.$watch('$last', function (v) {
                    var editorAction = function editorAction() {

                        $('ul.sortable').each(function (i, list) {
                            $(list).find('li').each(function (j, item) {
                                listDragAndDropService.addDroppedElement(item, $(list));
                            });

                            $('span.delete-icon').each(function (i, item) {
                                $(item).click(function () {
                                    var $toRemove = $(item).closest('li');
                                    var $sortable = $toRemove.closest('ul.sortable');
                                    var dialog = $('#deleteModal');
                                    $(dialog).find('#deleteContent').html('Are you sure you want to remove ' + 'data element &quot;' + $toRemove.text().trim() + '&quot;?');
                                    $(dialog).find('#deleteButton').on('click', function (e) {
                                        listDragAndDropService.deleteItem($toRemove, $sortable, 0);
                                        $(dialog).modal('hide');
                                    });
                                    $(dialog).modal('show');
                                });
                            });
                        });
                        var parent = element.parent();
                        if (parent.is('div')) {
                            parent.append($('<ul></ul>').attr('data-drop-type', 'multiple').attr('data-proptype', 'empty').addClass('sortable').append(element.parent().children()));
                        }
                    };

                    timer(editorAction, 0);
                });
            }
        };
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.phenotypes.controller:CreateCtrl
     * @description
     * This is the create controller for the phenotypes section of the application.
     * @requires $scope
     * @requires $location
     * @requires eureka.phenotypes.PhenotypeService
     */

    angular.module('eureka.phenotypes').controller('phenotypes.CreateCtrl', CreateCtrl);

    CreateCtrl.$inject = ['$stateParams', 'PhenotypeService', 'NgTableParams', 'dragAndDropService', 'TreeService', 'users', '$state'];

    function CreateCtrl($stateParams, PhenotypeService, NgTableParams, dragAndDropService, TreeService, users, $state) {

        // global items
        var vm = this;
        var currentUser = undefined;
        var createPhenotype = PhenotypeService.createPhenotype;

        // doing this on every page to make sure the user is authenticated if he/she refresh.  Will need to be changed but for now no time to refactor JS
        users.getUser().then(function (user) {
            currentUser = user;
        });
        vm.showPhenotypes = false;
        vm.type = _.startCase($stateParams.type);
        // Tree component
        vm.memberList = [];
        vm.myList = [];

        // Categorization
        vm.currentObject = {};
        vm.currentObject.displayName = '';
        vm.currentObject.description = '';
        vm.currentObject.children = [];

        // Frequency
        vm.frequencyObject = {};
        vm.frequencyObject.phenotype = {};
        vm.frequencyObject.phenotype.hasDuration = false;
        vm.frequencyObject.phenotype.minDuration = '';
        vm.frequencyObject.phenotype.minDurationUnits = "1";
        vm.frequencyObject.phenotype.maxDuration = '';
        vm.frequencyObject.phenotype.maxDurationUnits = "1";
        vm.frequencyObject.phenotype.hasPropertyConstraint = false;
        vm.frequencyObject.phenotype.property = "patientId";
        vm.frequencyObject.phenotype.propertyValue = '';
        vm.frequencyObject.isWithin = false;
        vm.frequencyObject.withinAtLeast = "";
        vm.frequencyObject.frequencyType = "1";
        vm.frequencyObject.withinAtLeastUnits = "1";
        vm.frequencyObject.withinAtMost = "";
        vm.frequencyObject.withinAtMostUnits = "1";

        // Sequence
        vm.seqObject = {};
        vm.seqObject.primaryPhenotype = {};
        vm.seqObject.relatedPhenotypes = [];
        vm.seqObject.primaryPhenotype.hasDuration = false;
        vm.seqObject.primaryPhenotype.minDuration = '';
        vm.seqObject.primaryPhenotype.minDurationUnits = '1';
        vm.seqObject.primaryPhenotype.maxDuration = '';
        vm.seqObject.primaryPhenotype.maxDurationUnits = '1';
        vm.seqObject.primaryPhenotype.hasPropertyConstraint = false;
        vm.seqObject.primaryPhenotype.property = "patientId";
        vm.seqObject.primaryPhenotype.propertyValue = '';
        // vm.seqObject.relatedPhenotypes = [];
        vm.seqMainPhenotype = [];
        vm.setCurrentSequence = 0;
        vm.currentPanel = '';
        //for relational phenotypes
        vm.isRelationalPhenotype = false;
        vm.phenotypeProperties = [];
        vm.releatedTemporalArray = [];

        // Threshold
        vm.thresholdObject = {};
        vm.thresholdObject.thresholdsOperator = '1';
        vm.thresholdObject.valueThresholds = [];
        vm.thresholdCompValues = [{ value: "1", display: "=" }, { value: "2", display: "not=" }, { value: "3", display: ">" }, { value: "4", display: ">=" }];
        vm.thresholdtypes = [{ value: "1", display: "any" }, { value: "2", display: "all" }];
        vm.thresholdRelationTypes = [{ value: "1", display: "before" }, { value: "2", display: "after" }, { value: "2", display: "around" }];

        // Show hide tree on right side
        vm.viewObject = {};
        vm.viewObject.showTree = false;

        // More global items
        vm.timeUnits = [{ name: 'minutes', value: "3" }, { name: 'hours', value: "2" }, { name: 'days', value: "1" }];
        vm.thresholdUnits = ['at least', 'first'];
        vm.sequenceRelations = [{ name: 'after', value: "2" }, { name: 'before', value: "1" }];

        switch ($stateParams.type) {
            case 'categorization':
                vm.description = 'This category data element may be used wherever its member data elements are accepted.';
                break;
            case 'sequence':
                vm.description = 'Computes intervals with the same start and stop time as the Main data element below when ' + 'the temporal relationships below are satisfied.';
                break;
            case 'frequency':
                vm.description = 'Computes an interval over the temporal extent of the intervals contributing to the ' + 'specified frequency count below.';
                break;
            case 'threshold':
                vm.description = 'Computes intervals corresponding to when the specified thresholds below are present.';
                break;
        }

        vm.openMenu = function ($mdOpenMenu, evt) {
            $mdOpenMenu(evt);
        };

        // Categorization
        vm.addCategorizationPhenotype = function () {
            vm.viewObject.showTree = true;
        };

        vm.createCategorization = function () {
            var children = [];
            for (var i = 0; i < vm.myList.length; i++) {
                var childrenObject = {};
                childrenObject.phenotypeKey = vm.myList[i].key;
                childrenObject.type = vm.myList[i].type;

                vm.currentObject.children.push(childrenObject);
            }
            vm.currentObject.type = "CATEGORIZATION";
            vm.currentObject.categoricalType = null;
            vm.currentObject.userId = currentUser.info.id;
            // PhenotypeService.createPhenotype(vm.currentObject);
            createPhenotype(vm.currentObject).then(function (data) {
                // if successful we prob need to redirect back to the main table
                console.log('we made it back', data);
                $state.transitionTo('phenotypes');
            }, displayError);
        };

        // Frequency
        vm.addFrequencyPhenotype = function () {
            vm.viewObject.showTree = true;
        };

        vm.createFrequency = function () {
            vm.frequencyObject.type = "FREQUENCY";
            vm.frequencyObject.isConsecutive = false;
            vm.frequencyObject.phenotype.phenotypeKey = vm.myList[0].key;

            if (vm.frequencyThreshold === 'at least') {
                vm.frequencyObject['atLeast'] = vm.frequencyThresholdValue;
            } else {
                vm.frequencyObject['first'] = vm.frequencyThresholdValue;
            }
            vm.frequencyObject.userId = currentUser.info.id;
            console.log(JSON.stringify(vm.frequencyObject));

            createPhenotype(vm.frequencyObject).then(function (data) {
                $state.transitionTo('phenotypes');
            }, displayError);
        };

        // Threshold
        vm.createThreshold = function () {
            // This type is wrong.  Needs to be changed
            vm.thresholdObject.type = "VALUE_THRESHOLD";
            vm.thresholdObject.userId = currentUser.info.id;
            // We need to loop through the objects and build the correct item to pass back
            for (var i = 0; i < vm.thresholdObject.valueThresholds.length; i++) {

                delete vm.thresholdObject.valueThresholds[i].$$hashKey;

                var currentItem = vm.thresholdObject.valueThresholds[i].phenotype.relatedPhenotypeKey;

                delete vm.thresholdObject.valueThresholds[i].relatedPhenotypeKey;

                var myNewObject = {};
                myNewObject.phenotypeKey = currentItem;
                myNewObject.type = "SYSTEM";
                vm.thresholdObject.valueThresholds[i].relatedPhenotypes.push(myNewObject);
            }

            console.log(JSON.stringify(vm.thresholdObject));
            //var testObj = { "primaryPhenotype": { "hasDuration": true, "minDuration": 1, "minDurationUnits": "1", "maxDuration": 1, "maxDurationUnits": "1", "hasPropertyConstraint": true, "property": "patientId", "propertyValue": null, "phenotypeKey": "Patient" }, "relatedPhenotypes": [{ "phenotypeField": { "phenotypeKey": "Patient", "hasDuration": true, "minDuration": 2, "minDurationUnits": "1", "maxDuration": 2, "maxDurationUnits": "1", "hasPropertyConstraint": true, "property": "patientId" }, "relationOperator": "2", "sequentialPhenotype": "Patient", "sequentialPhenotypeSource": "1", "relationMinCount": 2, "relationMinUnits": "1", "relationMaxCount": 4, "relationMaxUnits": "1" }], "displayName": "ONETIME0987", "description": "test", "type": "SEQUENCE", "userId": 1 };
            createPhenotype(vm.thresholdObject).then(function (data) {
                $state.transitionTo('phenotypes');
            }, displayError);
        };

        vm.addPhenotypeToThreshold = function (indexPanel, isRelational) {
            vm.currentPanel = indexPanel;
            vm.viewObject.showTree = true;
            if (isRelational === undefined) {
                // do nothing
            } else {
                    // it is a relational phenotype.
                    vm.isRelationalPhenotype = true;
                }
        };

        vm.addNewThreshold = function () {
            var openObject = {};
            var relatedObject = {};
            openObject.phenotype = {};

            openObject.relatedPhenotypes = [];
            vm.thresholdObject.valueThresholds.push(openObject);
        };

        function addMembersThreshold() {
            // adding related items
            vm.thresholdObject.valueThresholds[vm.currentPanel - 1].phenotype.phenotypeKey = vm.currentMemeberList[0].key;
            vm.currentPanel = '';
        }

        // private function to add threshold related phenotypes
        function addRelationalThreshold() {
            // if it is primary phenotype do this
            //else it is a related item
            vm.thresholdObject.valueThresholds[vm.currentPanel - 1].phenotype.type = "SYSTEM";
            vm.thresholdObject.valueThresholds[vm.currentPanel - 1].phenotype.relatedPhenotypeKey = vm.currentMemeberList[0].key;
            vm.currentPanel = '';
        }

        // Sequence
        vm.createSequence = function () {
            vm.seqObject.type = "SEQUENCE";
            vm.seqObject.userId = currentUser.info.id;
            if (vm.seqObject.relatedPhenotypes.length > 0) {
                delete vm.seqObject.relatedPhenotypes[0].$$hashKey;
                delete vm.seqObject.relatedPhenotypes[0].phenotypeField.properties;
            }

            console.log(JSON.stringify(vm.seqObject));
            //var testObj = { "primaryPhenotype": { "hasDuration": true, "minDuration": 1, "minDurationUnits": "1", "maxDuration": 1, "maxDurationUnits": "1", "hasPropertyConstraint": true, "property": "patientId", "propertyValue": null, "phenotypeKey": "Patient" }, "relatedPhenotypes": [{ "phenotypeField": { "phenotypeKey": "Patient", "hasDuration": true, "minDuration": 2, "minDurationUnits": "1", "maxDuration": 2, "maxDurationUnits": "1", "hasPropertyConstraint": true, "property": "patientId" }, "relationOperator": "2", "sequentialPhenotype": "Patient", "sequentialPhenotypeSource": "1", "relationMinCount": 2, "relationMinUnits": "1", "relationMaxCount": 4, "relationMaxUnits": "1" }], "displayName": "ONETIME0987", "description": "test", "type": "SEQUENCE", "userId": 1 };
            createPhenotype(vm.seqObject).then(function (data) {
                $state.transitionTo('phenotypes');
            }, displayError);
        };

        vm.addMainPhenotype = function () {
            vm.currentPanel = 'primaryPhenotype';
            vm.viewObject.showTree = true;
            vm.showPhenotypes = true;
        };

        vm.addPhenotypeToRelated = function (indexPanel) {
            vm.currentPanel = indexPanel;
            vm.viewObject.showTree = true;
        };

        // add related phenotypes
        vm.addRelatedPhenotypes = function () {
            var openObject = {};
            openObject.phenotypeField = {};
            openObject.phenotypeField.properties = [];
            vm.seqObject.relatedPhenotypes.push(openObject);
        };

        // private function to add sequence related phenotypes
        function addNewMembersRelated() {
            // if it is primary phenotype do this
            if (vm.currentPanel === 'primaryPhenotype') {
                console.log(vm.currentPanel);
                vm.phenotypeProperties = [];
                vm.phenotypeProperties = vm.currentMemeberList[0].properties;
                vm.seqObject.primaryPhenotype.phenotypeKey = vm.currentMemeberList[0].key;
                vm.releatedTemporalArray.push(vm.currentMemeberList[0].key);
            } else {
                //else it is a related item
                vm.seqObject.relatedPhenotypes[vm.currentPanel - 1].phenotypeField.properties = vm.currentMemeberList[0].properties;
                vm.seqObject.relatedPhenotypes[vm.currentPanel - 1].phenotypeField.phenotypeKey = vm.currentMemeberList[0].key;
                vm.releatedTemporalArray.push(vm.currentMemeberList[0].key);
            }
            vm.currentPanel = '';
        }

        // Important to add items to the list from tree
        vm.addMembers = function () {
            if (vm.currentMemeberList.length > 0) {

                if (vm.type === 'Sequence') {
                    addNewMembersRelated();
                } else if (vm.type === 'Frequency') {
                    vm.myList = [];
                    for (var i = 0; i < vm.currentMemeberList.length; i++) {
                        vm.myList.push(vm.currentMemeberList[i]);
                    }
                    // now add the properties to the dropdown
                    vm.phenotypeProperties = vm.myList[0].properties;
                } else if (vm.type === 'Threshold') {
                    if (vm.isRelationalPhenotype === false) {
                        addMembersThreshold();
                    } else {
                        addRelationalThreshold();
                    }
                } else {

                    for (var i = 0; i < vm.currentMemeberList.length; i++) {
                        vm.myList.push(vm.currentMemeberList[i]);
                    }
                }

                vm.currentMemeberList = [];
                vm.viewObject.showTree = false;
            }
        };

        // End of logic for creting Phenotypes

        // Start Logic for Table.

        vm.breadCrumbs = [{ key: 'root', displayName: 'root' }];

        var currentNodes = [];

        getMemberList();
        TreeService.getTreeRoot().then(function (data) {
            // NG Table instantiates
            vm.tableParams = new NgTableParams({}, { dataset: data });
            callUserRoot();
        }, displayError);

        function init() {
            // clearNodes();
        }

        function callUserRoot() {
            TreeService.getUserListRoot().then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                vm.tableParamsUser = new NgTableParams({}, { dataset: data.data });
            }, displayError);
        }

        vm.selectNode = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            if (hasChildren !== false) {
                TreeService.getTreeNode(currentNode.key).then(function (data) {

                    if (hasChildren) {
                        vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName, parent: currentNode.parent });
                    }
                    vm.tableParams = new NgTableParams({}, { dataset: data.children });
                }, displayError);
            } else {
                //do nothing it is a document
            }
        };

        vm.addNode = function (node) {
            console.log(vm.currentMemeberList + '  1');
            console.log(currentNodes + '@@');
            if (node) {

                setNodes(node);
            }
            getMemberList();
        };

        vm.addUserNode = function (node) {
            /* After changes add user node will need to be refactored will take care of later in week.
            if (node) {
                node.displayName = node.text;
                dragAndDropService.setNodes(node);
            }
            getMemberList() */
        };
        vm.removeNode = function (node) {
            for (var i = 0; i < vm.currentMemeberList.length; i++) {
                // we will need to look for both key and name.  name is key in update, but key is present on create.
                if (node.key === undefined) {
                    if (vm.currentMemeberList[i].name === node.name) {
                        vm.currentMemeberList.splice(i, 1);
                        break;
                    }
                } else {
                    if (vm.currentMemeberList[i].key === node.key) {
                        vm.currentMemeberList.splice(i, 1);
                        break;
                    }
                }
            }
        };
        vm.setBreadCrumbs = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            var pos = 0;
            var returnedData = [];

            TreeService.getTreeNode(currentNode.key).then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                if (data.hasOwnProperty('parent') && data['parent']) {
                    returnedData = data.children;
                } else {
                    returnedData = data;
                }
                if (hasChildren) {
                    vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName });
                }

                vm.tableParams = new NgTableParams({}, { dataset: returnedData });

                pos = vm.breadCrumbs.map(function (e) {
                    return e.key;
                }).indexOf(currentNode.key);
                vm.breadCrumbs.length = pos + 1;
            }, displayError);
        };

        function getMemberList() {
            vm.currentMemeberList = getNodes();
        }

        function setNodes(obj, arg2) {
            currentNodes = vm.currentMemeberList;
            if (arg2 == undefined || arg2 === null) {
                if (obj !== undefined) {
                    var currentList = [];
                    currentList = currentNodes;
                    var isDuplicate = false;
                    //lets do it the long way first then we will refactor.  Lets see if there are duplicates JS
                    if (currentList.length < 1) {
                        currentNodes.push(obj);
                    } else {
                        for (var i = 0; i < currentList.length; i++) {
                            if (currentList[i].hasOwnProperty('name')) {
                                if (currentList[i].name === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            } else if (currentList[i].hasOwnProperty('key')) {
                                if (currentList[i].key === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            }
                        }
                        if (isDuplicate !== true) {
                            currentNodes.push(obj);
                        }
                    }
                }
            } else {
                currentNodes = obj;
            }
        }

        function getNodes() {
            return currentNodes;
        }

        function clearNodes() {
            currentNodes = [];
        }

        //end of the table  **************

        function displayError(msg) {
            vm.errorMsg = msg;
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.phenotypes.controller:EditCtrl
     * @description
     * This is the edit controller for the phenotypes section of the application.
     * @requires $scope
     * @requires $location
     * @requires eureka.phenotypes.PhenotypeService
     */

    angular.module('eureka.phenotypes').controller('phenotypes.EditCtrl', EditCtrl);

    EditCtrl.$inject = ['$stateParams', 'PhenotypeService', 'dragAndDropService', 'TreeService', 'users', '$state', 'NgTableParams'];

    function EditCtrl($stateParams, PhenotypeService, dragAndDropService, TreeService, users, $state, NgTableParams) {

        var vm = this;
        var currentUser = undefined;
        var currentList = [];
        var currentType = '';
        var updatePhenotype = PhenotypeService.updatePhenotype;

        // Tree component
        vm.memberList = [];
        vm.myList = [];
        // Show hide tree on right side
        vm.viewObject = {};
        vm.viewObject.showTree = false;

        // doing this on every page to make sure the user is authenticated if he/she refresh.  Will need to be changed but for now no time to refactor JS
        users.getUser().then(function (user) {
            currentUser = user;
        });

        vm.currentObject = {};
        vm.memberList = [];
        vm.type = _.startCase($stateParams.type);
        vm.timeUnits = ['minutes', 'hours', 'days'];

        //frequency
        vm.frequencyObject = {};
        vm.frequencyObject.phenotype = {};
        vm.timeUnits = [{ name: 'minutes', value: 3 }, { name: 'hours', value: 2 }, { name: 'days', value: 1 }];
        vm.thresholdUnits = ['at least', 'first'];

        //Sequence
        vm.seqObject = {};

        vm.thresholdObject = {};

        if ($stateParams.id) {
            PhenotypeService.getPhenotype($stateParams.id).then(function (data) {
                if (data.type === "FREQUENCY") {
                    vm.frequencyObject = data;
                    currentType = vm.frequencyObject.type;
                    setType();
                    // have to set the member list for the drop area

                    var myChildren = {};
                    myChildren.key = data.phenotype.phenotypeKey;
                    myChildren.displayName = data.phenotype.phenotypeKey;
                    myChildren.type = data.phenotype.type;
                    currentList.push(myChildren);

                    //dragAndDropService.setNodes(currentList);
                    vm.memberList = currentList;
                    console.log(vm.currentObject);
                } else if (data.type === "CATEGORIZATION") {

                    vm.currentObject = data;
                    currentType = vm.currentObject.type;
                    setType();
                    // have to set the member list for the drop area
                    for (var i = 0; i < data.children.length; i++) {
                        var myChildren = {};
                        myChildren.key = data.children[i].phenotypeKey;
                        myChildren.displayName = data.children[i].phenotypeKey;
                        myChildren.type = data.children[i].type;
                        currentList.push(myChildren);
                    }
                    //dragAndDropService.setNodes(currentList);
                    vm.memberList = currentList;
                    console.log(vm.currentObject);
                } else if (data.type === "SEQUENCE") {

                    vm.seqObject = data;
                    currentType = vm.seqObject.type;
                    setType();
                } else if (data.type === "VALUE_THRESHOLD") {

                    vm.thresholdObject = data;
                    currentType = vm.thresholdObject.type;
                    setType();
                }
            }, displayError);
        }

        vm.addFrequencyPhenotype = function () {
            vm.viewObject.showTree = true;
        };
        vm.addCategorizationPhenotype = function () {
            vm.viewObject.showTree = true;
        };
        vm.addMainPhenotype = function () {
            vm.currentPanel = 'primaryPhenotype';
            vm.viewObject.showTree = true;
            vm.showPhenotypes = true;
        };
        vm.addPhenotypeToThreshold = function (indexPanel, isRelational) {
            vm.currentPanel = indexPanel;
            vm.viewObject.showTree = true;
            if (isRelational === undefined) {
                // do nothing
            } else {
                    // it is a relational phenotype.
                    vm.isRelationalPhenotype = true;
                }
        };

        // vm.memberList = [];

        function setType() {
            switch (currentType) {
                case 'CATEGORIZATION':
                    vm.description = 'This category data element may be used wherever its member data elements are accepted.';
                    vm.name = 'Categorization';
                    vm.type = 'CATEGORIZATION';
                    break;
                case 'SEQUENCE':
                    vm.description = 'Computes intervals with the same start and stop time as the Main data element below when ' + 'the temporal relationships below are satisfied.';
                    vm.name = 'Sequence';
                    vm.type = 'SEQUENCE';
                    break;
                case 'FREQUENCY':
                    vm.description = 'Computes an interval over the temporal extent of the intervals contributing to the ' + 'specified frequency count below.';
                    vm.name = 'Frequency';
                    vm.type = 'FREQUENCY';
                    break;
                case 'VALUE_THRESHOLD':
                    vm.description = 'Computes intervals corresponding to when the specified thresholds below are present.';
                    vm.name = 'Value Threshold';
                    vm.type = 'Threshold';
                    break;
            }
        }
        vm.openMenu = function ($mdOpenMenu, evt) {
            $mdOpenMenu(evt);
        };

        vm.updateCategorization = function () {

            var updateObject = {};
            updateObject.type = vm.currentObject.type;
            updateObject.displayName = vm.currentObject.displayName;
            updateObject.description = vm.currentObject.description;
            updateObject.categoricalType = vm.currentObject.categoricalType;
            updateObject.id = vm.currentObject.id;
            updateObject.userId = currentUser.info.id;
            updateObject.children = [];

            // {"type":"CATEGORIZATION","displayName":"ONEMORETIME901","description":"description","categoricalType":"CONSTANT","children":[{"phenotypeKey":"Patient","type":"SYSTEM"}],"id":13}

            var children = [];
            for (var i = 0; i < vm.memberList.length; i++) {
                var childrenObject = {};
                // if (vm.memberList[i].key === undefined) {
                childrenObject.phenotypeKey = vm.memberList[i].key;
                childrenObject.type = vm.memberList[i].type;
                children.push(childrenObject);
                // }
            }
            updateObject.children = children;
            // vm.currentObject.type = "CATEGORIZATION";
            //vm.currentObject.categoricalType = null;
            vm.currentObject.userId = 1;
            console.log('######    ' + vm.currentObject);

            PhenotypeService.updatePhenotype(updateObject);
            updatePhenotype(updateObject).then(function (data) {
                console.log('we made it back', data);
                $state.transitionTo('phenotypes');
            }, displayError);
        };

        // Start Logic for Table.

        vm.breadCrumbs = [{ key: 'root', displayName: 'root' }];

        var currentNodes = [];

        getMemberList();
        TreeService.getTreeRoot().then(function (data) {
            // NG Table instantiates
            vm.tableParams = new NgTableParams({}, { dataset: data });
            callUserRoot();
        }, displayError);

        function init() {
            // clearNodes();
        }

        function callUserRoot() {
            TreeService.getUserListRoot().then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                vm.tableParamsUser = new NgTableParams({}, { dataset: data.data });
            }, displayError);
        }

        vm.selectNode = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            if (hasChildren !== false) {
                TreeService.getTreeNode(currentNode.key).then(function (data) {

                    if (hasChildren) {
                        vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName, parent: currentNode.parent });
                    }
                    vm.tableParams = new NgTableParams({}, { dataset: data.children });
                }, displayError);
            } else {
                //do nothing it is a document
            }
        };

        vm.addNode = function (node) {
            console.log(vm.currentMemeberList + '  1');
            console.log(currentNodes + '@@');
            if (node) {

                setNodes(node);
            }
            getMemberList();
        };

        vm.addUserNode = function (node) {
            /* After changes add user node will need to be refactored will take care of later in week.
            if (node) {
                node.displayName = node.text;
                dragAndDropService.setNodes(node);
            }
            getMemberList() */
        };
        vm.removeNode = function (node) {
            for (var i = 0; i < vm.currentMemeberList.length; i++) {
                // we will need to look for both key and name.  name is key in update, but key is present on create.
                if (node.key === undefined) {
                    if (vm.currentMemeberList[i].name === node.name) {
                        vm.currentMemeberList.splice(i, 1);
                        break;
                    }
                } else {
                    if (vm.currentMemeberList[i].key === node.key) {
                        vm.currentMemeberList.splice(i, 1);
                        break;
                    }
                }
            }
        };
        vm.setBreadCrumbs = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            var pos = 0;
            var returnedData = [];

            TreeService.getTreeNode(currentNode.key).then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                if (data.hasOwnProperty('parent') && data['parent']) {
                    returnedData = data.children;
                } else {
                    returnedData = data;
                }
                if (hasChildren) {
                    vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName });
                }

                vm.tableParams = new NgTableParams({}, { dataset: returnedData });

                pos = vm.breadCrumbs.map(function (e) {
                    return e.key;
                }).indexOf(currentNode.key);
                vm.breadCrumbs.length = pos + 1;
            }, displayError);
        };

        function getMemberList() {
            vm.currentMemeberList = getNodes();
        }

        function setNodes(obj, arg2) {
            currentNodes = vm.currentMemeberList;
            if (arg2 == undefined || arg2 === null) {
                if (obj !== undefined) {
                    var _currentList = [];
                    _currentList = currentNodes;
                    var isDuplicate = false;
                    //lets do it the long way first then we will refactor.  Lets see if there are duplicates JS
                    if (_currentList.length < 1) {
                        currentNodes.push(obj);
                    } else {
                        for (var i = 0; i < _currentList.length; i++) {
                            if (_currentList[i].hasOwnProperty('name')) {
                                if (_currentList[i].name === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            } else if (_currentList[i].hasOwnProperty('key')) {
                                if (_currentList[i].key === obj.key) {
                                    isDuplicate = true;
                                    break;
                                }
                            }
                        }
                        if (isDuplicate !== true) {
                            currentNodes.push(obj);
                        }
                    }
                }
            } else {
                currentNodes = obj;
            }
        }

        function getNodes() {
            return currentNodes;
        }

        function clearNodes() {
            currentNodes = [];
        }

        //end of the table  **************

        function displayError(msg) {
            vm.errorMsg = msg;
        }
    }
})();
'use strict';

(function () {

  /**
   * @ngdoc controller
   * @name eureka.phenotypes.controller:MainCtrl
   * @description
   * This is the main controller for the phenotypes section of the application.
   * @requires $scope
   * @requires $location
   * @requires eureka.phenotypes.PhenotypeService
   */

  angular.module('eureka.phenotypes').controller('phenotypes.ModalCtrl', ModalCtrl).controller('phenotypes.DeleteModalCtrl', DeleteModalCtrl).controller('phenotypes.MainCtrl', MainCtrl);

  ModalCtrl.$inject = ['$uibModalInstance'];
  DeleteModalCtrl.$inject = ['$uibModalInstance', 'data'];
  MainCtrl.$inject = ['$state', 'PhenotypeService', 'NgTableParams', '$uibModal'];

  function ModalCtrl($uibModalInstance, currentUser) {
    var mo = this;
    mo.currentUser = currentUser;
    mo.ok = function () {
      $uibModalInstance.close();
    };

    mo.cancel = function () {
      $uibModalInstance.dismiss('cancel');
    };
  }

  function DeleteModalCtrl($uibModalInstance, data) {
    var mo = this;
    mo.data = data;
    mo.ok = function () {
      $uibModalInstance.close();
    };

    mo.cancel = function () {
      $uibModalInstance.dismiss('cancel');
    };
  }
  function MainCtrl($state, PhenotypeService, NgTableParams, $uibModal) {

    var vm = this;
    var copyData = [];

    vm.currentSelectedItem = {};
    vm.selected = [];

    vm.filter = {
      options: {
        debounce: 500
      }
    };

    vm.query = {
      filter: '',
      order: 'name',
      limit: 5,
      page: 1
    };

    function success(data) {
      vm.props = data;
      copyData = data;
      // NG Table
      vm.tableParams = new NgTableParams({}, { dataset: copyData });
    }

    function displayError(msg) {
      vm.errorMsg = msg;
    }

    vm.removeFilter = function () {
      vm.filter.show = false;
      vm.query.filter = '';

      if (vm.filter.form.$dirty) {
        vm.filter.form.$setPristine();
      }
    };

    vm.deletePhenotype = function (user, indexOfRow) {
      var currentItem = user;
      var currentRow = indexOfRow;

      $uibModal.open({
        templateUrl: 'myModal.html',
        controller: 'phenotypes.ModalCtrl',
        controllerAs: 'mo',
        resolve: {
          currentUser: function currentUser() {
            return user;
          }
        }
      }).result.then(function () {
        removePhenotype(currentItem);
      }, function (arg) {
        console.log(arg);
      });
    };

    function deleteSuccess() {
      vm.tableParams.filter({});
      for (var i = 0; i < vm.props.length; i++) {
        if (vm.props[i].displayName === vm.currentSelectedItem.displayName) {
          vm.props.splice(i, 1);
          break;
        }
      }
      vm.tableParams.reload();
    }

    function deleteError(_data) {
      $uibModal.open({
        templateUrl: 'errorModal.html',
        controller: 'phenotypes.DeleteModalCtrl',
        controllerAs: 'mod',
        resolve: {
          data: function data() {
            return _data;
          }
        }
      }).result.then(function () {}, function (arg) {});
    }

    function removePhenotype(data) {
      vm.currentSelectedItem = data;
      vm.deferred = PhenotypeService.removePhenotype(data.id).then(deleteSuccess, deleteError);
    }

    vm.onOrderChange = function () {
      return PhenotypeService.getSummarizedUserElements(vm.query);
    };

    vm.onPaginationChange = function () {
      return PhenotypeService.getSummarizedUserElements(vm.query);
    };

    PhenotypeService.getSummarizedUserElements().then(success, displayError);

    var messages = PhenotypeService.getPhenotypeMessages();
    vm.messages = messages;

    vm.openMenu = function ($mdOpenMenu, evt) {
      $mdOpenMenu(evt);
    };

    vm.navigateTo = function (phenotypeType) {
      $state.transitionTo('createPhenotype', {
        type: phenotypeType
      });
    };
  }
})();
//# sourceMappingURL=app-55d5cfb1d4.js.map
