/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClient;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.AppModule;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.ServletModule;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import javax.servlet.ServletContextEvent;
import org.eurekaclinical.common.config.InjectorSupport;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.eurekaclinical.user.client.EurekaClinicalUserProxyClient;

public class WebappListener
extends GuiceServletContextListener {
    private final WebappProperties webappProperties = new WebappProperties();
    private final EurekaClinicalUserProxyClient userClient;
    private final ServicesClient servicesClient = new ServicesClient(this.webappProperties.getServiceUrl());
    private final EtlClient etlClient = new EtlClient(this.webappProperties.getEtlUrl());

    public WebappListener() {
        this.userClient = new EurekaClinicalUserProxyClient(this.webappProperties.getUserServiceUrl());
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        servletContextEvent.getServletContext().setAttribute("webappProperties", (Object)this.webappProperties);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        servletContextEvent.getServletContext().removeAttribute("webappProperties");
        this.etlClient.close();
        this.servicesClient.close();
        this.userClient.close();
    }

    protected Injector getInjector() {
        return new InjectorSupport(new Module[]{new AppModule(this.webappProperties, this.servicesClient, this.etlClient, this.userClient), new ServletModule(this.webappProperties)}, (EurekaClinicalProperties)this.webappProperties).getInjector();
    }
}

