/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Injector;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Destination;

@Singleton
public class DateRangePhenotypeServlet
extends HttpServlet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final long serialVersionUID = 1L;
    private final Injector injector;

    @Inject
    public DateRangePhenotypeServlet(Injector inInjector) {
        this.injector = inInjector;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Destination destination;
        resp.setContentType("application/json");
        String destinationId = req.getParameter("destinationId");
        if (destinationId == null) {
            throw new ServletException("Missing query parameter 'destinationId'");
        }
        try {
            destination = ((ServicesClient)this.injector.getInstance(ServicesClient.class)).getDestination(destinationId);
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting destination '" + destinationId + "'");
        }
        String json = MAPPER.writeValueAsString((Object)destination.getPhenotypeFields());
        resp.setContentLength(json.length());
        PrintWriter out = resp.getWriter();
        out.println(json);
    }
}

