/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.Count;
import edu.emory.cci.aiw.cvrg.eureka.servlet.Counts;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.Statistics;

@Singleton
public class JobPatientCountsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Injector injector;
    private final ObjectWriter writer;

    @Inject
    public JobPatientCountsServlet(Injector inInjector) {
        this.injector = inInjector;
        this.writer = new ObjectMapper().writer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block10: {
            String jobIdStr = req.getParameter("jobId");
            String key = req.getParameter("propId");
            Long jobId = null;
            if (StringUtils.isNotEmpty((CharSequence)jobIdStr)) {
                try {
                    jobId = Long.valueOf(jobIdStr);
                    ServicesClient servicesClient = (ServicesClient)this.injector.getInstance(ServicesClient.class);
                    try {
                        Statistics jobStats = servicesClient.getJobStats(jobId, key);
                        Map childrenToParents = jobStats.getChildrenToParents();
                        Map counts = jobStats.getCounts();
                        Counts results = new Counts();
                        ArrayList<Count> countResults = new ArrayList<Count>();
                        Set keySet = counts.keySet();
                        List summarizedConcepts = servicesClient.getPhenotypes(keySet.toArray(new String[keySet.size()]), true);
                        HashMap<String, Phenotype> keyIdToDE = new HashMap<String, Phenotype>();
                        for (Phenotype phenotype : summarizedConcepts) {
                            keyIdToDE.put(phenotype.getKey(), phenotype);
                        }
                        for (Map.Entry entry : counts.entrySet()) {
                            Count count = new Count();
                            count.setKey((String)entry.getKey());
                            count.setParentKeyId((String)childrenToParents.get(entry.getKey()));
                            count.setCount((Integer)entry.getValue());
                            Phenotype de = (Phenotype)keyIdToDE.get(entry.getKey());
                            if (de != null) {
                                count.setDisplayName(de.getDisplayName());
                            }
                            countResults.add(count);
                        }
                        results.setCounts(countResults);
                        this.writer.writeValue((OutputStream)resp.getOutputStream(), (Object)results);
                    }
                    catch (ClientException ex) {
                        if (ex.getResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                            resp.sendError(412, "No job with jobId " + jobIdStr);
                            break block10;
                        }
                        throw new ServletException("Error getting patient counts for job " + jobId, (Throwable)ex);
                    }
                }
                catch (NumberFormatException nfe) {
                    resp.sendError(412, "jobId parameter must be a long, was " + jobIdStr);
                }
            } else {
                resp.sendError(412, "jobId parameter is required");
            }
        }
    }
}

