/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import com.google.inject.Injector;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SavePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.webapp.authentication.WebappAuthenticationSupport;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SavePropositionServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SavePropositionServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final long serialVersionUID = 1L;
    private final Injector injector;
    private final WebappAuthenticationSupport authenticationSupport;

    @Inject
    public SavePropositionServlet(Injector inInjector) {
        this.injector = inInjector;
        this.authenticationSupport = new WebappAuthenticationSupport();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        block16: {
            LOGGER.debug("SavePropositionServlet");
            try {
                Phenotype phenotype = (Phenotype)MAPPER.readValue((Reader)req.getReader(), Phenotype.class);
                User user = this.authenticationSupport.getMe(req);
                phenotype.setUserId(user.getId());
                ServicesClient servicesClient = (ServicesClient)this.injector.getInstance(ServicesClient.class);
                if (phenotype.getId() == null) {
                    try {
                        URI phenotypeURI = servicesClient.saveUserPhenotype(phenotype);
                        if (phenotypeURI != null) {
                            resp.setStatus(201);
                            resp.setHeader("Location", phenotypeURI.toString());
                        }
                        break block16;
                    }
                    catch (ClientException e) {
                        resp.setStatus(e.getResponseStatus().getStatusCode());
                        resp.getOutputStream().print(e.getMessage());
                    }
                    break block16;
                }
                servicesClient.updateUserPhenotype(phenotype.getId(), phenotype);
            }
            catch (ClientException e) {
                try {
                    switch (1.$SwitchMap$com$sun$jersey$api$client$ClientResponse$Status[e.getResponseStatus().ordinal()]) {
                        case 1: {
                            this.authenticationSupport.needsToLogin(req, resp);
                            break;
                        }
                        default: {
                            resp.setStatus(e.getResponseStatus().getStatusCode());
                            resp.getWriter().write(e.getMessage());
                            break;
                        }
                    }
                }
                catch (IOException ex) {
                    resp.setStatus(500);
                    LOGGER.error("IO Error writing response status", (Throwable)ex);
                    try {
                        resp.getWriter().write("Internal server error");
                    }
                    catch (IOException ignore) {
                        LOGGER.error("Error writing the internal server error message: {}", (Throwable)ignore);
                    }
                }
            }
            catch (IOException t) {
                resp.setStatus(500);
                LOGGER.error("IO Error saving phenotype", (Throwable)t);
                try {
                    resp.getWriter().write("Internal server error");
                }
                catch (IOException ignore) {
                    LOGGER.error("Error writing the internal server error message: {}", (Throwable)ignore);
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

