/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.servlet.DateRangePhenotypeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobPatientCountsServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobStatsServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.LoginServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.SessionPropertiesServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.MessagesFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.RolesFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.UserFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.DeletePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditPropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditorHomeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.ListUserDefinedPropositionChildrenServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SavePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SearchSystemPropositionJSTreeV1Servlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SearchSystemPropositionJSTreeV3Servlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SystemPropositionListServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.UserPropositionListServlet;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.common.config.AbstractServletModule;
import org.eurekaclinical.common.servlet.DestroySessionServlet;
import org.eurekaclinical.common.servlet.LogoutServlet;
import org.eurekaclinical.common.servlet.ProxyServlet;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletModule
extends AbstractServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletModule.class);
    private static final String FILTER_PATH = "^/(?!(assets|bower_components)).*";
    private static final String LOGOUT_PATH = "/logout";
    private final WebappProperties properties;

    public ServletModule(WebappProperties inProperties) {
        super((CasEurekaClinicalProperties)inProperties);
        this.properties = inProperties;
    }

    private void setupMessageFilter() {
        this.filterRegex(FILTER_PATH, new String[0]).through(MessagesFilter.class);
    }

    private void setupUserFilter() {
        this.filterRegex(FILTER_PATH, new String[0]).through(UserFilter.class);
    }

    private void setupRolesFilter() {
        this.filterRegex(FILTER_PATH, new String[0]).through(RolesFilter.class);
    }

    protected void setupFilters() {
        this.setupMessageFilter();
        this.setupUserFilter();
        this.setupRolesFilter();
    }

    protected void setupServlets() {
        this.serve("/proxy-resource/*", new String[0]).with(ProxyServlet.class);
        this.bind(SessionPropertiesServlet.class).in(Singleton.class);
        this.serve("/protected/get-session-properties", new String[0]).with(SessionPropertiesServlet.class);
        this.serve("/destroy-session", new String[0]).with(DestroySessionServlet.class);
        this.serve(LOGOUT_PATH, new String[0]).with(LogoutServlet.class);
        this.serve("/protected/login", new String[0]).with(LoginServlet.class);
        this.bind(JobStatsServlet.class).in(Singleton.class);
        this.serve("/protected/jobstats", new String[0]).with(JobStatsServlet.class);
        this.bind(JobPatientCountsServlet.class).in(Singleton.class);
        this.serve("/protected/jobpatcounts", new String[0]).with(JobPatientCountsServlet.class);
        this.bind(EditorHomeServlet.class).in(Singleton.class);
        this.serve("/protected/editorhome", new String[0]).with(EditorHomeServlet.class);
        this.bind(SystemPropositionListServlet.class).in(Singleton.class);
        this.serve("/protected/systemlist", new String[0]).with(SystemPropositionListServlet.class);
        this.bind(SavePropositionServlet.class).in(Singleton.class);
        this.serve("/protected/saveprop", new String[0]).with(SavePropositionServlet.class);
        this.bind(DeletePropositionServlet.class).in(Singleton.class);
        this.serve("/protected/deleteprop", new String[0]).with(DeletePropositionServlet.class);
        this.bind(UserPropositionListServlet.class).in(Singleton.class);
        this.serve("/protected/userproplist", new String[0]).with(UserPropositionListServlet.class);
        this.bind(ListUserDefinedPropositionChildrenServlet.class).in(Singleton.class);
        this.serve("/protected/userpropchildren", new String[0]).with(ListUserDefinedPropositionChildrenServlet.class);
        this.bind(EditPropositionServlet.class).in(Singleton.class);
        this.serve("/protected/editprop", new String[0]).with(EditPropositionServlet.class);
        this.bind(DateRangePhenotypeServlet.class).in(Singleton.class);
        this.serve("/protected/destinationphenotypes", new String[0]).with(DateRangePhenotypeServlet.class);
        this.bind(SearchSystemPropositionJSTreeV3Servlet.class).in(Singleton.class);
        this.serve("/protected/jstree3_searchsystemlist", new String[0]).with(SearchSystemPropositionJSTreeV3Servlet.class);
        this.bind(SearchSystemPropositionJSTreeV1Servlet.class).in(Singleton.class);
        this.serve("/protected/searchsystemlist", new String[0]).with(SearchSystemPropositionJSTreeV1Servlet.class);
    }

    protected Map<String, String> getCasValidationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerUrlPrefix", this.properties.getCasUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("proxyCallbackUrl", this.getCasProxyCallbackUrl());
        params.put("proxyReceptorUrl", this.getCasProxyCallbackPath());
        return params;
    }
}

