/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.servlet.LoginServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.SessionPropertiesServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.MessagesFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.RolesFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.UserFilter;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.common.config.AbstractServletModule;
import org.eurekaclinical.common.servlet.DestroySessionServlet;
import org.eurekaclinical.common.servlet.LogoutServlet;
import org.eurekaclinical.common.servlet.ProxyServlet;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletModule
extends AbstractServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletModule.class);
    private static final String FILTER_PATH = "^/(?!(assets|bower_components)).*";
    private static final String LOGOUT_PATH = "/logout";
    private final WebappProperties properties;

    public ServletModule(WebappProperties inProperties) {
        super((CasEurekaClinicalProperties)inProperties);
        this.properties = inProperties;
    }

    private void setupMessageFilter() {
        this.filterRegex(FILTER_PATH, new String[0]).through(MessagesFilter.class);
    }

    private void setupUserFilter() {
        this.filterRegex(FILTER_PATH, new String[0]).through(UserFilter.class);
    }

    private void setupRolesFilter() {
        this.filterRegex(FILTER_PATH, new String[0]).through(RolesFilter.class);
    }

    protected void setupFilters() {
        this.setupMessageFilter();
        this.setupUserFilter();
        this.setupRolesFilter();
    }

    protected void setupServlets() {
        this.serve("/proxy-resource/*", new String[0]).with(ProxyServlet.class);
        this.bind(SessionPropertiesServlet.class).in(Singleton.class);
        this.serve("/protected/get-session-properties", new String[0]).with(SessionPropertiesServlet.class);
        this.serve("/destroy-session", new String[0]).with(DestroySessionServlet.class);
        this.serve(LOGOUT_PATH, new String[0]).with(LogoutServlet.class);
        this.serve("/protected/login", new String[0]).with(LoginServlet.class);
    }

    protected Map<String, String> getCasValidationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerUrlPrefix", this.properties.getCasUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("proxyCallbackUrl", this.getCasProxyCallbackUrl());
        params.put("proxyReceptorUrl", this.getCasProxyCallbackPath());
        return params;
    }
}

