/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.servlet.SessionScoped;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClient;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.client.WebappRouterTable;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.EurekaClinicalUserProxyClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.ServicesClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalProxyClient;
import org.eurekaclinical.common.comm.clients.RouterTable;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.eurekaclinical.user.client.EurekaClinicalUserProxyClient;

class AppModule
extends AbstractModule {
    private final WebappProperties webappProperties;
    private final EurekaClinicalUserProxyClientProvider userClientProvider;
    private final EtlClientProvider etlClientProvider;
    private final ServicesClientProvider servicesClientProvider;

    AppModule(WebappProperties webappProperties, ServicesClientProvider inServicesClientProvider, EtlClientProvider inEtlClientProvider, EurekaClinicalUserProxyClientProvider inUserClient) {
        assert (webappProperties != null) : "webappProperties cannot be null";
        this.webappProperties = webappProperties;
        this.userClientProvider = inUserClient;
        this.servicesClientProvider = inServicesClientProvider;
        this.etlClientProvider = inEtlClientProvider;
    }

    protected void configure() {
        this.bind(RouterTable.class).to(WebappRouterTable.class);
        this.bind(WebappProperties.class).toInstance((Object)this.webappProperties);
        this.bind(CasEurekaClinicalProperties.class).toInstance((Object)this.webappProperties);
        this.bind(ServicesClient.class).toProvider((Provider)this.servicesClientProvider).in(SessionScoped.class);
        this.bind(EtlClient.class).toProvider((Provider)this.etlClientProvider).in(SessionScoped.class);
        this.bind(EurekaClinicalUserProxyClient.class).toProvider((Provider)this.userClientProvider).in(SessionScoped.class);
        this.bind(AuthorizingEurekaClinicalProxyClient.class).toProvider((Provider)this.userClientProvider).in(SessionScoped.class);
    }
}

