/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClient;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eurekaclinical.user.client.EurekaClinicalUserProxyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionListener
implements HttpSessionListener {
    private Logger LOGGER = LoggerFactory.getLogger(ClientSessionListener.class);
    @Inject
    private Injector injector;

    public void sessionCreated(HttpSessionEvent hse) {
        this.LOGGER.info("Creating session for " + hse.getSession().getServletContext().getContextPath());
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        this.LOGGER.info("Destroying session for " + hse.getSession().getServletContext().getContextPath());
        try {
            ((EurekaClinicalUserProxyClient)this.injector.getInstance(EurekaClinicalUserProxyClient.class)).close();
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        try {
            ((ServicesClient)this.injector.getInstance(ServicesClient.class)).close();
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        try {
            ((EtlClient)this.injector.getInstance(EtlClient.class)).close();
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
    }
}

