/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClient;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.AppModule;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.EurekaClinicalUserClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.ServicesClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.ServletModule;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.eurekaclinical.common.config.ClientSessionListener;
import org.eurekaclinical.common.config.InjectorSupport;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.eurekaclinical.user.client.EurekaClinicalUserClient;

public class WebappListener
extends GuiceServletContextListener {
    private final WebappProperties webappProperties = new WebappProperties();
    private final EurekaClinicalUserClientProvider userClientProvider;
    private final ServicesClientProvider servicesClientProvider = new ServicesClientProvider(this.webappProperties.getServiceUrl());
    private final EtlClientProvider etlClientProvider = new EtlClientProvider(this.webappProperties.getEtlUrl());
    private Injector injector;

    public WebappListener() {
        this.userClientProvider = new EurekaClinicalUserClientProvider(this.webappProperties.getUserServiceUrl());
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        ServletContext servletContext = servletContextEvent.getServletContext();
        servletContext.addListener((EventListener)new ClientSessionListener(EurekaClinicalUserClient.class));
        servletContext.addListener((EventListener)new ClientSessionListener(ServicesClient.class));
        servletContext.addListener((EventListener)new ClientSessionListener(EtlClient.class));
        servletContext.setAttribute("webappProperties", (Object)this.webappProperties);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        servletContextEvent.getServletContext().removeAttribute("webappProperties");
    }

    protected Injector getInjector() {
        this.injector = new InjectorSupport(new Module[]{new AppModule(this.webappProperties, this.servicesClientProvider, this.etlClientProvider, this.userClientProvider), new ServletModule(this.webappProperties)}, (EurekaClinicalProperties)this.webappProperties).getInjector();
        return this.injector;
    }
}

