/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;

public class WebappProperties
extends CasEurekaClinicalProperties {
    public WebappProperties() {
        super("/etc/eureka");
    }

    public String getMajorVersion() {
        return this.getValue("eureka.webapp.version.major");
    }

    public String getMinorVersion() {
        return this.getValue("eureka.webapp.version.minor");
    }

    public String getIncrementalVersion() {
        return this.getValue("eureka.webapp.version.incremental");
    }

    public String getQualifier() {
        return this.getValue("eureka.webapp.version.qualifier");
    }

    public String getBuildNumber() {
        return this.getValue("eureka.webapp.version.buildNumber");
    }

    public String getUrl() {
        return this.getValue("eureka.webapp.url");
    }

    public String getUserWebappUrl() {
        return this.getValue("eurekaclinical.userwebapp.url");
    }

    public String getUserServiceUrl() {
        return this.getValue("eurekaclinical.userservice.url");
    }

    public String getRegistryServiceUrl() {
        return this.getValue("eurekaclinical.registryservice.url");
    }

    public boolean isEphiProhibited() {
        return Boolean.parseBoolean(this.getValue("eureka.webapp.ephiprohibited"));
    }

    public boolean isDemoMode() {
        return Boolean.parseBoolean(this.getValue("eureka.webapp.demomode"));
    }

    public String getUploadDir() {
        return this.getValue("eureka.webapp.uploaddir");
    }

    public String getServiceUrl() {
        return this.getValue("eureka.services.url");
    }

    public String getEtlUrl() {
        return this.getValue("eureka.etl.url");
    }

    public String getCohortsUrl() {
        return this.getValue("eureka.cohorts.url");
    }

    public String getProxyCallbackServer() {
        return this.getValue("eureka.webapp.callbackserver");
    }

    public String getContactEmail() {
        return this.getValue("eureka.webapp.contactemail");
    }

    public boolean isOAuthRegistrationEnabled() {
        return this.isGoogleOAuthRegistrationEnabled() || this.isGitHubOAuthRegistrationEnabled() || this.isTwitterOAuthRegistrationEnabled() || this.isGlobusOAuthRegistrationEnabled();
    }

    public boolean isGoogleOAuthRegistrationEnabled() {
        return this.getGoogleOAuthKey() != null && this.getGoogleOAuthSecret() != null;
    }

    public boolean isGitHubOAuthRegistrationEnabled() {
        return this.getGitHubOAuthKey() != null && this.getGitHubOAuthSecret() != null;
    }

    public boolean isTwitterOAuthRegistrationEnabled() {
        return this.getTwitterOAuthKey() != null && this.getTwitterOAuthSecret() != null;
    }

    public boolean isGlobusOAuthRegistrationEnabled() {
        return this.getGlobusOAuthKey() != null && this.getGlobusOAuthSecret() != null;
    }

    public boolean isLocalAccountRegistrationEnabled() {
        return Boolean.parseBoolean(this.getValue("eureka.webapp.localregistrationenabled"));
    }

    public boolean isRegistrationEnabled() {
        return this.isLocalAccountRegistrationEnabled() || this.isOAuthRegistrationEnabled();
    }

    public String getGoogleOAuthKey() {
        return this.getValue("eureka.webapp.googleoauthkey");
    }

    public String getGoogleOAuthSecret() {
        return this.getValue("eureka.webapp.googleoauthsecret");
    }

    public String getGitHubOAuthKey() {
        return this.getValue("eureka.webapp.githuboauthkey");
    }

    public String getGitHubOAuthSecret() {
        return this.getValue("eureka.webapp.githuboauthsecret");
    }

    public String getTwitterOAuthKey() {
        return this.getValue("eureka.webapp.twitteroauthkey");
    }

    public String getTwitterOAuthSecret() {
        return this.getValue("eureka.webapp.twitteroauthsecret");
    }

    public String getGlobusOAuthKey() {
        return this.getValue("eureka.webapp.globusoauthkey");
    }

    public String getGlobusOAuthSecret() {
        return this.getValue("eureka.webapp.globusoauthsecret");
    }
}

