/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.servlet.SessionScoped;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClient;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.client.WebappRouterTable;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.EurekaClinicalRegistryClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.EurekaClinicalUserClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.ServicesClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.RouterTable;
import org.eurekaclinical.registry.client.EurekaClinicalRegistryClient;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.eurekaclinical.user.client.EurekaClinicalUserClient;

class AppModule
extends AbstractModule {
    private final WebappProperties webappProperties;
    private final EurekaClinicalUserClientProvider userClientProvider;
    private final EtlClientProvider etlClientProvider;
    private final ServicesClientProvider servicesClientProvider;
    private final EurekaClinicalRegistryClientProvider registryClientProvider;

    AppModule(WebappProperties webappProperties, ServicesClientProvider inServicesClientProvider, EtlClientProvider inEtlClientProvider, EurekaClinicalUserClientProvider inUserClient, EurekaClinicalRegistryClientProvider inRegistryClient) {
        assert (webappProperties != null) : "webappProperties cannot be null";
        this.webappProperties = webappProperties;
        this.userClientProvider = inUserClient;
        this.servicesClientProvider = inServicesClientProvider;
        this.etlClientProvider = inEtlClientProvider;
        this.registryClientProvider = inRegistryClient;
    }

    protected void configure() {
        this.bind(RouterTable.class).to(WebappRouterTable.class).in(SessionScoped.class);
        this.bind(WebappProperties.class).toInstance((Object)this.webappProperties);
        this.bind(CasEurekaClinicalProperties.class).toInstance((Object)this.webappProperties);
        this.bind(ServicesClient.class).toProvider((Provider)this.servicesClientProvider).in(SessionScoped.class);
        this.bind(EtlClient.class).toProvider((Provider)this.etlClientProvider).in(SessionScoped.class);
        this.bind(EurekaClinicalUserClient.class).toProvider((Provider)this.userClientProvider).in(SessionScoped.class);
        this.bind(AuthorizingEurekaClinicalClient.class).toProvider((Provider)this.userClientProvider).in(SessionScoped.class);
        this.bind(EurekaClinicalRegistryClient.class).toProvider((Provider)this.registryClientProvider).in(SessionScoped.class);
    }
}

