/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.cohort;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.cohort.DeleteCohortServlet;
import edu.emory.cci.aiw.cvrg.eureka.webapp.authentication.WebappAuthenticationSupport;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCohortServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteCohortServlet.class);
    private final ServicesClient servicesClient;
    private final WebappAuthenticationSupport authenticationSupport;

    @Inject
    public DeleteCohortServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.authenticationSupport = new WebappAuthenticationSupport();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug("DeleteCohortServlet");
        String propKey = req.getParameter("key");
        try {
            User user = this.authenticationSupport.getMe(req);
            this.servicesClient.deleteDestination(user.getId(), propKey);
        }
        catch (ClientException e) {
            resp.setContentType("text/plain");
            try {
                switch (1.$SwitchMap$com$sun$jersey$api$client$ClientResponse$Status[e.getResponseStatus().ordinal()]) {
                    case 1: {
                        this.authenticationSupport.needsToLogin(req, resp);
                        break;
                    }
                    case 2: {
                        resp.setStatus(500);
                        LOGGER.error("Error deleting cohort " + propKey, (Throwable)e);
                        ResourceBundle messages = (ResourceBundle)req.getAttribute("messages");
                        String msg = messages.getString("deleteCohort.error.internalServerError");
                        resp.getWriter().write(msg);
                        break;
                    }
                    default: {
                        LOGGER.debug("Deleting cohort {} failed", (Object)propKey, (Object)e);
                        resp.setStatus(400);
                        resp.getWriter().write(e.getMessage());
                        break;
                    }
                }
            }
            catch (IOException ex) {
                resp.setStatus(500);
                LOGGER.error("IO Error writing response status", (Throwable)ex);
                try {
                    resp.getWriter().write("Internal server error.");
                }
                catch (IOException ignore) {
                    LOGGER.error("Error writing the internal server error message: {}", (Throwable)ignore);
                }
            }
        }
    }
}

