/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.AbstractModule;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.client.ServiceClientRouterTable;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import edu.emory.cci.aiw.cvrg.eureka.webapp.provider.ServicesClientProvider;
import org.eurekaclinical.common.comm.clients.RouterTable;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.eurekaclinical.user.client.EurekaClinicalUserProxyClient;

class AppModule
extends AbstractModule {
    private final WebappProperties webappProperties;
    private final EurekaClinicalUserProxyClient userClient;

    AppModule(WebappProperties webappProperties) {
        assert (webappProperties != null) : "webappProperties cannot be null";
        this.webappProperties = webappProperties;
        this.userClient = new EurekaClinicalUserProxyClient(this.webappProperties.getUserServiceUrl());
    }

    protected void configure() {
        this.bind(RouterTable.class).to(ServiceClientRouterTable.class);
        this.bind(WebappProperties.class).toInstance((Object)this.webappProperties);
        this.bind(CasEurekaClinicalProperties.class).toInstance((Object)this.webappProperties);
        this.bind(ServicesClient.class).toProvider(ServicesClientProvider.class);
        this.bind(EurekaClinicalUserProxyClient.class).toInstance((Object)this.userClient);
    }
}

