/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.EtlClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.AppModule;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.EurekaClinicalRegistryClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.EurekaClinicalUserClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.ServicesClientProvider;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.eurekaclinical.common.config.ApiGatewayServletModule;
import org.eurekaclinical.common.config.ClientSessionListener;
import org.eurekaclinical.common.config.InjectorSupport;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;

public class WebappListener
extends GuiceServletContextListener {
    private final WebappProperties webappProperties = new WebappProperties();
    private final EurekaClinicalUserClientProvider userClientProvider;
    private final ServicesClientProvider servicesClientProvider = new ServicesClientProvider(this.webappProperties.getServiceUrl());
    private final EtlClientProvider etlClientProvider = new EtlClientProvider(this.webappProperties.getEtlUrl());
    private final EurekaClinicalRegistryClientProvider registryClientProvider;
    private Injector injector;

    public WebappListener() {
        this.userClientProvider = new EurekaClinicalUserClientProvider(this.webappProperties.getUserServiceUrl());
        this.registryClientProvider = new EurekaClinicalRegistryClientProvider(this.webappProperties.getRegistryServiceUrl());
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        ServletContext servletContext = servletContextEvent.getServletContext();
        servletContext.addListener((EventListener)new ClientSessionListener());
        servletContext.setAttribute("webappProperties", (Object)this.webappProperties);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        servletContextEvent.getServletContext().removeAttribute("webappProperties");
    }

    protected Injector getInjector() {
        this.injector = new InjectorSupport(new Module[]{new AppModule(this.webappProperties, this.servicesClientProvider, this.etlClientProvider, this.userClientProvider, this.registryClientProvider), new ApiGatewayServletModule((CasEurekaClinicalProperties)this.webappProperties)}, (EurekaClinicalProperties)this.webappProperties).getInjector();
        return this.injector;
    }
}

