/*
 * #%L
 * Eureka WebApp
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * This program is dual licensed under the Apache 2 and GPLv3 licenses.
 * 
 * Apache License, Version 2.0:
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * GNU General Public License version 3:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.worker.admin;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.Role;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.ServletWorker;

public class ListUsersWorker implements ServletWorker {

	private final ServicesClient servicesClient;

	public ListUsersWorker (ServicesClient inServicesClient) {
		this.servicesClient = inServicesClient;
	}
	@Override
	public void execute(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {

		List<User> users;
		try {
			users = this.servicesClient.getUsers();
		} catch (ClientException ex) {
			throw new ServletException("Error getting user list", ex);
		}
		List<Role> roles;
		try {
			roles = this.servicesClient.getRoles();
		} catch (ClientException ex) {
			throw new ServletException("Error getting role list", ex);
		}
		Map<Long, Role> rolesMap = new HashMap<>();
		for (Role role : roles) {
			rolesMap.put(role.getId(), role);
		}

		// Set sort order to show the inactive users first.
		Collections.sort(users, new Comparator<User>() {
			@Override
			public int compare(User user1, User user2) {
				int u1 = 0;
				int u2 = 0;
				if (user1.isActive()) {
					u1 = 1;
				}
				if (user2.isActive()) {
					u2 = 1;
				}

				return u1 - u2;
			}
		});
		req.setAttribute("users", users);
		req.setAttribute("roles", rolesMap);
		req.getRequestDispatcher("/protected/admin.jsp").forward(req, resp);
	}
}
