package edu.emory.cci.aiw.cvrg.eureka.common.comm;

/*
 * #%L
 * Eureka Common
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * This program is dual licensed under the Apache 2 and GPLv3 licenses.
 * 
 * Apache License, Version 2.0:
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * GNU General Public License version 3:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobEvent;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.JobStatus;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 * @author Andrew Post
 */
public class Job {

	private Long id;
	/**
	 * The initial timestamp when the job was started.
	 */
	private Date timestamp;
	/**
	 * The unique identifier of the configuration to use for this job.
	 */
	private String sourceConfigId;
	/**
	 * The unique identifier of the configuration to use for this job.
	 */
	private String destinationId;
	private String username;
	private JobStatus status;
	private List<JobEvent> jobEvents;
	
	private List<Link> links;
	private boolean getStatisticsSupported;         

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Date getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	public String getSourceConfigId() {
		return sourceConfigId;
	}

	public void setSourceConfigId(String sourceConfigId) {
		this.sourceConfigId = sourceConfigId;
	}

	public String getDestinationId() {
		return destinationId;
	}

	public void setDestinationId(String destinationId) {
		this.destinationId = destinationId;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public JobStatus getStatus() {
		return status;
	}

	public void setStatus(JobStatus status) {
		this.status = status;
	}

	/**
	 * Gets job events, assumed in order of occurrence.
	 * @return a {@link List} of job events.
	 */
	public List<JobEvent> getJobEvents() {
		return jobEvents;
	}

	/**
	 * Sets job events, assumed in order of occurrence.
	 * @param jobEvents a {@link List} of job events.
	 */
	public void setJobEvents(List<JobEvent> jobEvents) {
		this.jobEvents = jobEvents;
	}

	public List<Link> getLinks() {
		return links;
	}

	public void setLinks(List<Link> links) {
		this.links = links;
	}

	public boolean isGetStatisticsSupported() {
		return getStatisticsSupported;
	}

	public void setGetStatisticsSupported(boolean getStatisticsSupported) {
		this.getStatisticsSupported = getStatisticsSupported;
	}      
	/**
	 * Return a list of messages generated by the job.
	 *
	 * @return The list of messages.
	 */
	public List<String> messages() {
		final List<String> messages = new ArrayList<>();
		for (JobEvent event : this.jobEvents) {
			final String message = event.getMessage();
			if (message != null) {
				messages.add(message);
			}
		}
		return messages;
	}

	public JobListRow toJobListRow() {
		JobListRow jobStatus = new JobListRow();
		jobStatus.setStatus(getStatus());
		jobStatus.setMessages(messages());
		jobStatus.setStartedDate(getTimestamp());
                
		jobStatus.setLinks(getLinks());
		jobStatus.setGetStatisticsSupported(isGetStatisticsSupported());
		jobStatus.setJobId(getId());
                
		jobStatus.setSourceConfigId(getSourceConfigId());
		jobStatus.setDestinationId(getDestinationId());
                
		if (this.jobEvents != null) {
			for (JobEvent jobEvent : this.jobEvents) {
				if (jobEvent.getStatus() == JobStatus.COMPLETED
						|| jobEvent.getStatus() == JobStatus.FAILED) {
					jobStatus.setFinishedDate(jobEvent.getTimeStamp());
					break;
				}
			}
		}
		return jobStatus;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
