/*
 * #%L
 * Eureka Services
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * This program is dual licensed under the Apache 2 and GPLv3 licenses.
 * 
 * Apache License, Version 2.0:
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * GNU General Public License version 3:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.Phenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.common.exception.PhenotypeHandlingException;

/**
 * Translates a UI phenotype into a proposition as understood by the service
 * layer data model.
 * 
 * @param <P>
 *            The phenotype type to translate from, a subclass of
 *            {@link Phenotype}..
 * @param <PE>
 *            The proposition type to translate to, an implementation of
 *            {@link PhenotypeEntity}.
 */
public interface PropositionTranslator<P extends Phenotype, PE extends PhenotypeEntity> {

	/**
	 * Translates the given phenotype to a proposition understood by the
	 * services layer data model. The inverse of {@link #translateFromProposition(PhenotypeEntity)}
	 * .
	 * 
	 * @param phenotype
	 *            the phenotype to translate from
	 * @return A {@link PhenotypeEntity} equivalent to the phenotype.
	 * @throws PhenotypeHandlingException if an error occurred retrieving
	 * proposition definitions.
	 */
	PE translateFromPhenotype(P phenotype) throws PhenotypeHandlingException;

	/**
	 * Translates the given proposition entity into a phenotype understood by
	 * the webapp layer. The inverse of {@link #translateFromPhenotype(Phenotype)}.
	 * 
	 * @param proposition
	 *            the proposition to translate from
	 * @return A {@link Phenotype} equivalent to the proposition.
	 */
	P translateFromProposition(PE proposition);
}
