package edu.emory.cci.aiw.cvrg.eureka.etl.dest;

/*-
 * #%L
 * Eureka Protempa ETL
 * %%
 * Copyright (C) 2012 - 2016 Emory University
 * %%
 * This program is dual licensed under the Apache 2 and GPLv3 licenses.
 * 
 * Apache License, Version 2.0:
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * GNU General Public License version 3:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.text.ParseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 *
 * @author Andrew Post
 */
public class TableColumnSpecFormatTest {

	private TableColumnSpecFormat format;

	@Before
	public void setUp() {
		this.format = new TableColumnSpecFormat("FOO");
	}

	@Test
	public void testParseObjectNull() throws ParseException {
		Object parseObject = this.format.parseObject("[PatientDetails Constant 0].patientId$NOMINALVALUE");
		Assert.assertNotNull(parseObject);
	}

	@Test
	public void testParseObjectType() throws ParseException {
		Object parseObject = this.format.parseObject("[PatientDetails Constant 0].patientId$NOMINALVALUE");
		if (parseObject != null) {
			Assert.assertEquals(TableColumnSpecWrapper.class.getName(), parseObject.getClass().getName());
		}
	}
	
	@Test
	public void testParseObjectPropId() throws ParseException {
		Object parseObject = this.format.parseObject("[PatientDetails Constant 0].patientId$NOMINALVALUE");
		if (parseObject != null && parseObject instanceof TableColumnSpecWrapper) {
			Assert.assertEquals("PatientDetails", ((TableColumnSpecWrapper) parseObject).getPropId());
		}
	}
	
	@Test
	public void testParseObjectPropIdWithColon() throws ParseException {
		Object parseObject = this.format.parseObject("[ICD9:Diagnoses Event 0].code$NOMINALVALUE");
		if (parseObject != null && parseObject instanceof TableColumnSpecWrapper) {
			Assert.assertEquals("ICD9:Diagnoses", ((TableColumnSpecWrapper) parseObject).getPropId());
		}
	}

}
