/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.admin.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;

@Singleton
public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final URI[] EMPTY_URI_ARRAY = new URI[0];
    private URI[] allowedWebClientURIs;
    private final CasEurekaClinicalProperties properties;

    @Inject
    public LoginServlet(CasEurekaClinicalProperties inProperties) {
        this.properties = inProperties;
    }

    public void init(ServletConfig config) throws ServletException {
        List webClientUrls = this.properties.getAllowedWebClientUrls();
        if (webClientUrls != null) {
            this.allowedWebClientURIs = new URI[webClientUrls.size()];
            for (int i = 0; i < this.allowedWebClientURIs.length; ++i) {
                this.allowedWebClientURIs[i] = URI.create((String)webClientUrls.get(i));
            }
        } else {
            this.allowedWebClientURIs = EMPTY_URI_ARRAY;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String webClient = req.getParameter("webclient");
        System.out.println("==============IN LOGIN SERVLET===============");
        System.out.println("webclient=" + webClient);
        if (webClient != null && this.isAllowed(URI.create(webClient))) {
            System.out.println("Redirecting to: " + webClient);
            resp.setHeader("loggedIn", "true");
            resp.sendRedirect(webClient);
        }
    }

    private boolean isAllowed(URI actualWebClient) {
        if (this.allowedWebClientURIs.length == 0) {
            System.out.println("NO allowedWebClientURIs");
            return true;
        }
        for (URI allowedWebClientURI : this.allowedWebClientURIs) {
            System.out.println("ALLOWED: " + allowedWebClientURI.toString());
            if (!allowedWebClientURI.equals(actualWebClient)) continue;
            return true;
        }
        return false;
    }
}

