/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.admin.webapp.config;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import java.util.EventListener;
import javax.servlet.ServletContextEvent;
import org.eurekaclinical.admin.webapp.config.AppModule;
import org.eurekaclinical.admin.webapp.config.ServletModule;
import org.eurekaclinical.admin.webapp.props.AdminWebappProperties;
import org.eurekaclinical.common.config.ClientSessionListener;
import org.eurekaclinical.common.config.InjectorSupport;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminWebappListener
extends GuiceServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminWebappListener.class);
    private final AdminWebappProperties adminWebappProperties = new AdminWebappProperties();
    private Injector injector;

    public AdminWebappListener() {
        LOGGER.info("Got Admin Properties");
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        servletContextEvent.getServletContext().addListener((EventListener)new ClientSessionListener());
        servletContextEvent.getServletContext().setAttribute("adminWebAppProperties", (Object)this.adminWebappProperties);
        LOGGER.info("In AdminWebappListener: Initialized context");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        servletContextEvent.getServletContext().removeAttribute("adminWebAppProperties");
    }

    protected Injector getInjector() {
        this.injector = new InjectorSupport(new Module[]{new AppModule(this.adminWebappProperties), new ServletModule(this.adminWebappProperties)}, (EurekaClinicalProperties)this.adminWebappProperties).getInjector();
        return this.injector;
    }
}

