/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.admin.webapp.config;

import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.admin.servlet.ProxyServlet;
import org.eurekaclinical.admin.webapp.props.AdminWebappProperties;
import org.eurekaclinical.common.config.AbstractAuthorizingServletModule;
import org.eurekaclinical.common.servlet.DestroySessionServlet;
import org.eurekaclinical.common.servlet.LoginServlet;
import org.eurekaclinical.common.servlet.LogoutServlet;
import org.eurekaclinical.common.servlet.PostMessageLoginServlet;
import org.eurekaclinical.common.servlet.SessionPropertiesServlet;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletModule
extends AbstractAuthorizingServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletModule.class);
    private final AdminWebappProperties properties;

    protected ServletModule(AdminWebappProperties inProperties) {
        super((CasEurekaClinicalProperties)inProperties);
        this.properties = inProperties;
    }

    protected void setupServlets() {
        LOGGER.info("Setting up servlets in ServletModule");
        LOGGER.info("CAS LOGIN " + this.properties.getCasLoginUrl());
        LOGGER.info("CAS LOGOUT " + this.properties.getCasLogoutUrl());
        LOGGER.info("CAS URL " + this.properties.getCasUrl());
        LOGGER.info("Config dir " + this.properties.getConfigDir());
        LOGGER.info("URL " + this.properties.getUrl());
        LOGGER.info("User Srvc URL " + this.properties.getUserServiceUrl());
        LOGGER.info("Allowed web clients " + this.properties.getAllowedWebClientUrls().toString());
        this.serve("/login*", new String[0]).with(LoginServlet.class);
        this.serve("/proxy-resource/*", new String[0]).with(ProxyServlet.class);
        this.serve("/logout", new String[0]).with(LogoutServlet.class);
        this.serve("/destroy-session", new String[0]).with(DestroySessionServlet.class);
        this.serve("/get-session-properties", new String[0]).with(SessionPropertiesServlet.class);
        this.serve("/get-session", new String[0]).with(PostMessageLoginServlet.class);
    }

    protected Map<String, String> getCasValidationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerUrlPrefix", this.properties.getCasUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("proxyCallbackUrl", this.getCasProxyCallbackUrl());
        params.put("proxyReceptorUrl", this.getCasProxyCallbackPath());
        return params;
    }
}

