/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.admin.webapp.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.servlet.SessionScoped;
import org.eurekaclinical.admin.client.EurekaClinicalAdminClient;
import org.eurekaclinical.admin.webapp.clients.ServiceClientRouterTable;
import org.eurekaclinical.admin.webapp.config.EurekaClinicalAdminClientProvider;
import org.eurekaclinical.admin.webapp.config.EurekaClinicalProtempaClientProvider;
import org.eurekaclinical.admin.webapp.config.EurekaClinicalRegistryClientProvider;
import org.eurekaclinical.admin.webapp.config.EurekaClinicalUserAgreementClientProvider;
import org.eurekaclinical.admin.webapp.props.AdminWebappProperties;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.RouterTable;
import org.eurekaclinical.protempa.client.EurekaClinicalProtempaClient;
import org.eurekaclinical.registry.client.EurekaClinicalRegistryClient;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.eurekaclinical.useragreement.client.EurekaClinicalUserAgreementClient;

public class AppModule
extends AbstractModule {
    private final AdminWebappProperties adminWebappProperties;
    private final EurekaClinicalAdminClientProvider clientProvider;
    private final EurekaClinicalRegistryClientProvider registryClientProvider;
    private final EurekaClinicalUserAgreementClientProvider userAgreementClientProvider;
    private final EurekaClinicalProtempaClientProvider protempaClientProvider;

    AppModule(AdminWebappProperties adminWebappProperties) {
        this.adminWebappProperties = adminWebappProperties;
        this.clientProvider = new EurekaClinicalAdminClientProvider(adminWebappProperties.getUserServiceUrl());
        this.userAgreementClientProvider = new EurekaClinicalUserAgreementClientProvider(adminWebappProperties.getUserAgreementServiceUrl());
        this.registryClientProvider = new EurekaClinicalRegistryClientProvider(adminWebappProperties.getRegistryServiceUrl());
        this.protempaClientProvider = new EurekaClinicalProtempaClientProvider(adminWebappProperties.getProtempaServiceUrl());
    }

    protected void configure() {
        this.bind(RouterTable.class).to(ServiceClientRouterTable.class);
        this.bind(AuthorizingEurekaClinicalClient.class).toProvider((Provider)this.clientProvider).in(SessionScoped.class);
        this.bind(EurekaClinicalAdminClient.class).toProvider((Provider)this.clientProvider).in(SessionScoped.class);
        this.bind(EurekaClinicalRegistryClient.class).toProvider((Provider)this.registryClientProvider).in(SessionScoped.class);
        this.bind(EurekaClinicalUserAgreementClient.class).toProvider((Provider)this.userAgreementClientProvider).in(SessionScoped.class);
        this.bind(AdminWebappProperties.class).toInstance((Object)this.adminWebappProperties);
        this.bind(CasEurekaClinicalProperties.class).toInstance((Object)this.adminWebappProperties);
        this.bind(EurekaClinicalProtempaClient.class).toProvider((Provider)this.protempaClientProvider).in(SessionScoped.class);
    }
}

