/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.AbstractConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.CategorizationConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PhenotypeConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import java.util.ArrayList;
import java.util.List;
import org.protempa.ConstantDefinition;
import org.protempa.EventDefinition;
import org.protempa.GapFunction;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.PrimitiveParameterDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.SequentialTemporalPatternDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.SliceDefinition;

public final class CategorizationConverter
extends AbstractConverter
implements PropositionDefinitionConverter<CategoryEntity, PropositionDefinition> {
    private PropositionDefinitionConverterVisitor converterVisitor;
    private PropositionDefinition primary;
    private String primaryPropId;
    private final PhenotypeConversionSupport conversionSupport = new PhenotypeConversionSupport();

    public PropositionDefinition getPrimaryPropositionDefinition() {
        return this.primary;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropId;
    }

    public void setConverterVisitor(PropositionDefinitionConverterVisitor inVisitor) {
        this.converterVisitor = inVisitor;
    }

    public List<PropositionDefinition> convert(CategoryEntity category) {
        String id;
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        this.primaryPropId = id = this.conversionSupport.toPropositionId((PhenotypeEntity)category);
        if (this.converterVisitor.addPropositionId(id)) {
            EventDefinition primary;
            ArrayList<String> inverseIsADefs = new ArrayList<String>();
            ArrayList inverseIsADefsIncludingSecondaries = new ArrayList();
            for (PhenotypeEntity e : category.getMembers()) {
                e.accept((PhenotypeEntityVisitor)this.converterVisitor);
                inverseIsADefsIncludingSecondaries.addAll(this.converterVisitor.getPropositionDefinitions());
                String primaryPropositionId = this.converterVisitor.getPrimaryPropositionId();
                inverseIsADefs.add(primaryPropositionId);
            }
            result.addAll(inverseIsADefsIncludingSecondaries);
            String[] inverseIsA = inverseIsADefs.toArray(new String[inverseIsADefs.size()]);
            switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$services$entity$CategoryEntity$CategoryType[category.getCategoryType().ordinal()]) {
                case 1: {
                    EventDefinition event = new EventDefinition(id);
                    event.setDescription(category.getDescription());
                    event.setDisplayName(category.getDisplayName());
                    event.setInverseIsA(inverseIsA);
                    event.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = event;
                    break;
                }
                case 2: {
                    ConstantDefinition constant = new ConstantDefinition(id);
                    constant.setDescription(category.getDescription());
                    constant.setDisplayName(category.getDisplayName());
                    constant.setInverseIsA(inverseIsA);
                    constant.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = constant;
                    break;
                }
                case 3: {
                    PrimitiveParameterDefinition primParam = new PrimitiveParameterDefinition(id);
                    primParam.setDescription(category.getDescription());
                    primParam.setDisplayName(category.getDisplayName());
                    primParam.setInverseIsA(inverseIsA);
                    primParam.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = primParam;
                    break;
                }
                case 4: {
                    HighLevelAbstractionDefinition hla = new HighLevelAbstractionDefinition(id);
                    hla.setDescription(category.getDescription());
                    hla.setDisplayName(category.getDisplayName());
                    hla.setInverseIsA(inverseIsA);
                    hla.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                    hla.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = hla;
                    break;
                }
                case 5: {
                    SequentialTemporalPatternDefinition stpa = new SequentialTemporalPatternDefinition(id);
                    stpa.setDescription(category.getDescription());
                    stpa.setDisplayName(category.getDisplayName());
                    stpa.setInverseIsA(inverseIsA);
                    stpa.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                    stpa.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = stpa;
                    break;
                }
                case 6: {
                    SliceDefinition sla = new SliceDefinition(id);
                    sla.setDescription(category.getDescription());
                    sla.setDisplayName(category.getDisplayName());
                    sla.setInverseIsA(inverseIsA);
                    sla.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = sla;
                    break;
                }
                case 7: 
                case 8: {
                    HighLevelAbstractionDefinition llad = new HighLevelAbstractionDefinition(id);
                    llad.setDescription(category.getDescription());
                    llad.setDisplayName(category.getDisplayName());
                    llad.setInverseIsA(inverseIsA);
                    llad.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                    llad.setSourceId(this.sourceId((PhenotypeEntity)category));
                    primary = llad;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid category type " + category.getCategoryType()));
                }
            }
            result.add((PropositionDefinition)primary);
            this.primary = primary;
        }
        return result;
    }
}

