/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.CohortConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.util.AbstractNodeVisitor;
import org.eurekaclinical.eureka.client.comm.BinaryOperator;
import org.eurekaclinical.eureka.client.comm.Literal;
import org.eurekaclinical.eureka.client.comm.Node;
import org.eurekaclinical.eureka.client.comm.NodeVisitor;
import org.eurekaclinical.eureka.client.comm.UnaryOperator;

class EtlNodeToServicesNodeVisitor
extends AbstractNodeVisitor {
    private Node node;
    private final CohortConversionSupport conversionSupport = new CohortConversionSupport();

    public void visit(Literal literal) {
        Literal servicesLiteral = new Literal();
        servicesLiteral.setId(literal.getId());
        servicesLiteral.setName(this.conversionSupport.toPhenotypeKey(literal.getName()));
        servicesLiteral.setStart(literal.getStart());
        servicesLiteral.setFinish(literal.getFinish());
        this.node = servicesLiteral;
    }

    public void visit(UnaryOperator unaryOperator) {
        UnaryOperator servicesUO = new UnaryOperator();
        servicesUO.setId(unaryOperator.getId());
        EtlNodeToServicesNodeVisitor v = new EtlNodeToServicesNodeVisitor();
        unaryOperator.getNode().accept((NodeVisitor)v);
        servicesUO.setNode(v.getNode());
        servicesUO.setOp(unaryOperator.getOp());
        this.node = servicesUO;
    }

    public void visit(BinaryOperator binaryOperator) {
        BinaryOperator servicesBO = new BinaryOperator();
        servicesBO.setId(binaryOperator.getId());
        servicesBO.setOp(binaryOperator.getOp());
        EtlNodeToServicesNodeVisitor v = new EtlNodeToServicesNodeVisitor();
        binaryOperator.getLeftNode().accept((NodeVisitor)v);
        servicesBO.setLeftNode(v.getNode());
        binaryOperator.getRightNode().accept((NodeVisitor)v);
        servicesBO.setRightNode(v.getNode());
        this.node = servicesBO;
    }

    public Node getNode() {
        return this.node;
    }
}

