/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.AbstractConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.FrequencyConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PhenotypeConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import java.util.ArrayList;
import java.util.List;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.GapFunction;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.SliceDefinition;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Unit;

public final class FrequencyNotValueThresholdConverter
extends AbstractConverter
implements FrequencyConverter {
    private PropositionDefinitionConverterVisitor converterVisitor;
    private HighLevelAbstractionDefinition primary;
    private String primaryPropId;
    private final PhenotypeConversionSupport conversionSupport = new PhenotypeConversionSupport();

    public HighLevelAbstractionDefinition getPrimaryPropositionDefinition() {
        return this.primary;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropId;
    }

    public void setVisitor(PropositionDefinitionConverterVisitor inVisitor) {
        this.converterVisitor = inVisitor;
    }

    public List<PropositionDefinition> convert(FrequencyEntity entity) {
        String propId;
        if (entity.getAbstractedFrom() == null) {
            throw new IllegalArgumentException("entity cannot have a null abstractedFrom field");
        }
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        this.primaryPropId = propId = this.conversionSupport.toPropositionId((PhenotypeEntity)entity);
        if (this.converterVisitor.addPropositionId(propId)) {
            ExtendedPhenotype extendedProposition = entity.getExtendedProposition();
            HighLevelAbstractionDefinition p = new HighLevelAbstractionDefinition(propId);
            p.setDisplayName(entity.getDisplayName());
            p.setDescription(entity.getDescription());
            p.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
            if (entity.getFrequencyType().getName().equals("at least")) {
                int i;
                PhenotypeEntity abstractedFrom = extendedProposition.getPhenotypeEntity();
                abstractedFrom.accept((PhenotypeEntityVisitor)this.converterVisitor);
                result.addAll(this.converterVisitor.getPropositionDefinitions());
                TemporalExtendedPropositionDefinition[] tepds = new TemporalExtendedPropositionDefinition[entity.getCount().intValue()];
                for (i = 0; i < entity.getCount(); ++i) {
                    TemporalExtendedPropositionDefinition tepd;
                    tepds[i] = tepd = ConversionUtil.buildExtendedPropositionDefinition((ExtendedPhenotype)extendedProposition);
                    p.add((ExtendedPropositionDefinition)tepd);
                }
                if (tepds.length > 1) {
                    for (i = 0; i < tepds.length - 1; ++i) {
                        Relation rel = new Relation(null, null, null, null, null, null, null, null, entity.getWithinAtLeast(), (Unit)ConversionUtil.unit((TimeUnit)entity.getWithinAtLeastUnits()), entity.getWithinAtMost(), (Unit)ConversionUtil.unit((TimeUnit)entity.getWithinAtMostUnits()), null, null, null, null);
                        p.setRelation(tepds[i], tepds[i + 1], rel);
                    }
                } else {
                    p.setRelation(tepds[0], tepds[0], new Relation());
                }
            } else if (entity.getFrequencyType().getName().equals("first")) {
                String wrapperPropId = entity.getKey() + "_SUB";
                SliceDefinition sp = new SliceDefinition(wrapperPropId);
                sp.setDisplayName(entity.getDisplayName());
                sp.setDescription(entity.getDescription());
                PhenotypeEntity abstractedFrom = extendedProposition.getPhenotypeEntity();
                abstractedFrom.accept((PhenotypeEntityVisitor)this.converterVisitor);
                result.addAll(this.converterVisitor.getPropositionDefinitions());
                sp.setMergedInterval(true);
                sp.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                TemporalExtendedPropositionDefinition tepd = ConversionUtil.buildExtendedPropositionDefinition((ExtendedPhenotype)extendedProposition);
                sp.add(tepd);
                sp.setMinIndex(0);
                sp.setMaxIndex(entity.getCount().intValue());
                sp.setSourceId(this.sourceId((PhenotypeEntity)entity));
                TemporalExtendedPropositionDefinition tepds = new TemporalExtendedPropositionDefinition(wrapperPropId);
                p.add((ExtendedPropositionDefinition)tepds);
                p.setRelation(tepds, tepds, new Relation());
                result.add((PropositionDefinition)sp);
            } else {
                throw new IllegalStateException("invalid frequency type: " + entity.getFrequencyType().getName());
            }
            p.setSourceId(this.sourceId((PhenotypeEntity)entity));
            this.primary = p;
            result.add((PropositionDefinition)p);
        }
        return result;
    }
}

