/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.CategorizationConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.FrequencyNotValueThresholdConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.FrequencyValueThresholdConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.SequenceConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.SystemPropositionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ValueThresholdsCompoundLowLevelAbstractionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ValueThresholdsLowLevelAbstractionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SequenceEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SystemProposition;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdGroupEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protempa.PropositionDefinition;

public final class PropositionDefinitionConverterVisitor
implements PhenotypeEntityVisitor {
    private List<PropositionDefinition> propositionDefinitions;
    private final Set<String> propIds;
    private PropositionDefinition primaryProposition;
    private String primaryPropositionId;
    private final SystemPropositionConverter systemPropositionConverter;
    private final CategorizationConverter categorizationConverter;
    private final SequenceConverter sequenceConverter;
    private final ValueThresholdsLowLevelAbstractionConverter valueThresholdsLowLevelAbstractionConverter;
    private final ValueThresholdsCompoundLowLevelAbstractionConverter valueThresholdsCompoundLowLevelAbstractionConverter;
    private final FrequencyNotValueThresholdConverter frequencyNotValueThresholdConverter;
    private final FrequencyValueThresholdConverter frequencyValueThresholdConverter;

    @Inject
    public PropositionDefinitionConverterVisitor(SystemPropositionConverter inSystemPropositionConverter, CategorizationConverter inCategorizationConverter, SequenceConverter inSequenceConverter, ValueThresholdsLowLevelAbstractionConverter inValueThresholdsLowLevelAbstractionConverter, ValueThresholdsCompoundLowLevelAbstractionConverter inValueThresholdsCompoundLowLevelAbstractionConverter, FrequencyNotValueThresholdConverter inFrequencySliceAbstractionConverter, FrequencyValueThresholdConverter inFrequencyHighLevelAbstractionConverter) {
        this.systemPropositionConverter = inSystemPropositionConverter;
        this.categorizationConverter = inCategorizationConverter;
        this.categorizationConverter.setConverterVisitor(this);
        this.sequenceConverter = inSequenceConverter;
        this.sequenceConverter.setConverterVisitor(this);
        this.valueThresholdsLowLevelAbstractionConverter = inValueThresholdsLowLevelAbstractionConverter;
        this.valueThresholdsLowLevelAbstractionConverter.setConverterVisitor(this);
        this.valueThresholdsCompoundLowLevelAbstractionConverter = inValueThresholdsCompoundLowLevelAbstractionConverter;
        this.valueThresholdsCompoundLowLevelAbstractionConverter.setConverterVisitor(this);
        this.frequencyNotValueThresholdConverter = inFrequencySliceAbstractionConverter;
        this.frequencyNotValueThresholdConverter.setVisitor(this);
        this.frequencyValueThresholdConverter = inFrequencyHighLevelAbstractionConverter;
        this.frequencyValueThresholdConverter.setConverterVisitor(this);
        this.propIds = new HashSet();
    }

    public Collection<PropositionDefinition> getPropositionDefinitions() {
        return this.propositionDefinitions;
    }

    public PropositionDefinition getPrimaryProposition() {
        return this.primaryProposition;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropositionId;
    }

    public boolean addPropositionId(String propId) {
        return this.propIds.add(propId);
    }

    public void visit(SystemProposition entity) {
        this.propositionDefinitions = Collections.emptyList();
        this.propositionDefinitions = this.systemPropositionConverter.convert(entity);
        this.primaryProposition = this.systemPropositionConverter.getPrimaryPropositionDefinition();
        this.primaryPropositionId = this.systemPropositionConverter.getPrimaryPropositionId();
    }

    public void visit(CategoryEntity entity) {
        this.propositionDefinitions = this.categorizationConverter.convert(entity);
        this.primaryProposition = this.categorizationConverter.getPrimaryPropositionDefinition();
        this.primaryPropositionId = this.categorizationConverter.getPrimaryPropositionId();
    }

    public void visit(SequenceEntity entity) {
        this.propositionDefinitions = this.sequenceConverter.convert(entity);
        this.primaryProposition = this.sequenceConverter.getPrimaryPropositionDefinition();
        this.primaryPropositionId = this.sequenceConverter.getPrimaryPropositionId();
    }

    public void visit(ValueThresholdGroupEntity entity) {
        if (entity.getValueThresholds() != null && entity.getValueThresholds().size() > 1) {
            this.propositionDefinitions = this.valueThresholdsCompoundLowLevelAbstractionConverter.convert(entity);
            this.primaryProposition = this.valueThresholdsCompoundLowLevelAbstractionConverter.getPrimaryPropositionDefinition();
            this.primaryPropositionId = this.valueThresholdsCompoundLowLevelAbstractionConverter.getPrimaryPropositionId();
        } else {
            this.propositionDefinitions = this.valueThresholdsLowLevelAbstractionConverter.convert(entity);
            this.primaryProposition = this.valueThresholdsLowLevelAbstractionConverter.getPrimaryPropositionDefinition();
            this.primaryPropositionId = this.valueThresholdsLowLevelAbstractionConverter.getPrimaryPropositionId();
        }
    }

    public void visit(FrequencyEntity entity) {
        if (entity.getAbstractedFrom() instanceof ValueThresholdGroupEntity) {
            this.propositionDefinitions = this.frequencyValueThresholdConverter.convert(entity);
            this.primaryProposition = this.frequencyValueThresholdConverter.getPrimaryPropositionDefinition();
            this.primaryPropositionId = this.frequencyValueThresholdConverter.getPrimaryPropositionId();
        } else {
            this.propositionDefinitions = this.frequencyNotValueThresholdConverter.convert(entity);
            this.primaryProposition = this.frequencyNotValueThresholdConverter.getPrimaryPropositionDefinition();
            this.primaryPropositionId = this.frequencyNotValueThresholdConverter.getPrimaryPropositionId();
        }
    }
}

