/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.AbstractConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SequenceEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.GapFunction;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPatternOffset;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Unit;

final class SequenceConverter
extends AbstractConverter
implements PropositionDefinitionConverter<SequenceEntity, HighLevelAbstractionDefinition> {
    private PropositionDefinitionConverterVisitor converterVisitor;
    private HighLevelAbstractionDefinition primary;
    private String primaryPropId;
    private final Map<Long, TemporalExtendedPropositionDefinition> extendedProps = new HashMap();

    public HighLevelAbstractionDefinition getPrimaryPropositionDefinition() {
        return this.primary;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropId;
    }

    public void setConverterVisitor(PropositionDefinitionConverterVisitor inVisitor) {
        this.converterVisitor = inVisitor;
    }

    public List<PropositionDefinition> convert(SequenceEntity sequenceEntity) {
        String propId;
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        this.primaryPropId = propId = this.toPropositionId((PhenotypeEntity)sequenceEntity);
        if (this.converterVisitor.addPropositionId(propId)) {
            HighLevelAbstractionDefinition p = new HighLevelAbstractionDefinition(propId);
            TemporalExtendedPropositionDefinition primaryEP = this.buildExtendedProposition(sequenceEntity.getPrimaryExtendedPhenotype());
            if (sequenceEntity.getRelations() != null) {
                for (edu.emory.cci.aiw.cvrg.eureka.services.entity.Relation rel : sequenceEntity.getRelations()) {
                    PhenotypeEntity lhs = rel.getLhsExtendedPhenotype().getPhenotypeEntity();
                    lhs.accept((PhenotypeEntityVisitor)this.converterVisitor);
                    result.addAll(this.converterVisitor.getPropositionDefinitions());
                    TemporalExtendedPropositionDefinition tepdLhs = this.buildExtendedProposition(rel.getLhsExtendedPhenotype());
                    PhenotypeEntity rhs = rel.getRhsExtendedPhenotype().getPhenotypeEntity();
                    rhs.accept((PhenotypeEntityVisitor)this.converterVisitor);
                    result.addAll(this.converterVisitor.getPropositionDefinitions());
                    TemporalExtendedPropositionDefinition tepdRhs = this.buildExtendedProposition(rel.getRhsExtendedPhenotype());
                    p.add((ExtendedPropositionDefinition)tepdLhs);
                    p.add((ExtendedPropositionDefinition)tepdRhs);
                    p.setRelation(tepdLhs, tepdRhs, this.buildRelation(rel));
                }
            }
            p.setConcatenable(false);
            p.setSolid(false);
            p.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
            TemporalPatternOffset temporalOffsets = new TemporalPatternOffset();
            temporalOffsets.setStartTemporalExtendedPropositionDefinition(primaryEP);
            temporalOffsets.setStartIntervalSide(Interval.Side.START);
            temporalOffsets.setStartOffset(0);
            temporalOffsets.setStartOffsetUnits(null);
            temporalOffsets.setFinishTemporalExtendedPropositionDefinition(primaryEP);
            temporalOffsets.setFinishIntervalSide(Interval.Side.FINISH);
            temporalOffsets.setFinishOffset(0);
            temporalOffsets.setFinishOffsetUnits(null);
            p.setTemporalOffset(temporalOffsets);
            p.setDisplayName(sequenceEntity.getDisplayName());
            p.setDescription(sequenceEntity.getDescription());
            p.setSourceId(this.sourceId((PhenotypeEntity)sequenceEntity));
            this.primary = p;
            result.add((PropositionDefinition)p);
        }
        return result;
    }

    private TemporalExtendedPropositionDefinition buildExtendedProposition(ExtendedPhenotype ep) {
        TemporalExtendedPropositionDefinition tepd = (TemporalExtendedPropositionDefinition)this.extendedProps.get(ep.getId());
        if (tepd == null) {
            tepd = ConversionUtil.buildExtendedPropositionDefinition((ExtendedPhenotype)ep);
            this.extendedProps.put(ep.getId(), tepd);
        }
        return tepd;
    }

    private Relation buildRelation(edu.emory.cci.aiw.cvrg.eureka.services.entity.Relation rel) {
        return new Relation(null, null, null, null, rel.getMins1f2(), (Unit)ConversionUtil.unit((TimeUnit)rel.getMins1f2TimeUnit()), rel.getMaxs1f2(), (Unit)ConversionUtil.unit((TimeUnit)rel.getMaxs1f2TimeUnit()), rel.getMinf1s2(), (Unit)ConversionUtil.unit((TimeUnit)rel.getMinf1s2TimeUnit()), rel.getMaxf1s2(), (Unit)ConversionUtil.unit((TimeUnit)rel.getMaxf1s2TimeUnit()), null, null, null, null);
    }
}

