/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.CohortConversionSupport;
import edu.emory.cci.aiw.cvrg.eureka.services.util.AbstractNodeVisitor;
import org.eurekaclinical.eureka.client.comm.BinaryOperator;
import org.eurekaclinical.eureka.client.comm.Literal;
import org.eurekaclinical.eureka.client.comm.Node;
import org.eurekaclinical.eureka.client.comm.NodeVisitor;
import org.eurekaclinical.eureka.client.comm.UnaryOperator;

public class ServicesNodeToEtlNodeVisitor
extends AbstractNodeVisitor {
    private final CohortConversionSupport conversionSupport = new CohortConversionSupport();
    private Node node;

    public void visit(Literal literal) {
        Literal etlLiteral = new Literal();
        etlLiteral.setId(literal.getId());
        String key = literal.getName();
        etlLiteral.setName(this.conversionSupport.toPropositionId(key));
        etlLiteral.setStart(literal.getStart());
        etlLiteral.setFinish(literal.getFinish());
        this.node = etlLiteral;
    }

    public void visit(UnaryOperator unaryOperator) {
        UnaryOperator etlUO = new UnaryOperator();
        etlUO.setId(unaryOperator.getId());
        ServicesNodeToEtlNodeVisitor v = new ServicesNodeToEtlNodeVisitor();
        unaryOperator.getNode().accept((NodeVisitor)v);
        etlUO.setNode(v.getNode());
        etlUO.setOp(unaryOperator.getOp());
        this.node = etlUO;
    }

    public void visit(BinaryOperator binaryOperator) {
        BinaryOperator etlBO = new BinaryOperator();
        etlBO.setId(binaryOperator.getId());
        etlBO.setOp(binaryOperator.getOp());
        ServicesNodeToEtlNodeVisitor v = new ServicesNodeToEtlNodeVisitor();
        binaryOperator.getLeftNode().accept((NodeVisitor)v);
        etlBO.setLeftNode(v.getNode());
        binaryOperator.getRightNode().accept((NodeVisitor)v);
        etlBO.setRightNode(v.getNode());
        this.node = etlBO;
    }

    public Node getNode() {
        return this.node;
    }
}

