/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.AbstractValueThresholdGroupEntityConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ValueThresholdGroupEntity;
import java.util.ArrayList;
import java.util.List;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.GapFunction;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.SlidingWindowWidthMode;
import org.protempa.ValueClassification;

public final class ValueThresholdsCompoundLowLevelAbstractionConverter
extends AbstractValueThresholdGroupEntityConverter
implements PropositionDefinitionConverter<ValueThresholdGroupEntity, CompoundLowLevelAbstractionDefinition> {
    private PropositionDefinitionConverterVisitor converterVisitor;
    private CompoundLowLevelAbstractionDefinition primary;
    private String primaryPropId;

    public void setConverterVisitor(PropositionDefinitionConverterVisitor inConverterVisitor) {
        this.converterVisitor = inConverterVisitor;
    }

    public CompoundLowLevelAbstractionDefinition getPrimaryPropositionDefinition() {
        return this.primary;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropId;
    }

    public List<PropositionDefinition> convert(ValueThresholdGroupEntity entity) {
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        String propId = this.toPropositionId((PhenotypeEntity)entity);
        if (this.converterVisitor.addPropositionId(propId)) {
            CompoundLowLevelAbstractionDefinition wrapped = new CompoundLowLevelAbstractionDefinition(propId);
            wrapped.setDisplayName(entity.getDisplayName());
            wrapped.setDescription(entity.getDescription());
            if (entity.getThresholdsOperator().getName().equalsIgnoreCase("any")) {
                wrapped.setValueDefinitionMatchOperator(CompoundLowLevelAbstractionDefinition.ValueDefinitionMatchOperator.ANY);
            } else if (entity.getThresholdsOperator().getName().equalsIgnoreCase("all")) {
                wrapped.setValueDefinitionMatchOperator(CompoundLowLevelAbstractionDefinition.ValueDefinitionMatchOperator.ALL);
            } else {
                throw new IllegalStateException("valueDefinitionMatchOperator can only be ANY or ALL");
            }
            wrapped.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
            ArrayList<LowLevelAbstractionDefinition> intermediates = new ArrayList<LowLevelAbstractionDefinition>();
            for (ValueThresholdEntity v : entity.getValueThresholds()) {
                v.getAbstractedFrom().accept((PhenotypeEntityVisitor)this.converterVisitor);
                result.addAll(this.converterVisitor.getPropositionDefinitions());
                LowLevelAbstractionDefinition def = new LowLevelAbstractionDefinition(entity.getKey() + "_SUB" + v.getId());
                def.setConcatenable(false);
                def.addPrimitiveParameterId(this.converterVisitor.getPrimaryPropositionId());
                def.setMinimumNumberOfValues(1);
                def.setMaximumNumberOfValues(1);
                def.setAlgorithmId("stateDetector");
                def.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                this.thresholdToValueDefinitions(entity, v, def);
                def.setSlidingWindowWidthMode(SlidingWindowWidthMode.DEFAULT);
                def.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                List extendedPhenotypes = v.getExtendedPhenotypes();
                if (extendedPhenotypes != null && !extendedPhenotypes.isEmpty()) {
                    ContextDefinition cd = ConversionUtil.extractContextDefinition((ValueThresholdGroupEntity)entity, (List)extendedPhenotypes, (ValueThresholdEntity)v);
                    result.add((PropositionDefinition)cd);
                    def.setContextId(cd.getId());
                }
                def.setSourceId(this.sourceId((PhenotypeEntity)entity));
                intermediates.add(def);
            }
            result.addAll(intermediates);
            for (LowLevelAbstractionDefinition def : intermediates) {
                wrapped.addValueClassification(new ValueClassification(this.asValueString((PhenotypeEntity)entity), def.getId(), this.asValueString((PhenotypeEntity)entity)));
                wrapped.addValueClassification(new ValueClassification(this.asValueCompString((PhenotypeEntity)entity), def.getId(), this.asValueCompString((PhenotypeEntity)entity)));
            }
            wrapped.setSourceId(this.sourceId((PhenotypeEntity)entity));
            result.add((PropositionDefinition)wrapped);
            this.primary = wrapped;
            this.primaryPropId = wrapped.getPropositionId();
        }
        return result;
    }
}

