/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.config.ServiceProperties;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.PropositionFindException;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.SourceConfigResource;
import edu.emory.cci.aiw.cvrg.eureka.services.util.PropositionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.SourceConfigParams;
import org.eurekaclinical.eureka.client.comm.SystemPhenotype;
import org.eurekaclinical.protempa.client.EurekaClinicalProtempaClient;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.protempa.PropositionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/protected/concepts")
@RolesAllowed(value={"researcher"})
@Produces(value={"application/json"})
public class ConceptResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConceptResource.class);
    private final SystemPropositionFinder finder;
    private final ServiceProperties serviceProperties;
    private final SourceConfigResource sourceConfigResource;
    private final EurekaClinicalProtempaClient etlClient;

    @Inject
    public ConceptResource(SystemPropositionFinder inFinder, SourceConfigResource inSourceConfigResource, ServiceProperties inServiceProperties, EurekaClinicalProtempaClient inEtlClient) {
        this.finder = inFinder;
        this.serviceProperties = inServiceProperties;
        this.sourceConfigResource = inSourceConfigResource;
        this.etlClient = inEtlClient;
    }

    @GET
    public List<SystemPhenotype> getAll() {
        ArrayList<SystemPhenotype> result = new ArrayList<SystemPhenotype>();
        List scps = this.sourceConfigResource.getParamsList();
        if (scps.isEmpty()) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
        }
        try {
            List definitions = this.finder.findAll(((SourceConfigParams)scps.get(0)).getId(), this.serviceProperties.getDefaultSystemPropositions(), Boolean.FALSE);
            if (definitions.isEmpty()) {
                LOGGER.warn("No proposition definitions retrieved");
            } else {
                for (PropositionDefinition definition : definitions) {
                    SystemPhenotype phenotype = PropositionUtil.toSystemPhenotype((String)((SourceConfigParams)scps.get(0)).getId(), (PropositionDefinition)definition, (boolean)true, (SystemPropositionFinder)this.finder);
                    result.add(phenotype);
                }
            }
        }
        catch (PropositionFindException e) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return result;
    }

    @GET
    @Path(value="/{key}")
    public SystemPhenotype get(@PathParam(value="key") String inKey, @DefaultValue(value="false") @QueryParam(value="summarize") boolean inSummarize) {
        return this.getSystemPhenotypeCommon(inKey, inSummarize);
    }

    @POST
    public List<SystemPhenotype> getPropositionsPost(@FormParam(value="key") List<String> inKeys, @DefaultValue(value="false") @FormParam(value="summarize") String inSummarize) {
        return this.getSystemPhenotypesCommon(inKeys, Boolean.parseBoolean(inSummarize));
    }

    @GET
    @Path(value="/search/{searchKey}")
    public List<String> searchSystemPhenotypes(@PathParam(value="searchKey") String inSearchKey) {
        LOGGER.info("Searching system phenotype tree for the searchKey {}", (Object)inSearchKey);
        List scps = this.sourceConfigResource.getParamsList();
        if (scps.isEmpty()) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
        }
        try {
            List searchResult = this.etlClient.getPropositionSearchResults(((SourceConfigParams)scps.get(0)).getId(), inSearchKey);
            LOGGER.info("returning search results list of size" + searchResult.size());
            return searchResult;
        }
        catch (ClientException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Path(value="/propsearch/{searchKey}")
    public List<SystemPhenotype> getSystemPhenotypesBySearchKey(@PathParam(value="searchKey") String inSearchKey) {
        LOGGER.info("Searching system phenotype tree for the searchKey {}", (Object)inSearchKey);
        ArrayList<SystemPhenotype> result = new ArrayList<SystemPhenotype>();
        List scps = this.sourceConfigResource.getParamsList();
        if (scps.isEmpty()) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
        }
        try {
            List definitions = this.etlClient.getPropositionSearchResultsBySearchKey(((SourceConfigParams)scps.get(0)).getId(), inSearchKey);
            for (PropositionDefinition definition : definitions) {
                SystemPhenotype phenotype = PropositionUtil.toSystemPhenotype((String)((SourceConfigParams)scps.get(0)).getId(), (PropositionDefinition)definition, (boolean)true, (SystemPropositionFinder)this.finder);
                result.add(phenotype);
            }
            LOGGER.info("returning search results list of size" + definitions.size());
            return result;
        }
        catch (ClientException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (PropositionFindException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private List<SystemPhenotype> getSystemPhenotypesCommon(List<String> inKeys, boolean inSummarize) throws HttpStatusException {
        LOGGER.info("Finding system phenotype {}", inKeys);
        List scps = this.sourceConfigResource.getParamsList();
        if (scps.isEmpty()) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
        }
        String sourceConfigId = ((SourceConfigParams)scps.get(0)).getId();
        try {
            List definition = this.finder.findAll(sourceConfigId, inKeys, Boolean.FALSE);
            ArrayList<SystemPhenotype> result = new ArrayList<SystemPhenotype>(definition.size());
            for (PropositionDefinition propDef : definition) {
                result.add(PropositionUtil.toSystemPhenotype((String)sourceConfigId, (PropositionDefinition)propDef, (boolean)inSummarize, (SystemPropositionFinder)this.finder));
            }
            return result;
        }
        catch (PropositionFindException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    private SystemPhenotype getSystemPhenotypeCommon(String inKey, boolean inSummarize) throws HttpStatusException {
        LOGGER.info("Finding system phenotype {}", (Object)inKey);
        List scps = this.sourceConfigResource.getParamsList();
        if (scps.isEmpty()) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, "No source configs");
        }
        try {
            PropositionDefinition definition = this.finder.find(((SourceConfigParams)scps.get(0)).getId(), (Object)inKey);
            if (definition == null) {
                throw new HttpStatusException(Response.Status.NOT_FOUND);
            }
            return PropositionUtil.toSystemPhenotype((String)((SourceConfigParams)scps.get(0)).getId(), (PropositionDefinition)definition, (boolean)inSummarize, (SystemPropositionFinder)this.finder);
        }
        catch (PropositionFindException ex) {
            throw new HttpStatusException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }
}

