/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.FrequencyTypeDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyType;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Transactional
@Path(value="/protected/frequencytypes")
@Produces(value={"application/json"})
public class FrequencyTypeResource {
    private final FrequencyTypeDao frequencyTypeDao;

    @Inject
    public FrequencyTypeResource(FrequencyTypeDao inFrequencyTypeDao) {
        this.frequencyTypeDao = inFrequencyTypeDao;
    }

    @GET
    public List<FrequencyType> getAllAsc() {
        return this.frequencyTypeDao.getAllAsc();
    }

    @GET
    @Path(value="/{id}")
    public FrequencyType get(@PathParam(value="id") Long inId) {
        FrequencyType result = (FrequencyType)this.frequencyTypeDao.retrieve((Object)inId);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }

    @GET
    @Path(value="/byname/{name}")
    public FrequencyType getByName(@PathParam(value="name") String inName) {
        FrequencyType result = this.frequencyTypeDao.getByName(inName);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }
}

