/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.ThresholdsOperatorDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ThresholdsOperator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Transactional
@Path(value="/protected/thresholdsops")
@Produces(value={"application/json"})
public class ThresholdsOperatorResource {
    private ThresholdsOperatorDao thresholdsOpDao;

    @Inject
    public ThresholdsOperatorResource(ThresholdsOperatorDao thresholdsOpDao) {
        this.thresholdsOpDao = thresholdsOpDao;
    }

    @GET
    public List<ThresholdsOperator> getAll() {
        return this.thresholdsOpDao.getAll();
    }

    @GET
    @Path(value="/{id}")
    public ThresholdsOperator get(@PathParam(value="id") Long inId) {
        ThresholdsOperator result = (ThresholdsOperator)this.thresholdsOpDao.retrieve((Object)inId);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }

    @GET
    @Path(value="/byname/{name}")
    public ThresholdsOperator getByName(@PathParam(value="name") String inName) {
        ThresholdsOperator result = this.thresholdsOpDao.getByName(inName);
        if (result == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return result;
    }
}

