/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.resource;

import com.google.inject.persist.Transactional;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.AuthorizedUserDao;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.RoleDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.AuthorizedRoleEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.AuthorizedUserEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.resource.AbstractUserResource;
import org.eurekaclinical.standardapis.dao.UserDao;

@Transactional
@Path(value="/protected/users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RolesAllowed(value={"admin"})
public class UserResource
extends AbstractUserResource<User, AuthorizedUserEntity, AuthorizedRoleEntity> {
    private final RoleDao roleDao;

    @Inject
    public UserResource(AuthorizedUserDao inUserDao, RoleDao inRoleDao) {
        super((UserDao)inUserDao);
        this.roleDao = inRoleDao;
    }

    protected User toComm(AuthorizedUserEntity userEntity, HttpServletRequest request) {
        User user = new User();
        user.setId(userEntity.getId());
        user.setUsername(userEntity.getUsername());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (AuthorizedRoleEntity roleEntity : userEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        user.setRoles(roles);
        return user;
    }

    protected AuthorizedUserEntity toEntity(User user) {
        List roleEntities = this.roleDao.getAll();
        AuthorizedUserEntity userEntity = new AuthorizedUserEntity();
        userEntity.setId(user.getId());
        userEntity.setUsername(user.getUsername());
        ArrayList<AuthorizedRoleEntity> userRoleEntities = new ArrayList<AuthorizedRoleEntity>();
        for (Long roleId : user.getRoles()) {
            for (AuthorizedRoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                userRoleEntities.add(roleEntity);
            }
        }
        userEntity.setRoles(userRoleEntities);
        return userEntity;
    }
}

