/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.translation;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.services.dao.PhenotypeEntityDao;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PropositionTypeVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.finder.SystemPropositionFinder;
import edu.emory.cci.aiw.cvrg.eureka.services.resource.SourceConfigResource;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.CategorizationTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslator;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.PropositionTranslatorUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.translation.TranslatorSupport;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.eureka.client.comm.Category;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.PhenotypeField;
import org.eurekaclinical.eureka.client.comm.exception.PhenotypeHandlingException;

public final class CategorizationTranslator
implements PropositionTranslator<Category, CategoryEntity> {
    private final TranslatorSupport translatorSupport;

    @Inject
    public CategorizationTranslator(PhenotypeEntityDao inPropositionDao, SystemPropositionFinder inFinder, SourceConfigResource inSourceConfigResource) {
        this.translatorSupport = new TranslatorSupport(inPropositionDao, inFinder, inSourceConfigResource);
    }

    public CategoryEntity translateFromPhenotype(Category phenotype) throws PhenotypeHandlingException {
        CategoryEntity result = (CategoryEntity)this.translatorSupport.getUserEntityInstance((Phenotype)phenotype, CategoryEntity.class);
        ArrayList<PhenotypeEntity> inverseIsA = new ArrayList<PhenotypeEntity>();
        if (phenotype.getChildren() != null) {
            for (PhenotypeField de : phenotype.getChildren()) {
                PhenotypeEntity proposition = this.translatorSupport.getUserOrSystemEntityInstance(phenotype.getUserId(), de.getPhenotypeKey());
                inverseIsA.add(proposition);
            }
        }
        result.setMembers(inverseIsA);
        result.setCategoryType(this.checkPropositionType(phenotype, inverseIsA));
        return result;
    }

    private CategoryEntity.CategoryType checkPropositionType(Category phenotype, List<PhenotypeEntity> inverseIsA) throws PhenotypeHandlingException {
        if (inverseIsA.isEmpty()) {
            throw new PhenotypeHandlingException(Response.Status.PRECONDITION_FAILED, "Category " + phenotype.getKey() + " is invalid because it has no children");
        }
        EnumSet<CategoryEntity.CategoryType> categorizationTypes = EnumSet.noneOf(CategoryEntity.CategoryType.class);
        for (PhenotypeEntity phenotypeEntity : inverseIsA) {
            categorizationTypes.add(phenotypeEntity.getCategoryType());
        }
        if (categorizationTypes.size() > 1) {
            throw new PhenotypeHandlingException(Response.Status.PRECONDITION_FAILED, "Category " + phenotype.getKey() + " has children with inconsistent types: " + StringUtils.join(categorizationTypes, (String)", "));
        }
        return (CategoryEntity.CategoryType)categorizationTypes.iterator().next();
    }

    public Category translateFromProposition(CategoryEntity proposition) {
        Category result = new Category();
        PropositionTranslatorUtil.populateCommonPhenotypeFields((Phenotype)result, (PhenotypeEntity)proposition);
        ArrayList<PhenotypeField> children = new ArrayList<PhenotypeField>();
        for (PhenotypeEntity p : proposition.getMembers()) {
            PhenotypeField def = new PhenotypeField();
            def.setPhenotypeKey(p.getKey());
            def.setPhenotypeDisplayName(p.getDisplayName());
            def.setPhenotypeDescription(p.getDescription());
            PropositionTypeVisitor visitor = new PropositionTypeVisitor();
            p.accept((PhenotypeEntityVisitor)visitor);
            def.setType(visitor.getType());
            if (p instanceof CategoryEntity) {
                def.setCategoricalType(this.checkElementType((CategoryEntity)p));
            }
            children.add(def);
        }
        result.setChildren(children);
        result.setCategoricalType(this.checkElementType(proposition));
        return result;
    }

    private Category.CategoricalType checkElementType(CategoryEntity proposition) {
        switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$services$entity$CategoryEntity$CategoryType[proposition.getCategoryType().ordinal()]) {
            case 1: {
                return Category.CategoricalType.LOW_LEVEL_ABSTRACTION;
            }
            case 2: {
                return Category.CategoricalType.HIGH_LEVEL_ABSTRACTION;
            }
            case 3: {
                return Category.CategoricalType.SLICE_ABSTRACTION;
            }
            case 4: {
                return Category.CategoricalType.CONSTANT;
            }
            case 5: {
                return Category.CategoricalType.EVENT;
            }
            case 6: {
                return Category.CategoricalType.PRIMITIVE_PARAMETER;
            }
            case 7: {
                return Category.CategoricalType.SEQUENTIAL_TEMPORAL_PATTERN_ABSTRACTION;
            }
        }
        throw new AssertionError((Object)("Invalid category type: " + proposition.getCategoryType()));
    }
}

