/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.conversion;

import edu.emory.cci.aiw.cvrg.eureka.services.conversion.AbstractConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.ConversionUtil;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.FrequencyConverter;
import edu.emory.cci.aiw.cvrg.eureka.services.conversion.PropositionDefinitionConverterVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.ExtendedPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.FrequencyEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.TimeUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.GapFunction;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.MinMaxGapFunction;
import org.protempa.PropositionDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.SliceDefinition;
import org.protempa.TemporalExtendedParameterDefinition;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.ValueClassification;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;

public final class FrequencyValueThresholdConverter
extends AbstractConverter
implements FrequencyConverter {
    private PropositionDefinitionConverterVisitor converterVisitor;
    private HighLevelAbstractionDefinition primary;
    private String primaryPropId;

    public HighLevelAbstractionDefinition getPrimaryPropositionDefinition() {
        return this.primary;
    }

    public String getPrimaryPropositionId() {
        return this.primaryPropId;
    }

    public void setConverterVisitor(PropositionDefinitionConverterVisitor inVisitor) {
        this.converterVisitor = inVisitor;
    }

    public List<PropositionDefinition> convert(FrequencyEntity entity) {
        String propId;
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        this.primaryPropId = propId = this.toPropositionId((PhenotypeEntity)entity);
        if (this.converterVisitor.addPropositionId(propId)) {
            ExtendedPhenotype extendedProposition = entity.getExtendedProposition();
            PhenotypeEntity abstractedFrom = extendedProposition.getPhenotypeEntity();
            abstractedFrom.accept((PhenotypeEntityVisitor)this.converterVisitor);
            Collection intermediates = this.converterVisitor.getPropositionDefinitions();
            result.addAll(intermediates);
            String wrapperPropId = entity.getKey() + "_SUB";
            if (entity.isConsecutive()) {
                TemporalExtendedParameterDefinition tepdOuter;
                String abstractedFromPrimaryPropId = this.converterVisitor.getPrimaryPropositionId();
                CompoundLowLevelAbstractionDefinition frequencyWrapper = new CompoundLowLevelAbstractionDefinition(wrapperPropId);
                frequencyWrapper.setMinimumNumberOfValues(entity.getCount().intValue());
                frequencyWrapper.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                ValueClassification vc = new ValueClassification(this.asValueString((PhenotypeEntity)entity), abstractedFromPrimaryPropId, this.asValueString(abstractedFrom));
                frequencyWrapper.addValueClassification(vc);
                ValueClassification vcComp = new ValueClassification(this.asValueCompString((PhenotypeEntity)entity), abstractedFromPrimaryPropId, this.asValueCompString(abstractedFrom));
                frequencyWrapper.addValueClassification(vcComp);
                frequencyWrapper.setGapFunctionBetweenValues((GapFunction)new MinMaxGapFunction(entity.getWithinAtLeast(), (Unit)ConversionUtil.unit((TimeUnit)entity.getWithinAtLeastUnits()), entity.getWithinAtMost(), (Unit)ConversionUtil.unit((TimeUnit)entity.getWithinAtMostUnits())));
                frequencyWrapper.setSourceId(this.sourceId((PhenotypeEntity)entity));
                result.add((PropositionDefinition)frequencyWrapper);
                if (entity.getFrequencyType().getName().equals("at least")) {
                    TemporalExtendedParameterDefinition tepd = new TemporalExtendedParameterDefinition(wrapperPropId);
                    tepd.setValue((Value)this.asValue((PhenotypeEntity)entity));
                    tepdOuter = tepd;
                } else if (entity.getFrequencyType().getName().equals("first")) {
                    frequencyWrapper.setSkip(1);
                    String subWrapperPropId = wrapperPropId + "SUB";
                    SliceDefinition sp = new SliceDefinition(subWrapperPropId);
                    sp.setMinIndex(0);
                    sp.setMaxIndex(1);
                    TemporalExtendedParameterDefinition tepd2 = new TemporalExtendedParameterDefinition(wrapperPropId);
                    tepd2.setValue((Value)this.asValue((PhenotypeEntity)entity));
                    sp.add((TemporalExtendedPropositionDefinition)tepd2);
                    sp.setSourceId(this.sourceId((PhenotypeEntity)entity));
                    result.add((PropositionDefinition)sp);
                    TemporalExtendedPropositionDefinition tepd = new TemporalExtendedPropositionDefinition(subWrapperPropId);
                    tepdOuter = tepd;
                } else {
                    throw new IllegalStateException("invalid frequency type: " + entity.getFrequencyType().getName());
                }
                HighLevelAbstractionDefinition hlad = new HighLevelAbstractionDefinition(propId);
                hlad.add((ExtendedPropositionDefinition)tepdOuter);
                hlad.setRelation((TemporalExtendedPropositionDefinition)tepdOuter, (TemporalExtendedPropositionDefinition)tepdOuter, new Relation());
                hlad.setDisplayName(entity.getDisplayName());
                hlad.setDescription(entity.getDescription());
                hlad.setSourceId(this.sourceId((PhenotypeEntity)entity));
                result.add((PropositionDefinition)hlad);
                this.primary = hlad;
            } else {
                HighLevelAbstractionDefinition p = new HighLevelAbstractionDefinition(propId);
                p.setDisplayName(entity.getDisplayName());
                p.setDescription(entity.getDescription());
                if (entity.getFrequencyType().getName().equals("at least")) {
                    int i;
                    TemporalExtendedPropositionDefinition[] tepds = new TemporalExtendedPropositionDefinition[entity.getCount().intValue()];
                    for (i = 0; i < entity.getCount(); ++i) {
                        TemporalExtendedPropositionDefinition tepd;
                        tepds[i] = tepd = ConversionUtil.buildExtendedPropositionDefinition((ExtendedPhenotype)extendedProposition);
                        p.add((ExtendedPropositionDefinition)tepd);
                    }
                    if (tepds.length > 1) {
                        for (i = 0; i < tepds.length - 1; ++i) {
                            Relation rel = new Relation(null, null, null, null, null, null, null, null, entity.getWithinAtLeast(), (Unit)ConversionUtil.unit((TimeUnit)entity.getWithinAtLeastUnits()), entity.getWithinAtMost(), (Unit)ConversionUtil.unit((TimeUnit)entity.getWithinAtMostUnits()), null, null, null, null);
                            p.setRelation(tepds[i], tepds[i + 1], rel);
                        }
                    } else {
                        p.setRelation(tepds[0], tepds[0], new Relation());
                    }
                } else if (entity.getFrequencyType().getName().equals("first")) {
                    SliceDefinition sp = new SliceDefinition(wrapperPropId);
                    sp.setDisplayName(entity.getDisplayName());
                    sp.setDescription(entity.getDescription());
                    sp.setMergedInterval(true);
                    sp.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                    TemporalExtendedPropositionDefinition tepd = ConversionUtil.buildExtendedPropositionDefinition((ExtendedPhenotype)extendedProposition);
                    sp.add(tepd);
                    sp.setMinIndex(0);
                    sp.setMaxIndex(entity.getCount().intValue());
                    sp.setSourceId(this.sourceId((PhenotypeEntity)entity));
                    result.add((PropositionDefinition)sp);
                    TemporalExtendedPropositionDefinition tepdForSlice = new TemporalExtendedPropositionDefinition(wrapperPropId);
                    p.add((ExtendedPropositionDefinition)tepdForSlice);
                    p.setRelation(tepdForSlice, tepdForSlice, new Relation());
                } else {
                    throw new IllegalStateException("invalid frequency type: " + entity.getFrequencyType().getName());
                }
                p.setGapFunction((GapFunction)new SimpleGapFunction(Integer.valueOf(0), null));
                p.setSourceId(this.sourceId((PhenotypeEntity)entity));
                this.primary = p;
                result.add((PropositionDefinition)p);
            }
            this.primaryPropId = this.primary.getPropositionId();
        }
        return result;
    }
}

