/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.entity;

import edu.emory.cci.aiw.cvrg.eureka.services.entity.CategoryEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntity;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.PhenotypeEntityVisitor;
import edu.emory.cci.aiw.cvrg.eureka.services.entity.SystemProposition;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.eurekaclinical.eureka.client.comm.SystemType;

@Entity
@Table(name="system_phenotypes")
public class SystemProposition
extends PhenotypeEntity {
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private SystemType systemType;

    public SystemType getSystemType() {
        return this.systemType;
    }

    public void setSystemType(SystemType systemType) {
        this.systemType = systemType;
        this.setCatType(this.inferCategoryType());
    }

    public void accept(PhenotypeEntityVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isInSystem() {
        return true;
    }

    private CategoryEntity.CategoryType inferCategoryType() {
        if (this.systemType != null) {
            switch (1.$SwitchMap$org$eurekaclinical$eureka$client$comm$SystemType[this.systemType.ordinal()]) {
                case 1: {
                    return CategoryEntity.CategoryType.HIGH_LEVEL_ABSTRACTION;
                }
                case 2: {
                    return CategoryEntity.CategoryType.CONSTANT;
                }
                case 3: {
                    return CategoryEntity.CategoryType.EVENT;
                }
                case 4: {
                    return CategoryEntity.CategoryType.PRIMITIVE_PARAMETER;
                }
                case 5: {
                    return CategoryEntity.CategoryType.LOW_LEVEL_ABSTRACTION;
                }
                case 6: {
                    return CategoryEntity.CategoryType.SLICE_ABSTRACTION;
                }
                case 7: {
                    return CategoryEntity.CategoryType.SEQUENTIAL_TEMPORAL_PATTERN_ABSTRACTION;
                }
                case 8: {
                    return CategoryEntity.CategoryType.CONTEXT;
                }
            }
            throw new AssertionError((Object)("Invalid system type: " + this.systemType));
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

