/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.services.props;

import java.net.URI;
import org.arp.javautil.arrays.Arrays;

public final class SupportUri {
    private static final String[] schemesToIncludeInName = new String[]{"http", "https"};
    private static final String[] hyperlinkableSchemas = new String[]{"http", "https", "mailto"};
    private final URI uri;
    private final String name;

    public SupportUri(URI uri, String name) {
        assert (uri != null) : "uri cannot be null";
        this.uri = uri;
        this.name = name;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isHyperlinkable() {
        return Arrays.contains((Object[])hyperlinkableSchemas, (Object)this.uri.getScheme());
    }

    public String toString() {
        if (!this.isHyperlinkable()) {
            return this.uriWithoutScheme();
        }
        return this.uri.toString();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (Arrays.contains((Object[])schemesToIncludeInName, (Object)this.uri.getScheme())) {
            return this.uri.toString();
        }
        return this.uriWithoutScheme();
    }

    private String uriWithoutScheme() {
        return this.uri.toString().split(":", 2)[1];
    }
}

