/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.util.Map;
import org.eurekaclinical.standardapis.config.ServletModuleSupport;
import org.eurekaclinical.standardapis.filter.RolesFilter;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServletModule
extends ServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServletModule.class);
    private static final String CAS_CALLBACK_PATH = "/proxyCallback";
    private final String protectedPath;
    private final ServletModuleSupport servletModuleSupport;
    private final String logoutPath;

    protected AbstractServletModule(EurekaClinicalProperties inProperties, String inContainerPath, String inProtectedPath, String inLogoutPath) {
        if (inProtectedPath == null) {
            throw new IllegalArgumentException("inProtectedPath cannot be null");
        }
        if (inLogoutPath == null) {
            throw new IllegalArgumentException("inLogoutPath cannot be null");
        }
        this.servletModuleSupport = new ServletModuleSupport(this.getServletContext().getContextPath(), inProperties);
        this.protectedPath = inProtectedPath;
        this.logoutPath = inLogoutPath;
    }

    protected void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    private void setupCasSingleSignOutFilter() {
        this.bind(SingleSignOutFilter.class).in(Singleton.class);
        this.filter(this.logoutPath, new String[0]).through(SingleSignOutFilter.class);
    }

    private void setupAuthorizationFilter() {
        this.bind(RolesFilter.class).in(Singleton.class);
        Map rolesFilterInitParams = this.servletModuleSupport.getRolesFilterInitParams();
        this.filter("/*", new String[0]).through(RolesFilter.class, rolesFilterInitParams);
    }

    private void setupCasProxyFilter() {
        this.bind(Cas20ProxyReceivingTicketValidationFilter.class).in(Singleton.class);
        Map params = this.servletModuleSupport.getCasProxyFilterInitParamsForWebApp();
        this.filter(CAS_CALLBACK_PATH, new String[]{this.protectedPath}).through(Cas20ProxyReceivingTicketValidationFilter.class, params);
    }

    private void setupCasAuthenticationFilter() {
        this.bind(AuthenticationFilter.class).in(Singleton.class);
        Map params = this.servletModuleSupport.getCasAuthenticationFilterInitParams();
        this.filter(this.protectedPath, new String[0]).through(AuthenticationFilter.class, params);
    }

    private void setupCasServletRequestWrapperFilter() {
        this.bind(HttpServletRequestWrapperFilter.class).in(Singleton.class);
        Map params = this.servletModuleSupport.getServletRequestWrapperFilterInitParams();
        this.filter("/*", new String[0]).through(HttpServletRequestWrapperFilter.class, params);
    }

    private void setupCasThreadLocalAssertionFilter() {
        this.bind(AssertionThreadLocalFilter.class).in(Singleton.class);
        this.filter("/*", new String[0]).through(AssertionThreadLocalFilter.class);
    }

    protected abstract void setupServlets();

    protected void setupFilters() {
    }

    protected void configureServlets() {
        super.configureServlets();
        this.setupCasFilters();
        this.setupAuthorizationFilter();
        this.setupFilters();
        this.setupServlets();
    }

    private void setupCasFilters() {
        this.setupCasSingleSignOutFilter();
        this.setupCasAuthenticationFilter();
        this.setupCasProxyFilter();
        this.setupCasServletRequestWrapperFilter();
        this.setupCasThreadLocalAssertionFilter();
    }
}

