/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.resource;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.resource.AbstractResource;
import org.eurekaclinical.standardapis.dao.Dao;
import org.eurekaclinical.standardapis.entity.Entity;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

public abstract class AbstractReadWriteResource<E extends Entity, C>
extends AbstractResource<E, C> {
    private final Dao<E, Long> dao;

    protected AbstractReadWriteResource(Dao<E, Long> inDao) {
        this(inDao, true);
    }

    protected AbstractReadWriteResource(Dao<E, Long> inDao, boolean inRestricted) {
        super(inDao, inRestricted);
        this.dao = inDao;
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public void update(C commObj, @Context HttpServletRequest req) {
        if (!this.isAuthorizedComm(commObj, req) || this.isRestricted() && !req.isUserInRole("admin")) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        this.dao.update(this.toEntity(commObj));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(C user, @Context HttpServletRequest req) {
        if (this.isRestricted() && !req.isUserInRole("admin")) {
            throw new HttpStatusException(Response.Status.FORBIDDEN);
        }
        E entity = this.toEntity(user);
        return Response.created((URI)URI.create("/" + entity.getId())).build();
    }

    protected abstract E toEntity(C var1);

    protected abstract boolean isAuthorizedComm(C var1, HttpServletRequest var2);
}

