/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.Singleton;
import com.sun.jersey.api.container.filter.RolesAllowedResourceFilterFactory;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.standardapis.config.ServletModuleSupport;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJerseyServletModule
extends JerseyServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJerseyServletModule.class);
    private static final String CONTAINER_PATH = "/api/*";
    private static final String CONTAINER_PROTECTED_PATH = "/api/protected/*";
    private static final String CAS_CALLBACK_PATH = "/proxyCallback";
    private static final String TEMPLATES_PATH = "/WEB-INF/templates";
    private static final String WEB_CONTENT_REGEX = "(/(image|js|css)/?.*)|(/.*\\.jsp)|(/WEB-INF/.*\\.jsp)|(/WEB-INF/.*\\.jspf)|(/.*\\.html)|(/favicon\\.ico)|(/robots\\.txt)";
    private final String packageNames;
    private final ServletModuleSupport servletModuleSupport;

    protected AbstractJerseyServletModule(EurekaClinicalProperties inProperties, String inPackageNames) {
        this.servletModuleSupport = new ServletModuleSupport(this.getServletContext().getContextPath(), inProperties);
        this.packageNames = inPackageNames;
    }

    protected void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    private void setupCasProxyFilter() {
        this.bind(Cas20ProxyReceivingTicketValidationFilter.class).in(Singleton.class);
        Map params = this.servletModuleSupport.getCasProxyFilterInitParamsForWebService();
        this.filter(CAS_CALLBACK_PATH, new String[]{CONTAINER_PROTECTED_PATH}).through(Cas20ProxyReceivingTicketValidationFilter.class, params);
    }

    private void setupCasAuthenticationFilter() {
        this.bind(AuthenticationFilter.class).in(Singleton.class);
        Map params = this.servletModuleSupport.getCasAuthenticationFilterInitParams();
        this.filter(CONTAINER_PROTECTED_PATH, new String[0]).through(AuthenticationFilter.class, params);
    }

    private void setupCasServletRequestWrapperFilter() {
        this.bind(HttpServletRequestWrapperFilter.class).in(Singleton.class);
        Map params = this.servletModuleSupport.getServletRequestWrapperFilterInitParams();
        this.filter("/*", new String[0]).through(HttpServletRequestWrapperFilter.class, params);
    }

    private void setupCasThreadLocalAssertionFilter() {
        this.bind(AssertionThreadLocalFilter.class).in(Singleton.class);
        this.filter("/*", new String[0]).through(AssertionThreadLocalFilter.class);
    }

    private void setupContainer() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        params.put("com.sun.jersey.config.property.packages", this.packageNames);
        params.put("com.sun.jersey.spi.container.ResourceFilters", RolesAllowedResourceFilterFactory.class.getName());
        params.put("com.sun.jersey.config.property.JSPTemplatesBasePath", TEMPLATES_PATH);
        params.put("com.sun.jersey.config.property.WebPageContentRegex", WEB_CONTENT_REGEX);
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        this.serve(CONTAINER_PATH, new String[0]).with(GuiceContainer.class, params);
    }

    protected void setupFilters() {
    }

    protected void configureServlets() {
        super.configureServlets();
        this.setupCasFilters();
        this.setupFilters();
        this.setupContainer();
    }

    private void setupCasFilters() {
        this.setupCasAuthenticationFilter();
        this.setupCasProxyFilter();
        this.setupCasServletRequestWrapperFilter();
        this.setupCasThreadLocalAssertionFilter();
    }
}

