/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ReplacementPathAndClient;
import org.eurekaclinical.common.comm.clients.Router;

@Singleton
public class ProxyingClient {
    private final Router config;

    @Inject
    public ProxyingClient(Router inConfig) {
        this.config = inConfig;
    }

    public URI proxyPost(String path, String json) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return client.doPostCreate(replacementPath, json);
    }

    public void proxyDelete(String path) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        client.doDelete(replacementPath);
    }

    public void proxyPut(String path, String json) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        client.doPut(replacementPath, json);
    }

    public String proxyGet(String path, MultivaluedMap<String, String> queryParams) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        if (queryParams == null) {
            return client.doGet(replacementPath);
        }
        return client.doGet(replacementPath, queryParams);
    }
}

