/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.servlet;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.standardapis.props.EurekaClinicalProperties;

@Singleton
public class LogoutServlet
extends HttpServlet {
    private final EurekaClinicalProperties webappProperties;
    private static final String[] TRUTHY_STRINGS = new String[]{"true", "on", "y", "t", "yes"};
    private static final String[] FALSY_STRINGS = new String[]{"false", "off", "n", "f", "no"};

    @Inject
    public LogoutServlet(EurekaClinicalProperties inProperties) {
        this.webappProperties = inProperties;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean nrEmpty;
        boolean aaEmpty;
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        StringBuilder buf = new StringBuilder();
        String casLogoutUrl = this.webappProperties.getCasLogoutUrl();
        buf.append(casLogoutUrl);
        String awaitingActivation = req.getParameter("awaitingActivation");
        boolean bl = aaEmpty = awaitingActivation == null || awaitingActivation.length() == 0;
        if (!aaEmpty && LogoutServlet.toBooleanObject(awaitingActivation) == null) {
            resp.sendError(400);
            return;
        }
        String notRegistered = req.getParameter("notRegistered");
        boolean bl2 = nrEmpty = notRegistered == null || notRegistered.length() == 0;
        if (!nrEmpty && LogoutServlet.toBooleanObject(notRegistered) == null) {
            resp.sendError(400);
            return;
        }
        if (!aaEmpty || !nrEmpty) {
            buf.append('?');
        }
        if (!aaEmpty) {
            buf.append("awaitingActivation=").append(awaitingActivation);
        }
        if (!aaEmpty && !nrEmpty) {
            buf.append('&');
        }
        if (!nrEmpty) {
            buf.append("notRegistered=").append(notRegistered);
        }
        this.log("URL IS " + buf.toString());
        resp.sendRedirect(buf.toString());
    }

    private static Boolean toBooleanObject(String str) {
        if (str != null) {
            for (String truthyString : TRUTHY_STRINGS) {
                if (!str.equalsIgnoreCase(truthyString)) continue;
                return Boolean.TRUE;
            }
            for (String falsyString : FALSY_STRINGS) {
                if (!str.equalsIgnoreCase(falsyString)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

