/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.eurekaclinical.common.comm.clients.ReplacementPathAndClient;
import org.eurekaclinical.common.comm.clients.Route;
import org.eurekaclinical.common.comm.clients.RouterTable;
import org.eurekaclinical.common.comm.clients.RouterTableLoadException;

@Singleton
public class Router {
    private final Route[] routes;

    @Inject
    public Router(RouterTable routesParser) throws RouterTableLoadException {
        this.routes = routesParser.load();
    }

    public ReplacementPathAndClient getReplacementPathAndClient(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        for (Route route : this.routes) {
            String replacementPath = route.replace(path);
            if (replacementPath == null) continue;
            return new ReplacementPathAndClient(replacementPath, route.getClient());
        }
        return null;
    }
}

