/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.resource;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

public abstract class AbstractUserResource<U extends User, E extends UserEntity<R>, R extends RoleEntity> {
    private final UserDao<E> userDao;

    public AbstractUserResource(UserDao<E> inUserDao) {
        this.userDao = inUserDao;
    }

    @RolesAllowed(value={"admin"})
    @GET
    @Produces(value={"application/json"})
    public List<U> getAll() {
        ArrayList<U> results = new ArrayList<U>();
        for (UserEntity userEntity : this.userDao.getAll()) {
            results.add(this.toUser(userEntity));
        }
        return results;
    }

    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    public U getCurrent(@Context HttpServletRequest req) {
        UserEntity me = this.userDao.getByUsername(req.getRemoteUser());
        if (me == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return this.toUser(me);
    }

    @GET
    @Path(value="/byname/{username}")
    @Produces(value={"application/json"})
    public U getCurrent(@PathParam(value="username") String username, @Context HttpServletRequest req) {
        UserEntity userEntity = this.userDao.getByUsername(username);
        if (userEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        if (req.getRemoteUser().equals(userEntity.getUsername())) {
            return this.toUser(userEntity);
        }
        throw new HttpStatusException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public U getAny(@PathParam(value="id") Long inId, @Context HttpServletRequest req) {
        UserEntity userEntity = (UserEntity)this.userDao.retrieve((Object)inId);
        if (userEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        if (req.getRemoteUser().equals(userEntity.getUsername())) {
            return this.toUser(userEntity);
        }
        throw new HttpStatusException(Response.Status.NOT_FOUND);
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public void update(U user, @Context HttpServletRequest req) {
        if (!req.getRemoteUser().equals(((User)user).getUsername()) && !req.isUserInRole("admin")) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        this.userDao.update(this.toUserEntity(user));
    }

    @RolesAllowed(value={"admin"})
    @POST
    @Consumes(value={"application/json"})
    public Response create(U user) {
        E userEntity = this.toUserEntity(user);
        return Response.created((URI)URI.create("/" + userEntity.getId())).build();
    }

    protected abstract U toUser(E var1);

    protected abstract E toUserEntity(U var1);
}

