/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.resource;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

public abstract class AbstractRoleResource<E extends RoleEntity, R extends Role> {
    private final RoleDao<E> roleDao;

    public AbstractRoleResource(RoleDao<E> inRoleDao) {
        this.roleDao = inRoleDao;
    }

    @GET
    @Produces(value={"application/json"})
    public List<R> getAll() {
        ArrayList<R> results = new ArrayList<R>();
        for (RoleEntity roleEntity : this.roleDao.getAll()) {
            results.add(this.toRole(roleEntity));
        }
        return results;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public R getAny(@PathParam(value="id") Long inId, @Context HttpServletRequest req) {
        RoleEntity roleEntity = (RoleEntity)this.roleDao.retrieve((Object)inId);
        if (roleEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return this.toRole(roleEntity);
    }

    @GET
    @Path(value="/byname/{name}")
    @Produces(value={"application/json"})
    public R getAny(@PathParam(value="name") String inName, @Context HttpServletRequest req) {
        RoleEntity roleEntity = this.roleDao.getRoleByName(inName);
        if (roleEntity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return this.toRole(roleEntity);
    }

    protected abstract R toRole(E var1);
}

