/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.servlet;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.ProxyingClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProxyServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServlet.class);
    private static final long serialVersionUID = 1L;
    private final ProxyingClient client;

    @Inject
    public ProxyServlet(ProxyingClient inClient) {
        this.client = inClient;
    }

    public void init() throws ServletException {
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - PUT");
        String content = ProxyServlet.extractContent(servletRequest);
        String path = servletRequest.getPathInfo();
        try {
            this.client.proxyPut(path, content);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - POST");
        String content = ProxyServlet.extractContent(servletRequest);
        String path = servletRequest.getPathInfo();
        try {
            URI created = this.client.proxyPost(path, content);
            if (created != null) {
                servletResponse.setStatus(201);
                servletResponse.setHeader("Location", created.toString());
            }
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - DELETE");
        String path = servletRequest.getPathInfo();
        try {
            this.client.proxyDelete(path);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - GET");
        String path = servletRequest.getPathInfo();
        try {
            Map parameterMap = servletRequest.getParameterMap();
            MultivaluedMap<String, String> multivaluedMap = ProxyServlet.toMultivaluedMap(parameterMap);
            String response = this.client.proxyGet(path, multivaluedMap);
            servletResponse.getWriter().write(response);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    private static MultivaluedMap<String, String> toMultivaluedMap(Map<String, String[]> inQueryParameters) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        for (Map.Entry<String, String[]> parameter : inQueryParameters.entrySet()) {
            String[] values;
            for (String value : values = parameter.getValue()) {
                queryParams.add((Object)parameter.getKey(), (Object)value);
            }
        }
        return queryParams;
    }

    private static String extractContent(HttpServletRequest servletRequest) throws IOException {
        ServletInputStream inputStream = servletRequest.getInputStream();
        String charEncoding = servletRequest.getCharacterEncoding();
        StringBuilder buf = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)inputStream, charEncoding));){
            String line;
            while ((line = r.readLine()) != null) {
                buf.append(line);
            }
        }
        String content = buf.toString();
        LOGGER.debug("json: {}", (Object)content);
        return content;
    }
}

