/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.standardapis.filter.RolesFilter;
import org.eurekaclinical.standardapis.filter.RolesRequestWrapper;

@Singleton
public class RolesFromServiceFilter
implements RolesFilter {
    private final AuthorizingEurekaClinicalClient client;

    @Inject
    public RolesFromServiceFilter(AuthorizingEurekaClinicalClient inClient) {
        this.client = inClient;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        String username = servletRequest.getRemoteUser();
        if (username != null) {
            try {
                HttpSession session = servletRequest.getSession(false);
                assert (session != null) : "session should not be null";
                Principal principal = servletRequest.getUserPrincipal();
                assert (principal != null) : "principal should not be null";
                List<Role> roles = this.client.getRoles();
                HashMap<Long, Role> idsToRoles = new HashMap<Long, Role>();
                for (Role role : roles) {
                    if (!servletRequest.isUserInRole(role.getName())) continue;
                    idsToRoles.put(role.getId(), role);
                }
                HashSet<String> roleNames = new HashSet<String>();
                for (Map.Entry entry : idsToRoles.entrySet()) {
                    roleNames.add(((Role)entry.getValue()).getName());
                }
                RolesRequestWrapper rolesRequestWrapper = new RolesRequestWrapper(servletRequest, principal, roleNames);
                inChain.doFilter((ServletRequest)rolesRequestWrapper, inResponse);
            }
            catch (ClientException ce) {
                throw new ServletException((Throwable)ce);
            }
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    public void destroy() {
    }
}

