/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.Boundary;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.codehaus.jackson.map.ObjectMapper;
import org.eurekaclinical.common.comm.clients.CasWebResourceWrapperFactory;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.WebResourceWrapper;
import org.eurekaclinical.common.comm.clients.WebResourceWrapperFactory;

public abstract class EurekaClinicalClient
implements AutoCloseable {
    private final WebResourceWrapperFactory webResourceWrapperFactory = new CasWebResourceWrapperFactory();
    private final Class<? extends ContextResolver<? extends ObjectMapper>> contextResolverCls;
    private ApacheHttpClient4 client;
    private final ClientConnectionManager clientConnManager;

    protected EurekaClinicalClient(Class<? extends ContextResolver<? extends ObjectMapper>> cls) {
        this.contextResolverCls = cls;
        DefaultApacheHttpClient4Config clientConfig = new DefaultApacheHttpClient4Config();
        Map properties = clientConfig.getProperties();
        properties.put("com.sun.jersey.impl.client.httpclient.handleCookies", false);
        this.clientConnManager = new ThreadSafeClientConnManager();
        properties.put("com.sun.jersey.impl.client.httpclient.connectionManager", this.clientConnManager);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        if (this.contextResolverCls != null) {
            clientConfig.getClasses().add(this.contextResolverCls);
        }
        this.client = ApacheHttpClient4.create((ClientConfig)clientConfig);
        this.client.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
    }

    @Override
    public void close() {
        this.client.destroy();
        this.clientConnManager.shutdown();
    }

    protected abstract URI getResourceUrl();

    private WebResourceWrapper getResourceWrapper() {
        return this.webResourceWrapperFactory.getInstance(this.client, this.getResourceUrl());
    }

    protected void doDelete(String path) throws ClientException {
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "DELETE").accept(new String[]{"application/json"}).delete(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.NO_CONTENT, ClientResponse.Status.ACCEPTED);
        response.close();
    }

    protected void doPut(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "PUT").type("application/json").accept(new String[]{"application/json"})).put(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPut(String path, Object o) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "PUT").type("application/json").accept(new String[]{"application/json"})).put(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected String doGet(String path) throws ClientException {
        ClientResponse response = this.doGetResponse(path);
        return (String)response.getEntity(String.class);
    }

    protected String doGet(String path, MultivaluedMap<String, String> queryParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET", queryParams).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (String)response.getEntity(String.class);
    }

    protected <T> T doGet(String path, Class<T> cls) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected <T> T doGet(String path, Class<T> cls, MultivaluedMap<String, String> queryParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected ClientResponse doGetResponse(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return response;
    }

    protected <T> T doGet(String path, GenericType<T> genericType) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET").accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected <T> T doGet(String path, GenericType<T> genericType, MultivaluedMap<String, String> queryParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "GET", queryParams).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected <T> T doPost(String path, Class<T> cls, MultivaluedMap<String, String> formParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, formParams);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected <T> T doPost(String path, GenericType<T> genericType, MultivaluedMap<String, String> formParams) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, formParams);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected void doPost(String path) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPost(String path, Object o) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected <T> T doPost(String path, Object o, Class<T> cls) throws ClientException {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI doPostCreate(String path, Object o) throws ClientException {
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED);
        try (ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, o);){
            URI uRI = response.getLocation();
            return uRI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI doPostCreate(String path, InputStream inputStream) throws ClientException {
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED);
        try (ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)inputStream);){
            URI uRI = response.getLocation();
            return uRI;
        }
    }

    protected void doPostMultipart(String path, String filename, InputStream inputStream) throws ClientException {
        FormDataMultiPart part = new FormDataMultiPart();
        part.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName(filename)).build(), (Object)inputStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "POST").type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)part);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.CREATED);
        response.close();
    }

    protected void errorIfStatusEqualTo(ClientResponse response, ClientResponse.Status ... status) throws ClientException {
        this.errorIf(response, status, true);
    }

    protected void errorIfStatusNotEqualTo(ClientResponse response, ClientResponse.Status ... status) throws ClientException {
        this.errorIf(response, status, false);
    }

    protected Long extractId(URI uri) {
        String uriStr = uri.toString();
        return Long.valueOf(uriStr.substring(uriStr.lastIndexOf("/") + 1));
    }

    private void errorIf(ClientResponse response, ClientResponse.Status[] status, boolean bool) throws ClientException {
        ClientResponse.Status clientResponseStatus = response.getClientResponseStatus();
        if (bool) {
            if (EurekaClinicalClient.contains(status, clientResponseStatus)) {
                String message = (String)response.getEntity(String.class);
                throw new ClientException(clientResponseStatus, message);
            }
        } else if (!EurekaClinicalClient.contains(status, clientResponseStatus)) {
            String message = (String)response.getEntity(String.class);
            throw new ClientException(clientResponseStatus, message);
        }
    }

    private static boolean contains(Object[] arr, Object member) {
        for (Object mem : arr) {
            if (!Objects.equals(mem, member)) continue;
            return true;
        }
        return false;
    }
}

