/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import com.google.inject.Injector;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalProxyClient;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.standardapis.filter.RolesFilter;
import org.eurekaclinical.standardapis.filter.RolesRequestWrapper;

@Singleton
public class RolesFromServiceFilter
implements RolesFilter {
    private final Injector injector;

    @Inject
    public RolesFromServiceFilter(Injector inInjector) {
        this.injector = inInjector;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        String username = servletRequest.getRemoteUser();
        if (username != null) {
            AuthorizingEurekaClinicalProxyClient client = (AuthorizingEurekaClinicalProxyClient)this.injector.getInstance(AuthorizingEurekaClinicalProxyClient.class);
            try {
                HttpSession session = servletRequest.getSession(false);
                assert (session != null) : "session should not be null";
                Principal principal = servletRequest.getUserPrincipal();
                assert (principal != null) : "principal should not be null";
                List<Role> roles = client.getRoles();
                User user = client.getMe();
                List<Long> roleIds = user.getRoles();
                HashSet<String> roleNames = new HashSet<String>();
                for (Role role : roles) {
                    if (!roleIds.contains(role.getId())) continue;
                    roleNames.add(role.getName());
                }
                RolesRequestWrapper wrappedRequest = new RolesRequestWrapper(servletRequest, principal, roleNames);
                inChain.doFilter((ServletRequest)wrappedRequest, inResponse);
            }
            catch (ClientException ce) {
                throw new ServletException((Throwable)ce);
            }
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    public void destroy() {
    }
}

